package me.alexisevelyn.randomtech.api.blockentities;

import org.jetbrains.annotations.Nullable;
import reborncore.api.IToolDrop;
import reborncore.api.blockentity.IUpgrade;
import reborncore.api.blockentity.InventoryProvider;
import reborncore.client.screen.BuiltScreenHandlerProvider;
import reborncore.client.screen.builder.BuiltScreenHandler;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;
import reborncore.common.util.RebornInventory;

import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

/**
 * The type Base power acceptor block entity.
 */
public abstract class BasePowerAcceptorBlockEntity extends PowerAcceptorBlockEntity implements IToolDrop, InventoryProvider, BuiltScreenHandlerProvider {
    // Energy Values
    @SuppressWarnings("CanBeFinal") double minPower = 0;
    @SuppressWarnings("CanBeFinal") double maxPower = 10000;
    @SuppressWarnings("CanBeFinal") double maxInput = 10000;

    @SuppressWarnings("CanBeFinal") double maxOutput = 0;

    @SuppressWarnings("CanBeFinal") boolean canAcceptEnergy = true;
    @SuppressWarnings("CanBeFinal") boolean canProvideEnergy = false;

    public RebornInventory<?> inventory;

    /**
     * Instantiates a new Base power acceptor block entity.
     *
     * @param blockEntityType the block entity type
     */
    public BasePowerAcceptorBlockEntity(class_2591<?> blockEntityType) {
        super(blockEntityType);
    }

    /**
     * Tick.
     */
    @SuppressWarnings("EmptyMethod")
    @Override
    public void method_16896() {
        super.method_16896();
    }

    /**
     * Gets base max power.
     *
     * @return the base max power
     */
    @Override
    public double getBaseMaxPower() {
        return maxPower;
    }

    /**
     * Gets base max output.
     *
     * @return the base max output
     */
    @Override
    public double getBaseMaxOutput() {
        return maxOutput;
    }

    /**
     * Gets base max input.
     *
     * @return the base max input
     */
    @Override
    public double getBaseMaxInput() {
        return maxInput;
    }

    /**
     * Returns the maximum number of items a stack can contain when placed inside this inventory.
     * No slots may have more than this number of items. It is effectively the
     * stacking limit for this inventory's slots.
     *
     * @return the max {@link ItemStack#getCount() count} of item stacks in this inventory
     */
    @Override
    public int method_5444() {
        return inventory.method_5444();
    }

    /**
     * Returns the number of times the specified item occurs in this inventory across all stored stacks.
     *
     * @param item Item to check for
     */
    @Override
    public int method_18861(class_1792 item) {
        return inventory.method_18861(item);
    }

    /**
     * Determines whether this inventory contains any of the given candidate items.
     *
     * @param items Items to check for
     */
    @Override
    public boolean method_18862(Set<class_1792> items) {
        return inventory.method_18862(items);
    }

    /**
     * On open.
     *
     * @param player the player
     */
    @Override
    public void method_5435(class_1657 player) {

    }

    /**
     * On close.
     *
     * @param player the player
     */
    @Override
    public void method_5432(class_1657 player) {

    }

    /**
     * Gets tool drop.
     *
     * @param playerEntity the player entity
     * @return the tool drop
     */
    // Used for TR's Wrench
    @Nullable
    public class_1799 getToolDrop(class_1657 playerEntity) {
        return null;
    }

    /**
     * Can be upgraded boolean.
     *
     * @return the boolean
     */
    @Override
    public boolean canBeUpgraded() {
        return false;
    }

    /**
     * Is upgrade valid boolean.
     *
     * @param upgrade the upgrade
     * @param stack   the stack
     * @return the boolean
     */
    @Override
    public boolean isUpgradeValid(IUpgrade upgrade, class_1799 stack) {
        return false;
    }

    /**
     * Has enough energy boolean.
     *
     * @param energyAddend the energy addend
     * @return the boolean
     */
    public boolean hasEnoughEnergy(int energyAddend) {
        return getEnergy() >= energyAddend;
    }

    /**
     * Gets min power.
     *
     * @return the min power
     */
    // Future Proofing
    @SuppressWarnings({"SameReturnValue"})
    public double getMinPower() {
        return this.minPower;
    }

    /**
     * Can accept energy boolean.
     *
     * @param direction the direction
     * @return the boolean
     */
    @Override
    public boolean canAcceptEnergy(final class_2350 direction) {
        return canAcceptEnergy;
    }

    /**
     * Can provide energy boolean.
     *
     * @param direction the direction
     * @return the boolean
     */
    @Override
    public boolean canProvideEnergy(final class_2350 direction) {
        return canProvideEnergy;
    }

    /**
     * On load.
     */
    @SuppressWarnings("EmptyMethod")
    @Override
    public void onLoad() {
        super.onLoad();
    }

    /**
     * Gets inventory.
     *
     * @return the inventory
     */
    @Override
    public class_1263 getInventory() {
        return inventory;
    }

    /**
     * Create screen handler built screen handler.
     *
     * @param syncID the sync id
     * @param player the player
     * @return the built screen handler
     */
    @Nullable
    @Override
    public BuiltScreenHandler createScreenHandler(int syncID, class_1657 player) {
        return null;
    }

    /**
     * From tag.
     *
     * @param blockState  the block state
     * @param compoundTag the compound tag
     */
    @Override
    public void method_11014(class_2680 blockState, class_2487 compoundTag) {
        super.method_11014(blockState, compoundTag);
    }

    /**
     * To tag compound tag.
     *
     * @param compoundTag the compound tag
     * @return the compound tag
     */
    @Override
    public class_2487 method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);

        return compoundTag;
    }
}
