package me.alexisevelyn.randomtech.api.blockentities;

import net.minecraft.class_2591;
import net.minecraft.class_3576;
import net.minecraft.class_3611;
import reborncore.common.fluid.FluidValue;
import reborncore.common.fluid.container.FluidInstance;
import reborncore.common.util.Tank;

/**
 * The type Fluid machine block entity base.
 */
public abstract class FluidMachineBlockEntityBase extends BasePowerAcceptorBlockEntity {
    protected Tank tank;

    /**
     * Instantiates a new Fluid machine block entity base.
     *
     * @param blockEntityType the block entity type
     */
    public FluidMachineBlockEntityBase(class_2591<?> blockEntityType) {
        super(blockEntityType);
    }

    /**
     * Tick.
     */
    @SuppressWarnings("EmptyMethod")
    @Override
    public void method_16896() {
        super.method_16896();
    }

    /**
     * Gets max fluid level.
     *
     * @return the max fluid level
     */
    public FluidValue getMaxFluidLevel() {
        return tank.getCapacity();
    }

    /**
     * Gets fluid level.
     *
     * @return the fluid level
     */
    public FluidValue getFluidLevel() {
        // tank.getFluidAmount();
        return tank.getFluidInstance().getAmount();
    }

    /**
     * Gets tank.
     *
     * @return the tank
     */
    @Override
    public Tank getTank() {
        return tank;
    }

    /**
     * Gets fluid.
     *
     * @return the fluid
     */
    public FluidInstance getFluid() {
        return tank.getFluidInstance();
    }

    /**
     * Gets fluid type.
     *
     * @return the fluid type
     */
    public class_3611 getFluidType() {
        return tank.getFluid();
    }

    /**
     * Sets fluid amount.
     *
     * @param fluidAmount the fluid amount
     */
    public void setFluidAmount(FluidValue fluidAmount) {
        tank.getFluidInstance().setAmount(fluidAmount);
    }

    /**
     * Sets fluid.
     *
     * @param fluid the fluid
     */
    public void setFluid(class_3611 fluid) {
        tank.setFluid(fluid);
    }

    /**
     * Is empty boolean.
     *
     * @return the boolean
     */
    public boolean method_5442() {
        return tank.isEmpty();
    }

    /**
     * Has fluid boolean.
     *
     * @return the boolean
     */
    public boolean hasFluid() {
        return !(tank.getFluid() instanceof class_3576);
    }
}
