package me.alexisevelyn.randomtech.api.blocks.fluids;

import org.jetbrains.annotations.Nullable;

import java.util.function.ToIntFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3609;

/**
 * The type Base fluid block.
 */
public abstract class BaseFluidBlock extends class_2404 {
    /**
     * Instantiates a new Base fluid block.
     *
     * @param fluid    the fluid
     * @param settings the settings
     */
    public BaseFluidBlock(class_3609 fluid, class_2251 settings) {
        super(fluid, settings);
    }

    /**
     * On entity collision.
     *
     * @param state  the state
     * @param world  the world
     * @param pos    the pos
     * @param entity the entity
     */
    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        //super.onEntityCollision(state, world, pos, entity);

        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309) entity;

            applyEffects(livingEntity);
        }

        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657) entity;

            if (isEyeInFluid(playerEntity, pos))
                applyShader(playerEntity);
            else
                removeShader(playerEntity);
        }
    }

    /**
     * Apply effects.
     *
     * @param livingEntity the living entity
     */
    // These exist solely to override from other fluids.
    // I may eventually turn this into an interface
    protected abstract void applyEffects(class_1309 livingEntity);

    /**
     * Apply shader.
     *
     * @param playerEntity the player entity
     */
    @SuppressWarnings("EmptyMethod") protected abstract void applyShader(class_1657 playerEntity);

    /**
     * Remove shader.
     *
     * @param playerEntity the player entity
     */
    @SuppressWarnings("EmptyMethod") protected abstract void removeShader(class_1657 playerEntity);

    /**
     * Is eye in fluid boolean.
     *
     * @param playerEntity the player entity
     * @param blockPos     the block pos
     * @return the boolean
     */
    public boolean isEyeInFluid(class_1657 playerEntity, class_2338 blockPos) {
        // This activates the same as water would. Can be used to determine if needing to apply shaders.
        return (int) playerEntity.method_23320() == blockPos.method_10264() && playerEntity.method_24515().method_10260() == blockPos.method_10260() && playerEntity.method_24515().method_10263() == blockPos.method_10263();
    }

    /**
     * Gets light level.
     *
     * @param currentFluidLevel the current fluid level
     * @return the light level
     */
    public static int getLightLevel(@Nullable Integer currentFluidLevel) {
        int minLightLevel = 0;
        int maxLightLevel = 15;

        int maxFluidLevel = 8;

        // For When Blockstate is Missing Level
        if (currentFluidLevel == null)
            currentFluidLevel = 8;

        int currentLightLevel = ((currentFluidLevel * maxLightLevel) / maxFluidLevel) + minLightLevel;

        // Note: I have to invert the light level as for some reason, Minecraft has fluids produce the
        // exact inverse of the light level than what is expected when basing it off of fluid levels.
        // This is not a problem with the formula above. I'm not sure why it does that though.
        return (-1 * currentLightLevel) + 15;
    }

    /**
     * Gets light level.
     *
     * @return the light level
     */
    public static ToIntFunction<class_2680> getLightLevel() {
        return (state) -> getLightLevel(state.method_11654(field_11278));
    }

    /**
     * Gets zero light level.
     *
     * @return the zero light level
     */
    public static ToIntFunction<class_2680> getZeroLightLevel() {
        return (state) -> 0;
    }
}
