package me.alexisevelyn.randomtech.api.blocks.glass;

import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_4262;

/**
 * The type Base powered glass.
 */
public abstract class BasePoweredGlass extends class_4262 {
    public static final class_2758 POWER = class_2758.method_11867("power", 0, 15);

    /**
     * Instantiates a new Base powered glass.
     *
     * @param settings the settings
     */
    public BasePoweredGlass(class_2251 settings) {
        super(settings);

        method_9590(method_9595()
                .method_11664()
                .method_11657(POWER, 0)
        );
    }

    /**
     * Neighbor update.
     *
     * @param state   the state
     * @param world   the world
     * @param pos     the pos
     * @param block   the block
     * @param fromPos the from pos
     * @param notify  the notify
     */
    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        // world.getReceivedStrongRedstonePower(pos);
        // world.getReceivedRedstonePower(pos);

        // The problem with this is, the glass powers other glass and therefor cannot unpower
//        if (world.isReceivingRedstonePower(pos) != state.get(POWERED))
//            world.setBlockState(pos, state.cycle(POWERED));

        world.method_8501(pos, state.method_11657(POWER, world.method_8482(pos)));
    }

    /**
     * Gets weak redstone power.
     *
     * @param state     the state
     * @param world     the world
     * @param pos       the pos
     * @param direction the direction
     * @return the weak redstone power
     */
    @Override
    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        if (state.method_11654(POWER) > 0)
            return state.method_11654(POWER) - 1;

        return 0;
    }

    /**
     * Gets strong redstone power.
     *
     * @param state     the state
     * @param world     the world
     * @param pos       the pos
     * @param direction the direction
     * @return the strong redstone power
     */
    @Override
    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return super.method_9603(state, world, pos, direction);
    }

    /**
     * Emits redstone power boolean.
     *
     * @param state the state
     * @return the boolean
     */
    @Override
    public boolean method_9506(class_2680 state) {
        if (state.method_11654(POWER) > 0)
            return true;

        return super.method_9506(state);
    }

    /**
     * Has comparator output boolean.
     *
     * @param state the state
     * @return the boolean
     */
    @Override
    public boolean method_9498(class_2680 state) {
        return super.method_9498(state);
    }

    /**
     * Gets comparator output.
     *
     * @param state the state
     * @param world the world
     * @param pos   the pos
     * @return the comparator output
     */
    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return super.method_9572(state, world, pos);
    }

    /**
     * Append properties.
     *
     * @param builder the builder
     */
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(POWER);
    }

    /**
     * Gets redstone strength.
     *
     * @param blockState the block state
     * @return the redstone strength
     */
    public int getRedstoneStrength(class_2680 blockState) {
        return blockState.method_11654(POWER);
    }
}
