package me.alexisevelyn.randomtech.api.blocks.machines;

import me.alexisevelyn.randomtech.api.blockentities.FluidMachineBlockEntityBase;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import reborncore.common.fluid.FluidValue;

/**
 * The type Fluid machine base.
 */
public abstract class FluidMachineBase extends PowerAcceptorBlock {
    /**
     * Instantiates a new Fluid machine base.
     *
     * @param settings the settings
     */
    public FluidMachineBase(class_4970.class_2251 settings) {
        super(settings);
    }

    /**
     * Instantiates a new Fluid machine base.
     *
     * @param settings     the settings
     * @param customStates the custom states
     */
    public FluidMachineBase(class_4970.class_2251 settings, boolean customStates) {
        super(settings, customStates);
    }

    /**
     * Gets fluid level.
     *
     * @param state the state
     * @param world the world
     * @param pos   the pos
     * @return the fluid level
     */
    @Nullable
    public FluidValue getFluidLevel(class_2680 state, class_1937 world, class_2338 pos) {
        FluidMachineBlockEntityBase fluidMachineBlockEntity = (FluidMachineBlockEntityBase) world.method_8321(pos);

        if (fluidMachineBlockEntity == null) {
            return null;
        }

        return fluidMachineBlockEntity.getFluidLevel();
    }

    /**
     * Gets max fluid level.
     *
     * @param state the state
     * @param world the world
     * @param pos   the pos
     * @return the max fluid level
     */
    @Nullable
    public FluidValue getMaxFluidLevel(class_2680 state, class_1937 world, class_2338 pos) {
        FluidMachineBlockEntityBase fluidMachineBlockEntity = (FluidMachineBlockEntityBase) world.method_8321(pos);

        if (fluidMachineBlockEntity == null) {
            return null;
        }

        return fluidMachineBlockEntity.getMaxFluidLevel();
    }
}
