package me.alexisevelyn.randomtech.api.blocks.machines;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import reborncore.api.blockentity.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.PowerAcceptorBlockEntity;

/**
 * The type Power acceptor block.
 */
public abstract class PowerAcceptorBlock extends BlockMachineBase {
    /**
     * Instantiates a new Power acceptor block.
     *
     * @param settings the settings
     */
    public PowerAcceptorBlock(class_4970.class_2251 settings) {
        super(settings, false);
    }

    /**
     * Instantiates a new Power acceptor block.
     *
     * @param settings     the settings
     * @param customStates the custom states
     */
    public PowerAcceptorBlock(class_4970.class_2251 settings, boolean customStates) {
        super(settings, customStates);
    }

    /**
     * Gets gui.
     *
     * @return the gui
     */
    @Nullable
    @Override
    public IMachineGuiHandler getGui() {
        return null;
    }

    /**
     * Has comparator output boolean.
     *
     * @param state the state
     * @return the boolean
     */
    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    /**
     * Gets comparator output.
     *
     * @param state the state
     * @param world the world
     * @param pos   the pos
     * @return the comparator output
     */
    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return PowerAcceptorBlockEntity.calculateComparatorOutputFromEnergy(world.method_8321(pos));
    }

    /**
     * Gets power.
     *
     * @param world the world
     * @param pos   the pos
     * @return the power
     */
    public double getPower(class_1937 world, class_2338 pos) {
        PowerAcceptorBlockEntity powerAcceptorBlockEntity = (PowerAcceptorBlockEntity) world.method_8321(pos);

        if (powerAcceptorBlockEntity == null) {
            return -1.0;
        }

        return powerAcceptorBlockEntity.getEnergy();
    }

    /**
     * Gets max power.
     *
     * @param world the world
     * @param pos   the pos
     * @return the max power
     */
    public double getMaxPower(class_1937 world, class_2338 pos) {
        PowerAcceptorBlockEntity powerAcceptorBlockEntity = (PowerAcceptorBlockEntity) world.method_8321(pos);

        if (powerAcceptorBlockEntity == null) {
            return -1.0;
        }

        return powerAcceptorBlockEntity.getBaseMaxPower();
    }
}
