package me.alexisevelyn.randomtech.api.fluids;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;
import java.util.Map;
import java.util.Random;

/**
 * The type Base fluid.
 */
public abstract class BaseFluid extends class_3609 {
    /**
     * @return a dripping particle effect. Requires a dripping particle to be visible?
     */
    @Override
    @Environment(EnvType.CLIENT)
    public class_2394 method_15787() {
        return super.method_15787();
    }

    /**
     * @return is the given fluid an instance of this fluid?
     */
    @Override
    public boolean method_15780(class_3611 fluid) {
        return fluid == method_15751() || fluid == method_15750();
    }

    /**
     * @return is the fluid infinite like water?
     */
    @Override
    protected boolean method_15737() {
        return false;
    }

    /**
     * Perform actions when fluid flows into a replaceable block. Water drops
     * the block's loot table. Lava plays the "block.lava.extinguish" sound.
     */
    @Override
    protected void method_15730(class_1936 world, class_2338 pos, class_2680 state) {
        final class_2586 blockEntity = state.method_26204().method_26161() ? world.method_8321(pos) : null;
        class_2248.method_9610(state, world, pos, blockEntity);
    }

    /**
     * Lava returns true if its FluidState is above a certain height and the
     * Fluid is Water.
     *
     * @return if the given Fluid can flow into this FluidState?
     */
    @Override
    protected boolean method_15777(class_3610 fluidState, class_1922 blockView, class_2338 blockPos, class_3611 fluid, class_2350 direction) {
        return direction == class_2350.field_11033 && !fluid.method_15791(class_3486.field_15517);
    }

    /**
     * Water returns 1. Lava returns 2 in the Overworld and 1 in the Nether.
     */
    @Override
    protected int method_15739(class_4538 worldView) {
        return 1;
    }

    /**
     * Water returns 5. Lava returns 30 in the Overworld and 10 in the Nether.
     */
    @Override
    public int method_15789(class_4538 worldView) {
        return 5;
    }

    /**
     * Water and Lava both return 100.0F.
     */
    @Override
    protected float method_15784() {
        return 100.0F;
    }

    /**
     * Calculate level int.
     *
     * @param state the state
     * @return the int
     */
    protected static int calculateLevel(class_3610 state) {
        return state.method_15771() ? 0 : 8 - Math.min(state.method_15761(), 8) + (state.method_11654(field_15902) ? 8 : 0);
    }

    /**
     * On random tick.
     *
     * @param world  the world
     * @param pos    the pos
     * @param state  the state
     * @param random the random
     */
    @Override
    public void method_15792(class_1937 world, class_2338 pos, class_3610 state, Random random) {
        super.method_15792(world, pos, state, random);
    }

    /**
     * Gets velocity.
     *
     * @param world the world
     * @param pos   the pos
     * @param state the state
     * @return the velocity
     */
    @Override
    public class_243 method_15782(class_1922 world, class_2338 pos, class_3610 state) {
        return super.method_15782(world, pos, state);
    }

    /**
     * Gets spread.
     *
     * @param world the world
     * @param pos   the pos
     * @param state the state
     * @return the spread
     */
    @Override
    protected Map<class_2350, class_3610> method_15726(class_4538 world, class_2338 pos, class_2680 state) {
        return super.method_15726(world, pos, state);
    }

    /**
     * On scheduled tick.
     *
     * @param world the world
     * @param pos   the pos
     * @param state the state
     */
    @Override
    public void method_15778(class_1937 world, class_2338 pos, class_3610 state) {
        super.method_15778(world, pos, state);
    }
}
