package me.alexisevelyn.randomtech.api.items.armor.generic;

import com.google.common.collect.Multimap;
import me.alexisevelyn.randomtech.api.items.energy.EnergyHelper;
import me.alexisevelyn.randomtech.api.utilities.ItemManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1885;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.api.items.ArmorFovHandler;
import reborncore.api.items.ArmorRemoveHandler;
import reborncore.api.items.ArmorTickable;
import reborncore.api.items.ItemStackModifiers;
import reborncore.common.util.ItemDurabilityExtensions;
import reborncore.common.util.ItemUtils;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergyHolder;
import team.reborn.energy.EnergyTier;

import java.util.List;
import java.util.UUID;

/**
 * The type Generic powered armor.
 */
public abstract class GenericPoweredArmor extends class_1738 implements EnergyHelper, ItemDurabilityExtensions, ItemStackModifiers, ArmorTickable, ArmorRemoveHandler, ArmorFovHandler, EnergyHolder, InvulnerabilityHandler, SecondaryTextureHandler {
    private final int maxCharge;
    private final int cost;

    private final EnergyTier tier;
    private final String dischargedTranslationKey;

    // Figure out how these UUIDs were determined. Mojang has hardcoded UUIDs too.
    public static final UUID[] MODIFIERS = new UUID[]{
            UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"),
            UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"),
            UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"),
            UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")
    };

    /**
     * Instantiates a new Generic powered armor.
     *
     * @param material                 the material
     * @param slot                     the slot
     * @param energyCapacity           the energy capacity
     * @param tier                     the tier
     * @param cost                     the cost
     * @param settings                 the settings
     * @param dischargedTranslationKey the discharged translation key
     */
    public GenericPoweredArmor(class_1741 material, class_1304 slot, int energyCapacity, EnergyTier tier, int cost, class_1793 settings, @Nullable String dischargedTranslationKey) {
        super(material, slot, settings.method_7895(-1).method_7889(1));

        this.maxCharge = energyCapacity;
        this.cost = cost;
        this.tier = tier;
        this.dischargedTranslationKey = dischargedTranslationKey;
    }

    /**
     * Gets name.
     *
     * @param stack the stack
     * @return the name
     */
    @Override
    @Environment(EnvType.CLIENT)
    public class_2561 method_7864(class_1799 stack) {
        return new class_2588(this.method_7866(stack));
    }

    /**
     * Gets secondary armor texture.
     *
     * @param itemStack the item stack
     * @return the secondary armor texture
     */
    @Override
    public @Nullable String getSecondaryArmorTexture(class_1309 livingEntity, class_1799 itemStack) {
        int minPowerLevel = 0;
        int maxPowerLevel = 15;

        double currentEnergy = this.getEnergy(itemStack);
        double maxEnergy = this.getMaxEnergy(itemStack);

        double currentPowerLevel = ((currentEnergy * maxPowerLevel) / maxEnergy) + minPowerLevel;

        return String.valueOf((int) Math.floor(Math.min(Math.max(currentPowerLevel, minPowerLevel), maxPowerLevel)));
    }

    @Override
    public @NotNull class_1304 getArmorSlot() {
        return this.method_7685();
    }

    /**
     * Gets translation key.
     *
     * @param stack the stack
     * @return the translation key
     */
    @Override
    public String method_7866(class_1799 stack) {
        if (isUsable(stack) || this.dischargedTranslationKey == null)
            return super.method_7866(stack);

        return this.dischargedTranslationKey;
    }

    /**
     * Is not full boolean.
     *
     * @param stack the stack
     * @return the boolean
     */
    @Override
    public boolean isNotFull(class_1799 stack) {
        return getEnergy(stack) != getMaxEnergy(stack);
    }

    /**
     * Is usable boolean.
     *
     * @param stack the stack
     * @return the boolean
     */
    @Override
    public boolean isUsable(class_1799 stack) {
        return Energy.of(stack).getEnergy() >= this.cost;
    }

    /**
     * Gets energy.
     *
     * @param stack the stack
     * @return the energy
     */
    @Override
    public double getEnergy(class_1799 stack) {
        return Energy.of(stack).getEnergy();
    }

    /**
     * Sets energy.
     *
     * @param stack  the stack
     * @param energy the energy
     */
    @Override
    public void setEnergy(class_1799 stack, double energy) {
        Energy.of(stack).set(energy);
    }

    /**
     * Is fireproof boolean.
     *
     * @return the boolean
     */
    @SuppressWarnings("EmptyMethod")
    @Override
    public boolean method_24358() {
        return super.method_24358();
    }

    /**
     * Change fov float.
     *
     * @param oldFOV       the old fov
     * @param stack        the stack
     * @param playerEntity the player entity
     * @return the float
     */
    @Override
    public float changeFov(float oldFOV, class_1799 stack, class_1657 playerEntity) {
        return oldFOV; // This is set to old so I can see what I'm doing while testing the armor.
    }

    /**
     * On removed.
     *
     * @param playerEntity the player entity
     */
    @Override
    public void onRemoved(class_1657 playerEntity) {
        // Actions to perform when armor is removed
    }

    /**
     * Inventory tick.
     *
     * @param stack    the stack
     * @param world    the world
     * @param entity   the entity
     * @param slot     the slot
     * @param selected the selected
     */
    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
    }

    /**
     * Tick armor.
     *
     * @param stack        the stack
     * @param playerEntity the player entity
     */
    @Override
    public void tickArmor(class_1799 stack, class_1657 playerEntity) {
        // Actions to perform every tick (only when armor is worn?)

//        switch (this.slot) {
//            case HEAD: break;
//            case CHEST: break;
//            case LEGS: break;
//            case FEET: break;
//            case MAINHAND: break;
//            case OFFHAND: break;
//        }
    }

    /**
     * Gets attribute modifiers.
     *
     * @param equipmentSlot the equipment slot
     * @param stack         the stack
     * @param builder       the builder
     */
    @Override
    public void getAttributeModifiers(class_1304 equipmentSlot, class_1799 stack, Multimap<class_1320, class_1322> builder) {
        // Modify Armor Attributes Dynamically

        builder.removeAll(class_5134.field_23719);
        builder.removeAll(class_5134.field_23724); // Remove preset armor just so we can dynamically choose to break the protection if the battery dies.
        builder.removeAll(class_5134.field_23725);

//        if (this.slot == EquipmentSlot.LEGS && equipmentSlot == EquipmentSlot.LEGS) {
//            if (isUsable(stack)) {
//                builder.put(EntityAttributes.GENERIC_MOVEMENT_SPEED, new EntityAttributeModifier(MODIFIERS[equipmentSlot.getEntitySlotId()], "Movement Speed", 0.15, EntityAttributeModifier.Operation.ADDITION));
//            }
//        }

        if (equipmentSlot == this.field_7880 && isUsable(stack)) {
            builder.put(class_5134.field_23724, new class_1322(MODIFIERS[field_7880.method_5927()], "Armor modifier", method_7686().method_7697(equipmentSlot), class_1322.class_1323.field_6328));
            builder.put(class_5134.field_23725, new class_1322(MODIFIERS[field_7880.method_5927()], "Armor Toughness modifier", method_7686().method_7700(), class_1322.class_1323.field_6328));
            builder.put(class_5134.field_23718, new class_1322(MODIFIERS[field_7880.method_5927()], "Knockback modifier", method_7686().method_24355(), class_1322.class_1323.field_6328));
        }
    }

    /**
     * Gets max energy.
     *
     * @param itemStack the item stack
     * @return the max energy
     */
    @Override
    public double getMaxEnergy(class_1799 itemStack) {
        // RebornCore uses getMaxStoredPower() for their hud.
        // That makes it where the max energy cannot be set per ItemStack.
        // Once I implement dynamic max energy, my code will be able to get the dynamic max energy.

        return getMaxStoredPower();
    }

    /**
     * Gets max stored power.
     *
     * @return the max stored power
     */
    @Override
    public double getMaxStoredPower() {
        return this.maxCharge;
    }

    /**
     * Gets tier.
     *
     * @return the tier
     */
    @Override
    public EnergyTier getTier() {
        return this.tier;
    }

    /**
     * Gets durability.
     *
     * @param stack the stack
     * @return the durability
     */
    @Override
    public double getDurability(class_1799 stack) {
        // Replace this with a dynamic durability bar checker.
        return 1 - ItemUtils.getPowerForDurabilityBar(stack);
    }

    /**
     * Show durability boolean.
     *
     * @param stack the stack
     * @return the boolean
     */
    @Override
    public boolean showDurability(class_1799 stack) {
        if (!(stack.method_7909() instanceof EnergyHelper))
            return true;

        double currentEnergy = Energy.of(stack).getEnergy();
        double maxEnergy = getMaxEnergy(stack);

        return currentEnergy < maxEnergy;
    }

    /**
     * Gets durability color.
     *
     * @param stack the stack
     * @return the durability color
     */
    @Override
    public int getDurabilityColor(class_1799 stack) {
        // Red - PowerSystem.getDisplayPower().colour;
        // Darker Red - PowerSystem.getDisplayPower().altColour;
        // Blue - 0xFF0014A2
        // Green - 0xFF006700

        return 0xFF0014A2;
    }

    /**
     * Is enchantable boolean.
     *
     * @param stack the stack
     * @return the boolean
     */
    // This only applies to the enchantment table, not anvils?
    @Override
    public boolean method_7870(class_1799 stack) {
        return true;
    }

    /**
     * Can repair boolean.
     *
     * @param toolStack   the tool stack
     * @param repairStack the repair stack
     * @return the boolean
     */
    @Override
    public boolean method_7878(class_1799 toolStack, class_1799 repairStack) {
        return false;
    }

    /**
     * Append stacks.
     *
     * @param group    the group
     * @param itemList the item list
     */
    @Environment(EnvType.CLIENT)
    @Override
    public void method_7850(class_1761 group, class_2371<class_1799> itemList) {
        // Can be used to add multiple versions of items (e.g. a charged and discharged variant of each armor piece)
        if (!method_7877(group)) {
            return;
        }

        ItemManager.initPoweredItems(this, itemList);
    }

    /**
     * Gets protection.
     *
     * @return the protection
     */
    // Armor Protection Level
    @SuppressWarnings("EmptyMethod")
    @Override
    public int method_7687() {
        return super.method_7687();
    }

    /**
     * Method 26353 float.
     *
     * @return the float
     */
    // Armor Toughness Level
    @SuppressWarnings("EmptyMethod")
    @Override
    public float method_26353() {
        return super.method_26353();
    }

    /**
     * Add damage.
     *
     * @param stack        the stack
     * @param livingEntity the living entity
     * @param damageSource the damage source
     * @param damage       the damage
     */
    public void addDamage(class_1799 stack, class_1309 livingEntity, class_1282 damageSource, float damage) {
        if (!(stack.method_7909() instanceof EnergyHelper))
            return;

        // Adds support for Unbreaking Enchants
        // This seems to occur more rarely than vanilla armor. I'm not sure if that's true though.
        int unbreakingLevel = class_1890.method_8225(class_1893.field_9119, stack);
        boolean shouldPreventDamage = class_1885.method_8176(stack, unbreakingLevel, livingEntity.method_6051());

        if (shouldPreventDamage)
            return;

        ItemManager.useEnergy(livingEntity, stack, cost);
    }

    /**
     * On craft item stack.
     *
     * @param oldStack the old stack
     * @param newStack the new stack
     * @param tag      the tag
     * @return the item stack
     */
    @Override
    public class_1799 onCraft(class_1799 oldStack, class_1799 newStack, class_2487 tag) {
        return ItemManager.convertStackToEnergyItemStack(oldStack, newStack, tag);
    }

    /**
     * Append tooltip.
     *
     * @param stack   the stack
     * @param worldIn the world in
     * @param tooltip the tooltip
     * @param flagIn  the flag in
     */
    @Environment(EnvType.CLIENT)
    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (flagIn.method_8035())
            ItemManager.powerLevelTooltip(stack, tooltip);
    }

    /**
     * Deny kill command boolean.
     *
     * @param itemStack    the item stack
     * @param livingEntity the living entity
     * @return the boolean
     */
    @Override
    public boolean denyKillCommand(class_1799 itemStack, class_1309 livingEntity) {
        return false;
    }

    /**
     * Deny general damage boolean.
     *
     * @param itemStack    the item stack
     * @param damageSource the damage source
     * @param amount       the amount
     * @param livingEntity the living entity
     * @return the boolean
     */
    @Override
    public boolean denyGeneralDamage(class_1799 itemStack, class_1282 damageSource, float amount, class_1309 livingEntity) {
        return false;
    }
}
