package me.alexisevelyn.randomtech.api.items.armor.generic;

import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_5151;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * For allowing armor to have more than one texture visible to other players of the wearer
 */
public interface SecondaryTextureHandler extends class_5151 {
    /**
     * Retrieve secondary texture that the armor may have based on it's itemstack and the wearer.
     *
     * @param livingEntity
     * @param itemStack
     * @return
     */
    @Nullable String getSecondaryArmorTexture(class_1309 livingEntity, class_1799 itemStack);

    /**
     * The armor slot meant to be used by this armor.
     *
     * @return Slot armor was meant to be worn on
     */
    @NotNull class_1304 getArmorSlot();
}
