package me.alexisevelyn.randomtech.api.items.energy;

import net.minecraft.class_1799;
import net.minecraft.class_2487;

/**
 * The interface Energy helper.
 */
public interface EnergyHelper {
    // This exists for both GenericPoweredTool and GenericPoweredArmor.
    // This makes it easier to target both classes in my mixins.

    /**
     * Is not full boolean.
     *
     * @param stack the stack
     * @return the boolean
     */
    boolean isNotFull(class_1799 stack);

    /**
     * Is usable boolean.
     *
     * @param stack the stack
     * @return the boolean
     */
    boolean isUsable(class_1799 stack);

    /**
     * Gets energy.
     *
     * @param stack the stack
     * @return the energy
     */
    double getEnergy(class_1799 stack);

    /**
     * Sets energy.
     *
     * @param stack  the stack
     * @param energy the energy
     */
    void setEnergy(class_1799 stack, double energy);

    /**
     * Gets max energy.
     *
     * @param stack the stack
     * @return the max energy
     */
    double getMaxEnergy(class_1799 stack);

    /**
     * On craft item stack.
     *
     * @param oldStack the old stack
     * @param newStack the new stack
     * @param tag      the tag
     * @return the item stack
     */
    class_1799 onCraft(class_1799 oldStack, class_1799 newStack, class_2487 tag);
}
