package me.alexisevelyn.randomtech.api.items.tools.generic;

import me.alexisevelyn.randomtech.api.utilities.ItemManager;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3614;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.EnergyTier;

/**
 * The type Generic powered axe.
 */
public abstract class GenericPoweredAxe extends GenericPoweredTool {
    private static final float attackDamage = 5.0F;

    /**
     * Instantiates a new Generic powered axe.
     *
     * @param material                 the material
     * @param energyCapacity           the energy capacity
     * @param tier                     the tier
     * @param cost                     the cost
     * @param poweredSpeed             the powered speed
     * @param unpoweredSpeed           the unpowered speed
     * @param settings                 the settings
     * @param dischargedTranslationKey the discharged translation key
     */
    public GenericPoweredAxe(class_1832 material, int energyCapacity, EnergyTier tier, int cost, float poweredSpeed, float unpoweredSpeed, class_1793 settings, @Nullable String dischargedTranslationKey) {
        super(material, energyCapacity, tier, cost, poweredSpeed, unpoweredSpeed, attackDamage, class_1743.field_7899, settings, dischargedTranslationKey);
    }

    /**
     * Gets mining speed multiplier.
     *
     * @param stack the stack
     * @param state the state
     * @return the mining speed multiplier
     */
    @Override
    public float method_7865(class_1799 stack, class_2680 state) {
        class_3614 material = state.method_26207();

        // I know field_23139 as NATURAL_EFFECTIVE_MATERIALS
        return class_1743.field_23139.contains(material) ? this.field_7940 : super.method_7865(stack, state);
    }

    /**
     * Use on block action result.
     *
     * @param context the context
     * @return the action result
     */
    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = class_1743.field_7898.get(blockState.method_26204());

        if (isUsable(context.method_8041()) && block != null) {
            class_1657 playerEntity = context.method_8036();
            world.method_8396(playerEntity, blockPos, class_3417.field_14675, class_3419.field_15245, 1.0F, 1.0F);

            if (!world.field_9236) {
                world.method_8652(blockPos, block.method_9564().method_11657(class_2465.field_11459, blockState.method_11654(class_2465.field_11459)), 11);
            }

            ItemManager.useEnergy(playerEntity, context.method_8041(), cost); // To Make Sure Item Uses Durability
            return class_1269.method_29236(world.field_9236);
        }

        return super.method_7884(context);
    }

    /**
     * Is effective on boolean.
     *
     * @param state the state
     * @return the boolean
     */
    @Override
    public boolean method_7856(class_2680 state) {
        if (super.method_7856(state))
            return true;

        // If not one of the explicitly stated effective blocks, then check the Material Type
        return class_1743.field_23139.contains(state.method_26207());
    }
}