package me.alexisevelyn.randomtech.api.items.tools.generic;

import me.alexisevelyn.randomtech.api.utilities.ItemManager;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1832;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.EnergyTier;

/**
 * The type Generic powered hoe.
 */
public abstract class GenericPoweredHoe extends GenericPoweredTool {
    private static final float attackDamage = -4.0F;

    /**
     * Instantiates a new Generic powered hoe.
     *
     * @param material                 the material
     * @param energyCapacity           the energy capacity
     * @param tier                     the tier
     * @param cost                     the cost
     * @param poweredSpeed             the powered speed
     * @param unpoweredSpeed           the unpowered speed
     * @param settings                 the settings
     * @param dischargedTranslationKey the discharged translation key
     */
    public GenericPoweredHoe(class_1832 material, int energyCapacity, EnergyTier tier, int cost, float poweredSpeed, float unpoweredSpeed, class_1793 settings, @Nullable String dischargedTranslationKey) {
        super(material, energyCapacity, tier, cost, poweredSpeed, unpoweredSpeed, attackDamage, class_1794.field_22486, settings, dischargedTranslationKey);
    }

    /**
     * Use on block action result.
     *
     * @param context the context
     * @return the action result
     */
    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();

        // If Failed to be Usable, Then Fail Action
        if (!isUsable(context.method_8041()))
            return class_1269.field_5814;

        if (context.method_8038() != class_2350.field_11033 && world.method_8320(blockPos.method_10084()).method_26215()) {
            class_2680 blockState = class_1794.field_8023.get(world.method_8320(blockPos).method_26204());

            if (blockState != null) {
                class_1657 playerEntity = context.method_8036();
                world.method_8396(playerEntity, blockPos, class_3417.field_14846, class_3419.field_15245, 1.0F, 1.0F);

                if (!world.field_9236) {
                    world.method_8652(blockPos, blockState, 11);
                }

                ItemManager.useEnergy(playerEntity, context.method_8041(), cost); // To Make Sure Item Uses Durability
                return class_1269.method_29236(world.field_9236);
            }
        }

        return super.method_7884(context);
    }
}