package me.alexisevelyn.randomtech.api.items.tools.generic;

import me.alexisevelyn.randomtech.api.utilities.ItemManager;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1821;
import net.minecraft.class_1832;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3922;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.EnergyTier;

/**
 * The type Generic powered shovel.
 */
public abstract class GenericPoweredShovel extends GenericPoweredTool {
    private static final float attackDamage = 1.5F;

    /**
     * Instantiates a new Generic powered shovel.
     *
     * @param material                 the material
     * @param energyCapacity           the energy capacity
     * @param tier                     the tier
     * @param cost                     the cost
     * @param poweredSpeed             the powered speed
     * @param unpoweredSpeed           the unpowered speed
     * @param settings                 the settings
     * @param dischargedTranslationKey the discharged translation key
     */
    public GenericPoweredShovel(class_1832 material, int energyCapacity, EnergyTier tier, int cost, float poweredSpeed, float unpoweredSpeed, class_1793 settings, @Nullable String dischargedTranslationKey) {
        super(material, energyCapacity, tier, cost, poweredSpeed, unpoweredSpeed, attackDamage, class_1821.field_8913, settings, dischargedTranslationKey);
    }

    /**
     * Use on block action result.
     *
     * @param context the context
     * @return the action result
     */
    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2680 blockState = world.method_8320(blockPos);

        // If Failed to be Usable, Then Fail Action
        if (!isUsable(context.method_8041()))
            return super.method_7884(context);

        // Don't Perform Actions From the Bottom Side of A Block
        if (context.method_8038() == class_2350.field_11033)
            return super.method_7884(context);

        class_1657 playerEntity = context.method_8036();
        class_2680 currentPathState = class_1821.field_8912.get(blockState.method_26204());
        class_2680 workingBlockState = null;

        if (currentPathState != null && world.method_8320(blockPos.method_10084()).method_26215()) {
            world.method_8396(playerEntity, blockPos, class_3417.field_14616, class_3419.field_15245, 1.0F, 1.0F);
            workingBlockState = currentPathState;
        } else if (blockState.method_26204() instanceof class_3922 && blockState.method_11654(class_3922.field_17352)) {
            if (!world.method_8608())
                world.method_8444(null, 1009, blockPos, 0);

            class_3922.method_29288(world, blockPos, blockState);
            workingBlockState = blockState.method_11657(class_3922.field_17352, false);
        }

        // If Action Set to Perform, Then Perform
        if (workingBlockState != null) {
            if (!world.field_9236)
                world.method_8652(blockPos, workingBlockState, 11);

            ItemManager.useEnergy(playerEntity, context.method_8041(), cost); // To Make Sure Item Uses Durability
            return class_1269.method_29236(world.field_9236);
        }

        return super.method_7884(context);
    }
}