package me.alexisevelyn.randomtech.api.items.tools.generic;

import com.google.common.collect.Sets;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.EnergyTier;

import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3614;

/**
 * The type Generic powered sword.
 */
public abstract class GenericPoweredSword extends GenericPoweredTool {
    private static final Set<class_2248> EFFECTIVE_BLOCKS;
    private static final float attackDamage = 3;

    /**
     * Instantiates a new Generic powered sword.
     *
     * @param material                 the material
     * @param energyCapacity           the energy capacity
     * @param tier                     the tier
     * @param cost                     the cost
     * @param poweredSpeed             the powered speed
     * @param unpoweredSpeed           the unpowered speed
     * @param settings                 the settings
     * @param dischargedTranslationKey the discharged translation key
     */
    public GenericPoweredSword(class_1832 material, int energyCapacity, EnergyTier tier, int cost, float poweredSpeed, float unpoweredSpeed, class_1793 settings, @Nullable String dischargedTranslationKey) {
        super(material, energyCapacity, tier, cost, poweredSpeed, unpoweredSpeed, attackDamage, EFFECTIVE_BLOCKS, settings, dischargedTranslationKey);
    }

    /**
     * Can mine boolean.
     *
     * @param state the state
     * @param world the world
     * @param pos   the pos
     * @param miner the miner
     * @return the boolean
     */
    @Override
    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        if (miner.method_7337())
            return false;

        return super.method_7885(state, world, pos, miner);
    }

    /**
     * Gets mining speed multiplier.
     *
     * @param stack the stack
     * @param state the state
     * @return the mining speed multiplier
     */
    @Override
    public float method_7865(class_1799 stack, class_2680 state) {
        class_3614 material = state.method_26207();

        if (material.equals(class_3614.field_15935) || material.equals(class_3614.field_15956) || material.equals(class_3614.field_15921) || material.equals(class_3614.field_15923) || material.equals(class_3614.field_15954))
            return 1.5F;

        return super.method_7865(stack, state);
    }

    static {
        // There is no static reference for SwordItem as there is only one block that a sword is effective on in vanilla.
        EFFECTIVE_BLOCKS = Sets.newHashSet(class_2246.field_10343);
    }
}