package me.alexisevelyn.randomtech.api.items.tools.generic;

import com.google.common.collect.Multimap;
import me.alexisevelyn.randomtech.api.items.energy.EnergyHelper;
import me.alexisevelyn.randomtech.api.utilities.ItemManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1766;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_5134;
import net.minecraft.item.*;
import org.jetbrains.annotations.Nullable;
import reborncore.api.items.ItemStackModifiers;
import reborncore.common.util.ItemDurabilityExtensions;
import reborncore.common.util.ItemUtils;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergyHolder;
import team.reborn.energy.EnergyTier;

import java.util.List;
import java.util.Random;
import java.util.Set;

/**
 * The type Generic powered tool.
 */
public abstract class GenericPoweredTool extends class_1766 implements EnergyHelper, EnergyHolder, ItemDurabilityExtensions, ItemStackModifiers, BreakableBlocksHelper {
    public final int maxCharge;
    public final int cost;
    public final float poweredSpeed;
    public final float unpoweredSpeed;
    public final EnergyTier tier;
    public final Set<class_2248> effectiveBlocks;
    private final String dischargedTranslationKey;

    // Pulled From: net.minecraft.item.Item
//    public static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
//    public static final UUID ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    /**
     * Instantiates a new Generic powered tool.
     *
     * @param material                 the material
     * @param energyCapacity           the energy capacity
     * @param tier                     the tier
     * @param cost                     the cost
     * @param poweredSpeed             the powered speed
     * @param unpoweredSpeed           the unpowered speed
     * @param attackDamage             the attack damage
     * @param effectiveBlocks          the effective blocks
     * @param settings                 the settings
     * @param dischargedTranslationKey the discharged translation key
     */
    public GenericPoweredTool(class_1832 material, int energyCapacity, EnergyTier tier, int cost, float poweredSpeed, float unpoweredSpeed, float attackDamage, Set<class_2248> effectiveBlocks, class_1793 settings, @Nullable String dischargedTranslationKey) {
        super(attackDamage, unpoweredSpeed, material, effectiveBlocks, settings.method_7889(1).method_7895(material.method_8025()));

        this.maxCharge = energyCapacity;
        this.tier = tier;

        this.cost = cost;
        this.unpoweredSpeed = unpoweredSpeed;
        this.poweredSpeed = poweredSpeed;
        this.effectiveBlocks = effectiveBlocks;
        this.dischargedTranslationKey = dischargedTranslationKey;
    }

    /**
     * Gets name.
     *
     * @param stack the stack
     * @return the name
     */
    @Override
    @Environment(EnvType.CLIENT)
    public class_2561 method_7864(class_1799 stack) {
        return new class_2588(this.method_7866(stack));
    }

    /**
     * Gets translation key.
     *
     * @param stack the stack
     * @return the translation key
     */
    @Override
    public String method_7866(class_1799 stack) {
        if (isUsable(stack) || this.dischargedTranslationKey == null)
            return super.method_7866(stack);

        return this.dischargedTranslationKey;
    }

    /**
     * Is effective on boolean.
     *
     * @param state the state
     * @return the boolean
     */
    @Override
    public boolean method_7856(class_2680 state) {
        return effectiveBlocks.contains(state.method_26204());
    }

    /**
     * Can mine boolean.
     *
     * @param state the state
     * @param world the world
     * @param pos   the pos
     * @param miner the miner
     * @return the boolean
     */
    @Override
    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        if (!super.method_7885(state, world, pos, miner))
            return false;

        // Allows player to break block in creative mode even when holding a dead tool.
        // Sword still overrides this method, so breaking in creative is denied for sword.
        if (miner.method_7337())
            return true;

        return isUsable(miner.method_6047());
    }

    /**
     * Gets mining speed multiplier.
     *
     * @param stack the stack
     * @param state the state
     * @return the mining speed multiplier
     */
    @Override
    public float method_7865(class_1799 stack, class_2680 state) {
        if (isUsable(stack) && method_7856(state))
            return this.poweredSpeed;

        return super.method_7865(stack, state);
    }

    /**
     * Gets attribute modifiers.
     *
     * @param equipmentSlot the equipment slot
     * @param stack         the stack
     * @param builder       the builder
     */
    @Override
    public void getAttributeModifiers(class_1304 equipmentSlot, class_1799 stack, Multimap<class_1320, class_1322> builder) {
        // Modify Tool Attributes Dynamically

        // The attribute modifiers are automatically added back when they aren't actively being taken away
        if (!isUsable(stack) && equipmentSlot == class_1304.field_6173) {
            builder.removeAll(class_5134.field_23721);
            builder.removeAll(class_5134.field_23723);
        }
    }

    /**
     * Is not full boolean.
     *
     * @param stack the stack
     * @return the boolean
     */
    @Override
    public boolean isNotFull(class_1799 stack) {
        return getEnergy(stack) != getMaxEnergy(stack);
    }

    /**
     * Is usable boolean.
     *
     * @param stack the stack
     * @return the boolean
     */
    @Override
    public boolean isUsable(class_1799 stack) {
        return Energy.of(stack).getEnergy() >= this.cost;
    }

    /**
     * Gets energy.
     *
     * @param stack the stack
     * @return the energy
     */
    @Override
    public double getEnergy(class_1799 stack) {
        return Energy.of(stack).getEnergy();
    }

    /**
     * Sets energy.
     *
     * @param stack  the stack
     * @param energy the energy
     */
    @Override
    public void setEnergy(class_1799 stack, double energy) {
        Energy.of(stack).set(energy);
    }

    /**
     * Inventory tick.
     *
     * @param stack    the stack
     * @param world    the world
     * @param entity   the entity
     * @param slot     the slot
     * @param selected the selected
     */
    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
    }

    /**
     * Gets attack damage.
     *
     * @return the attack damage
     */
    // Used by mobs to determine if they prefer a weapon over another one.
    // It does not actually modify the attack damage of an item (for vanilla purposes)?
    @SuppressWarnings("EmptyMethod")
    @Override
    public float method_26366() {
        return super.method_26366();
    }

    /**
     * Gets attack speed.
     *
     * @return the attack speed
     */
    public float getAttackSpeed() {
        return this.unpoweredSpeed;
    }

    /**
     * Post hit boolean.
     *
     * @param stack    the stack
     * @param target   the target
     * @param attacker the attacker
     * @return the boolean
     */
    // For Attacking
    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        Random rand = new Random();
        if (isUsable(stack) && rand.nextInt(class_1890.method_8225(class_1893.field_9119, stack) + 1) == 0) {
            ItemManager.useEnergy(attacker, stack, cost);
            return super.method_7873(stack, target, attacker);
        }

        // For Item Stats
        return false;
    }

    /**
     * Post mine boolean.
     *
     * @param stack the stack
     * @param world the world
     * @param state the state
     * @param pos   the pos
     * @param miner the miner
     * @return the boolean
     */
    // For Mining
    @Override
    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        Random rand = new Random();
        if (isUsable(stack) && (state.method_26214(world, pos) != 0.0F) && rand.nextInt(class_1890.method_8225(class_1893.field_9119, stack) + 1) == 0) {
            if (method_7856(state))
                ItemManager.useEnergy(miner, stack, cost);
            else
                ItemManager.useEnergy(miner, stack, cost+1);

            return super.method_7879(stack, world, state, pos, miner);
        }

        // For Item Stats
        return false;
    }

    /**
     * Can repair boolean.
     *
     * @param tool           the tool
     * @param repairMaterial the repair material
     * @return the boolean
     */
    // ToolItem
    @Override
    public boolean method_7878(class_1799 tool, class_1799 repairMaterial) {
        return false;
    }

    /**
     * Is damageable boolean.
     *
     * @return the boolean
     */
    // Item
    @Override
    public boolean method_7846() {
        return false;
    }

    /**
     * Is enchantable boolean.
     *
     * @param stack the stack
     * @return the boolean
     */
    // This only applies to the enchantment table, not anvils?
    @Override
    public boolean method_7870(class_1799 stack) {
        return true;
    }

    /**
     * Use on block action result.
     *
     * @param context the context
     * @return the action result
     */
    // For Right Clicking Blocks
    @Override
    public class_1269 method_7884(class_1838 context) {
        if (isUsable(context.method_8041()))
            return super.method_7884(context);

        return class_1269.field_5814;
    }

    /**
     * Use on entity action result.
     *
     * @param stack  the stack
     * @param user   the user
     * @param entity the entity
     * @param hand   the hand
     * @return the action result
     */
    // For Right Clicking Entities
    @Override
    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (isUsable(stack))
            return super.method_7847(stack, user, entity, hand);

        return class_1269.field_5814;
    }

    /**
     * Is fireproof boolean.
     *
     * @return the boolean
     */
    @SuppressWarnings("EmptyMethod")
    @Override
    public boolean method_24358() {
        return super.method_24358();
    }

    /**
     * Gets max energy.
     *
     * @param itemStack the item stack
     * @return the max energy
     */
    @Override
    public double getMaxEnergy(class_1799 itemStack) {
        // RebornCore uses getMaxStoredPower() for their hud.
        // That makes it where the max energy cannot be set per ItemStack.
        // Once I implement dynamic max energy, my code will be able to get the dynamic max energy.

        return getMaxStoredPower();
    }

    /**
     * Gets max stored power.
     *
     * @return the max stored power
     */
    @Override
    public double getMaxStoredPower() {
        return this.maxCharge;
    }

    /**
     * Gets tier.
     *
     * @return the tier
     */
    @Override
    public EnergyTier getTier() {
        return this.tier;
    }

    /**
     * Gets durability.
     *
     * @param stack the stack
     * @return the durability
     */
    @Override
    public double getDurability(class_1799 stack) {
        // TODO: Replace this with a dynamic durability bar checker.
        return 1 - ItemUtils.getPowerForDurabilityBar(stack);
    }

    /**
     * Show durability boolean.
     *
     * @param stack the stack
     * @return the boolean
     */
    @Override
    public boolean showDurability(class_1799 stack) {
        if (!(stack.method_7909() instanceof EnergyHelper))
            return true;

        double currentEnergy = Energy.of(stack).getEnergy();
        double maxEnergy = getMaxEnergy(stack);

        return currentEnergy < maxEnergy;
    }

    /**
     * Gets durability color.
     *
     * @param stack the stack
     * @return the durability color
     */
    @Override
    public int getDurabilityColor(class_1799 stack) {
        // Red - PowerSystem.getDisplayPower().colour;
        // Darker Red - PowerSystem.getDisplayPower().altColour;
        // Blue - 0xFF0014A2
        // Green - 0xFF006700

        return 0xFF0014A2;
    }

    // I may or may not use this in the future, so I'm just marking it to not be used by 3rd parties for now.
//    @Deprecated
//    public boolean allowActionResult(ActionResult actionResult) {
//        return actionResult.isAccepted() || actionResult == ActionResult.PASS;
//    }

    /**
     * Append stacks.
     *
     * @param group    the group
     * @param itemList the item list
     */
    @Environment(EnvType.CLIENT)
    @Override
    public void method_7850(class_1761 group, class_2371<class_1799> itemList) {
        // Can be used to add multiple versions of items (e.g. a charged and discharged variant of each tool)
        if (!method_7877(group)) {
            return;
        }

        ItemManager.initPoweredItems(this, itemList);
    }

    /**
     * On craft item stack.
     *
     * @param oldStack the old stack
     * @param newStack the new stack
     * @param tag      the tag
     * @return the item stack
     */
    @Override
    public class_1799 onCraft(class_1799 oldStack, class_1799 newStack, class_2487 tag) {
        return ItemManager.convertStackToEnergyItemStack(oldStack, newStack, tag);
    }

    /**
     * Append tooltip.
     *
     * @param stack   the stack
     * @param worldIn the world in
     * @param tooltip the tooltip
     * @param flagIn  the flag in
     */
    @Environment(EnvType.CLIENT)
    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (flagIn.method_8035())
            ItemManager.powerLevelTooltip(stack, tooltip);
    }

    /**
     * Can break unbreakable block boolean.
     *
     * @param state  the state
     * @param player the player
     * @param world  the world
     * @param pos    the pos
     * @return the boolean
     */
    @Override
    public boolean canBreakUnbreakableBlock(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        return false;
    }

    /**
     * Gets unbreakable block difficulty multiplier.
     *
     * @param state  the state
     * @param player the player
     * @param world  the world
     * @param pos    the pos
     * @return the unbreakable block difficulty multiplier
     */
    @Override
    public float getUnbreakableBlockDifficultyMultiplier(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        return 1.0F;
    }
}