package me.alexisevelyn.randomtech.api.mixin.armor;

import me.alexisevelyn.randomtech.api.items.armor.generic.GenericPoweredArmor;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * The type Damage armor mixin living entity.
 */
@SuppressWarnings("UnusedMixin") // The mixin is used, just is loaded by Fabric and not Sponge methods
@Mixin(class_1309.class)
public abstract class DamageArmorMixinLivingEntity {

	/**
	 * Gets armor items.
	 *
	 * @return the armor items
	 */
    // @Shadow @Final public PlayerInventory inventory;
	@Shadow public abstract Iterable<class_1799> getArmorItems();

	/**
	 * Gets attacking.
	 *
	 * @return the attacking
	 */
	@Shadow @Nullable public abstract class_1309 getAttacking();

	/**
	 * Damage armor.
	 *
	 * @param damageSource the damage source
	 * @param damage       the damage
	 * @param info         the info
	 */
	@Inject(at = @At("HEAD"), method = "damageArmor(Lnet/minecraft/entity/damage/DamageSource;F)V")
	private void damageArmor(class_1282 damageSource, float damage, CallbackInfo info) {
		if (damage > 0.0F) {

			// Divide damage by 4. May remove this later.
			damage /= 4.0F;

			// If damage is less than one, but greater than 0, set to 1.
			if (damage < 1.0F)
				damage = 1.0F;

			float finalDamage = damage;
			this.getArmorItems().forEach(armor -> {
				// System.out.println("Armor Piece: " + armor.getItem());
				if ((!damageSource.method_5534() || !armor.method_7909().method_24358()) && armor.method_7909() instanceof GenericPoweredArmor) {
					((GenericPoweredArmor) armor.method_7909()).addDamage(armor, this.getAttacking(), damageSource, finalDamage);
				}
			});
		}
	}
}
