package me.alexisevelyn.randomtech.api.mixin.armor;

import me.alexisevelyn.randomtech.api.items.armor.generic.GenericPoweredArmor;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * The type Damage armor mixin player entity.
 */
@SuppressWarnings("UnusedMixin") // The mixin is used, just is loaded by Fabric and not Sponge methods
@Mixin(class_1657.class)
public abstract class DamageArmorMixinPlayerEntity {

	@Shadow @Final public class_1661 inventory;

	/**
	 * Damage armor.
	 *
	 * @param damageSource the damage source
	 * @param damage       the damage
	 * @param info         the info
	 */
	@Inject(at = @At("INVOKE"), method = "damageArmor(Lnet/minecraft/entity/damage/DamageSource;F)V")
	private void damageArmor(class_1282 damageSource, float damage, CallbackInfo info) {
		if (damage > 0.0F) {

			// Divide damage by 4. May remove this later.
			damage /= 4.0F;

			// If damage is less than one, but greater than 0, set to 1.
			if (damage < 1.0F)
				damage = 1.0F;

			for (class_1799 armorPiece : this.inventory.field_7548) {
				if ((!damageSource.method_5534() || !armorPiece.method_7909().method_24358()) && armorPiece.method_7909() instanceof GenericPoweredArmor) {
					((GenericPoweredArmor) armorPiece.method_7909()).addDamage(armorPiece, this.inventory.field_7546, damageSource, damage);
				}
			}
		}
	}
}