package me.alexisevelyn.randomtech.api.mixin.armor;

import me.alexisevelyn.randomtech.api.items.armor.generic.SecondaryTextureHandler;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_970;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * The type Dynamic armor texture mixin.
 *
 * @param <T> the type parameter
 * @param <M> the type parameter
 * @param <A> the type parameter
 */
@SuppressWarnings("UnusedMixin") // The mixin is used, just is loaded by Fabric and not Sponge methods
@Mixin(class_970.class)
public abstract class DynamicArmorTextureMixin<T extends class_1309, M extends class_572<T>, A extends class_572<T>> extends class_3887<T, M> {
	/**
	 * Instantiates a new Dynamic armor texture mixin.
	 *
	 * @param context the context
	 */
	public DynamicArmorTextureMixin(class_3883<T, M> context) {
		super(context);
	}

	/**
	 * Uses second layer boolean.
	 *
	 * @param equipmentSlot the equipment slot
	 * @return the boolean
	 */
	@Shadow protected abstract boolean usesSecondLayer(class_1304 equipmentSlot);

	/**
	 * Sets visible.
	 *
	 * @param bipedModel the biped model
	 * @param slot       the slot
	 */
	@Shadow protected abstract void setVisible(class_572<?> bipedModel, class_1304 slot);

	/**
	 * Render armor parts.
	 *
	 * @param matrixStack            the matrix stack
	 * @param vertexConsumerProvider the vertex consumer provider
	 * @param i                      the
	 * @param armorItem              the armor item
	 * @param bl                     the bl
	 * @param bipedEntityModel       the biped entity model
	 * @param bl2                    the bl 2
	 * @param f                      the f
	 * @param g                      the g
	 * @param h                      the h
	 * @param string                 the string
	 */
	@SuppressWarnings("SameParameterValue") @Shadow protected abstract void renderArmorParts(class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, class_1738 armorItem, boolean bl, class_572<?> bipedEntityModel, boolean bl2, float f, float g, float h, @Nullable String string);
	// @Shadow public abstract M getContextModel();

	/**
	 * Render armor.
	 *
	 * @param matrices         the matrices
	 * @param vertexConsumers  the vertex consumers
	 * @param livingEntity     the living entity
	 * @param equipmentSlot    the equipment slot
	 * @param i                the
	 * @param bipedEntityModel the biped entity model
	 * @param info             the info
	 */
	@Inject(at = @At("INVOKE"), method = "renderArmor(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/EquipmentSlot;ILnet/minecraft/client/render/entity/model/BipedEntityModel;)V", cancellable = true)
	private void renderArmor(class_4587 matrices, class_4597 vertexConsumers, T livingEntity, class_1304 equipmentSlot, int i, A bipedEntityModel, CallbackInfo info) {
		class_1799 itemStack = livingEntity.method_6118(equipmentSlot);
		class_1792 item = itemStack.method_7909();

		if (item instanceof SecondaryTextureHandler) {
			SecondaryTextureHandler genericArmor = (SecondaryTextureHandler) item;

			if (genericArmor.getArmorSlot() != equipmentSlot)
				return;

			this.method_17165().method_2818(bipedEntityModel);
			this.setVisible(bipedEntityModel, equipmentSlot);
			boolean usesSecondLayer = this.usesSecondLayer(equipmentSlot);
			boolean hasGlint = itemStack.method_7958();

			this.renderArmorParts(matrices, vertexConsumers, i, (class_1738) item, hasGlint, bipedEntityModel, usesSecondLayer, 1.0F, 1.0F, 1.0F, genericArmor.getSecondaryArmorTexture(livingEntity, itemStack));

			info.cancel();
		}
	}
}
