package me.alexisevelyn.randomtech.api.mixin.enchanting;

import com.google.common.collect.Lists;
import me.alexisevelyn.randomtech.api.items.energy.EnergyHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.entity.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.Map;

// This mixin makes mending useful for my tools and armor.

/**
 * The type Powered mending helper.
 */
@SuppressWarnings("UnusedMixin") // The mixin is used, just is loaded by Fabric and not Sponge methods
@Mixin(class_1303.class)
public abstract class PoweredMendingHelper extends class_1297 {
//	@Shadow public int orbAge;
//	@Shadow private int health;
	@Shadow private int amount;
	@Shadow public int pickupDelay;

	/**
	 * Gets mending repair amount.
	 *
	 * @param experienceAmount the experience amount
	 * @return the mending repair amount
	 */
	@Shadow protected abstract int getMendingRepairAmount(int experienceAmount);

	/**
	 * Gets mending repair cost.
	 *
	 * @param repairAmount the repair amount
	 * @return the mending repair cost
	 */
	@Shadow protected abstract int getMendingRepairCost(int repairAmount);

	/**
	 * Create spawn packet packet.
	 *
	 * @return the packet
	 */
	@Shadow public abstract class_2596<?> method_18002();

	/**
	 * Write custom data to tag.
	 *
	 * @param tag the tag
	 */
	@Shadow public abstract void method_5652(class_2487 tag);

	/**
	 * Read custom data from tag.
	 *
	 * @param tag the tag
	 */
	@Shadow public abstract void method_5749(class_2487 tag);

	/**
	 * Init data tracker.
	 */
	@Shadow protected abstract void method_5693();

	/**
	 * Instantiates a new Powered mending helper.
	 *
	 * @param type  the type
	 * @param world the world
	 */
	public PoweredMendingHelper(class_1299<?> type, class_1937 world) {
		super(type, world);
	}

	/**
	 * On player collision.
	 *
	 * @param player the player
	 * @param info   the info
	 */
	@Inject(at = @At("HEAD"), method = "onPlayerCollision(Lnet/minecraft/entity/player/PlayerEntity;)V", cancellable = true)
	private void onPlayerCollision(class_1657 player, CallbackInfo info) {
		boolean isCancelled = false;

		if (this.field_6002.field_9236)
			return;

		if (this.pickupDelay != 0 || player.field_7504 != 0)
			return;

		Map.Entry<class_1304, class_1799> entry = PoweredMendingHelper.chooseEquipmentWith(player);

		if (entry != null) {
			class_1799 itemStack = entry.getValue();
			if (!itemStack.method_7960() && itemStack.method_7909() instanceof EnergyHelper) {
				isCancelled = true;

				EnergyHelper genericPoweredItem = (EnergyHelper) itemStack.method_7909();

				int missingEnergy = Math.min(this.getMendingRepairAmount(this.amount), (int) (genericPoweredItem.getMaxEnergy(itemStack) - genericPoweredItem.getEnergy(itemStack)));
				this.amount -= this.getMendingRepairCost(missingEnergy);

				genericPoweredItem.setEnergy(itemStack, genericPoweredItem.getEnergy(itemStack) + missingEnergy);
			}
		}

		if (isCancelled) {
			player.field_7504 = 2;
			player.method_6103(this, 1);

			if (this.amount > 0) {
				player.method_7255(this.amount);
			}

			this.method_5650();
			info.cancel();
		}
	}

	/**
	 * Choose equipment with map . entry.
	 *
	 * @param entity the entity
	 * @return the map . entry
	 */
	private static Map.Entry<class_1304, class_1799> chooseEquipmentWith(class_1309 entity) {
		Map<class_1304, class_1799> map = class_1893.field_9101.method_8185(entity);

		if (map.isEmpty())
			return null;

		List<Map.Entry<class_1304, class_1799>> repairableItemStacks = Lists.newArrayList();

		for (Map.Entry<class_1304, class_1799> entry : map.entrySet()) {
			class_1799 itemStack = entry.getValue();

			if (!itemStack.method_7960() && class_1890.method_8225(class_1893.field_9101, itemStack) > 0 && isInNeedOfRepair(itemStack)) {
				repairableItemStacks.add(entry);
			}
		}

		return repairableItemStacks.isEmpty() ? null : repairableItemStacks.get(entity.method_6051().nextInt(repairableItemStacks.size()));
	}

	/**
	 * Is in need of repair boolean.
	 *
	 * @param itemStack the item stack
	 * @return the boolean
	 */
	private static boolean isInNeedOfRepair(class_1799 itemStack) {
		if (!(itemStack.method_7909() instanceof EnergyHelper))
			return false;

		EnergyHelper genericPoweredItem = (EnergyHelper) itemStack.method_7909();
		return genericPoweredItem.isNotFull(itemStack);
	}
}