package me.alexisevelyn.randomtech.api.mixin.enchanting;

import com.google.common.collect.Lists;
import me.alexisevelyn.randomtech.api.items.energy.EnergyHelper;
import me.alexisevelyn.randomtech.api.utilities.enchanting.CustomEnchantmentHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Iterator;
import java.util.List;

/**
 * The type Table enchant helper mixin.
 */
@SuppressWarnings("UnusedMixin") // The mixin is used, just is loaded by Fabric and not Sponge methods
@Mixin(class_1890.class)
public abstract class TableEnchantHelperMixin {
	/**
	 * Gets possible entries.
	 *
	 * @param power           the power
	 * @param itemStack       the item stack
	 * @param treasureAllowed the treasure allowed
	 * @param info            the info
	 */
    // Cancellable must be allowed, otherwise the game crashes when trying to modify the return value
	@Inject(at = @At("TAIL"), method = "getPossibleEntries(ILnet/minecraft/item/ItemStack;Z)Ljava/util/List;", cancellable = true)
	private static void getPossibleEntries(int power, class_1799 itemStack, boolean treasureAllowed, CallbackInfoReturnable<List<class_1889>> info) {
		// Only mess with enchantment table (and other enchanted loot generation) if our items.
		if (!(itemStack.method_7909() instanceof EnergyHelper))
			return;

		Iterator<class_1887> enchantmentIterator = class_2378.field_11160.iterator();
		List<class_1889> customAllowedEnchants = Lists.newArrayList();

		while (enchantmentIterator.hasNext()) {
			class_1887 enchantment = enchantmentIterator.next();
			int currentLevel = shouldAddEnchantment(itemStack, enchantment, power, treasureAllowed);

			if (currentLevel != -1)
				customAllowedEnchants.add(new class_1889(enchantment, currentLevel));
		}

		info.setReturnValue(customAllowedEnchants);
	}

	/**
	 * Should add enchantment int.
	 *
	 * @param itemStack     the item stack
	 * @param enchantment   the enchantment
	 * @param power         the power
	 * @param allowTreasure the allow treasure
	 * @return the int
	 */
	private static int shouldAddEnchantment(class_1799 itemStack, class_1887 enchantment, int power, boolean allowTreasure) {
		if (CustomEnchantmentHelper.isValidEnchantment(itemStack, enchantment.field_9083) != CustomEnchantmentHelper.ValidEnchant.TRUE)
			return -1;

		if (!enchantment.method_25950())
			return -1;

		if (enchantment.method_8193() && !allowTreasure)
			return -1;

		// This checks the enchantment level indirectly based on the input of the power level from the Enchantment table
		for(int currentLevel = enchantment.method_8183(); currentLevel > enchantment.method_8187() - 1; --currentLevel) {
			if (power >= enchantment.method_8182(currentLevel) && power <= enchantment.method_20742(currentLevel))
				return currentLevel;
		}

		return -1;
	}
}