package me.alexisevelyn.randomtech.api.mixin.overpowered;

import me.alexisevelyn.randomtech.api.items.tools.generic.BreakableBlocksHelper;
import me.alexisevelyn.randomtech.api.items.tools.generic.GenericPoweredTool;
import net.minecraft.block.*;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2288;
import net.minecraft.class_2338;
import net.minecraft.class_2515;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3748;
import net.minecraft.class_39;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;

// This mixin is a 2 in 1. It handles making unbreakable blocks breakable and allows fixing the mining animation for dead tools to not occur.

/**
 * The type Breakable blocks mixin.
 */
@SuppressWarnings("UnusedMixin") // The mixin is used, just is loaded by Fabric and not Sponge methods
@Mixin(class_4970.class)
public abstract class BreakableBlocksMixin {
	/**
	 * Gets loot table id.
	 *
	 * @return the loot table id
	 */
	@Shadow @Final public abstract class_2960 getLootTableId();

	@Shadow @Final protected class_4970.class_2251 settings;

	/**
	 * Calc block breaking delta.
	 *
	 * @param state  the state
	 * @param player the player
	 * @param world  the world
	 * @param pos    the pos
	 * @param info   the info
	 */
	@Inject(at = @At("INVOKE"), method = "calcBlockBreakingDelta(Lnet/minecraft/block/BlockState;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;)F", cancellable = true)
	public void calcBlockBreakingDelta(class_2680 state, class_1657 player, class_1922 world, class_2338 pos, CallbackInfoReturnable<Float> info) {
		float blockHardness = state.method_26214(world, pos);
		class_1799 itemStack = player.method_6047();

		// Disables Mining Animation For Dead Tools
		if (disableAnimationForDeadTool(itemStack)) {
			info.setReturnValue(0.0F);
			return;
		}

		if (blockHardness == -1.0F) {
			if (itemStack.method_7909() instanceof BreakableBlocksHelper) {
				BreakableBlocksHelper genericTool = (BreakableBlocksHelper) itemStack.method_7909();
				class_2248 block = state.method_26204();

				if (genericTool.canBreakUnbreakableBlock(state, player, world, pos) && !isDeniedBlock(block)) {
					float dynamicBlockHardness = genericTool.getUnbreakableBlockDifficultyMultiplier(state, player, world, pos);

					// To ensure the hardness is always above 0.
					if (dynamicBlockHardness <= 0.0F)
						dynamicBlockHardness = 1.0F;

					info.setReturnValue(player.method_7351(state) / dynamicBlockHardness / 100.0F); // Makes the block have the expected mining speed as if it wasn't unbreakable
					return;
				}
			}

			info.setReturnValue(0.0F); // Makes the block unmineable if not the right tool
			return;
		}

		int effectiveToolMultiplier = player.method_7305(state) ? 30 : 100;
		info.setReturnValue(player.method_7351(state) / blockHardness / effectiveToolMultiplier);
	}

	/**
	 * Disable animation for dead tool boolean.
	 *
	 * @param itemStack the item stack
	 * @return the boolean
	 */
	public boolean disableAnimationForDeadTool(class_1799 itemStack) {
		if (itemStack.method_7909() instanceof GenericPoweredTool) {
			GenericPoweredTool genericPoweredTool = (GenericPoweredTool) itemStack.method_7909();
			return !genericPoweredTool.isUsable(itemStack);
		}

		return false;
	}

	/**
	 * Is denied block boolean.
	 *
	 * @param block the block
	 * @return the boolean
	 */
	public boolean isDeniedBlock(class_2248 block) {
		// This is to remove the visual indication of denied blocks which shouldn't be broken in survival.
		// This would've been blocked anyway later on in the code, but I'd like to remove the visual indication of mining the block
		return block instanceof class_2288 || block instanceof class_2515 || block instanceof class_3748;
	}

	/**
	 * Gets dropped stacks.
	 *
	 * @param state   the state
	 * @param builder the builder
	 * @param info    the info
	 */
    // Modifies Block Drops
	@Inject(at = @At("INVOKE"), method = "getDroppedStacks(Lnet/minecraft/block/BlockState;Lnet/minecraft/loot/context/LootContext$Builder;)Ljava/util/List;", cancellable = true)
	public void getDroppedStacks(class_2680 state, class_47.class_48 builder, CallbackInfoReturnable<List<class_1799>> info) {
		class_2960 identifier = this.getLootTableId();
		List<class_1799> drops = new ArrayList<>();

		// Takes empty loot tables and make drop its own blocks
		if (identifier == class_39.field_844 && isUnbreakableBlock(state, builder.method_313())) {
			class_1799 itemStack = new class_1799(state.method_26204());
			// builder.getWorld().getBlockEntity(blockPos)

			drops.add(itemStack);
			info.setReturnValue(drops);
		}
	}

	// This below method either doesn't grab the block entity data or is simply not called. No further testing performed.
	// Modify Dropped Stacks to Have Block Entity Data if Any
//	@Inject(at = @At("HEAD"), method = "onStacksDropped(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/item/ItemStack;)V", cancellable = true)
//	public void onStacksDropped(BlockState state, World world, BlockPos pos, ItemStack stack, CallbackInfo info) {
//		BlockEntity blockEntity = world.getBlockEntity(pos);
//
//		if (blockEntity == null)
//			return;
//
//		CompoundTag rootTag = stack.getOrCreateTag();
//		// CompoundTag blockEntityTag = rootTag.getCompound("BlockEntityTag");
//		CompoundTag blockEntityData = blockEntity.toTag(rootTag);
//
//		stack.putSubTag("BlockEntityTag", blockEntityData);
//		info.cancel();
//	}

	/**
	 * Is unbreakable block boolean.
	 *
	 * @param blockState the block state
	 * @param world      the world
	 * @return the boolean
	 */
	public boolean isUnbreakableBlock(class_2680 blockState, class_1937 world) {
		// This is a hack. The only reason it works is because getHardness doesn't actually check the world or blockpos.
		return blockState.method_26214(world, new class_2338(0, 0, 0)) == -1.0;
	}
}