package me.alexisevelyn.randomtech.api.mixin.overpowered;

import me.alexisevelyn.randomtech.api.items.armor.generic.InvulnerabilityHandler;
import me.alexisevelyn.randomtech.api.utilities.CustomDamageSource;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/**
 * The type Kill prevention mixin.
 */
@SuppressWarnings("UnusedMixin") // The mixin is used, just is loaded by Fabric and not Sponge methods
@Mixin(class_1309.class)
public abstract class KillPreventionMixin {
	// For /kill invulnerability for api
    // Also, for general damage prevention

    /**
     * Damage boolean.
     *
     * @param source the source
     * @param amount the amount
     * @return the boolean
     */
    @Shadow public abstract boolean damage(class_1282 source, float amount);

    /**
     * General damage.
     *
     * @param damageSource the damage source
     * @param amount       the amount
     * @param info         the info
     */
    @Inject(at = @At("HEAD"), method = "damage(Lnet/minecraft/entity/damage/DamageSource;F)Z", cancellable = true)
	private void generalDamage(class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> info) {
        //noinspection ConstantConditions
        if ((Object) this instanceof class_1657) {
            class_1657 playerEntity = (class_1657) (Object) this;

            handlePlayerDamage(playerEntity, damageSource, amount, info);
            return;
        }

        //noinspection ConstantConditions
        if (!((Object) this instanceof class_1309))
            return;

        class_1309 livingEntity = (class_1309) (Object) this;
        handleOtherLivingEntityDamage(livingEntity, damageSource, amount, info);
	}

    /**
     * Kill command.
     *
     * @param info the info
     */
    @Inject(at = @At("INVOKE"), method = "kill()V", cancellable = true)
	private void killCommand(CallbackInfo info) {
        //noinspection ConstantConditions - This claims to always return false, but it doesn't. That's because `this` becomes LivingEntity on runtime.
        if ((Object) this instanceof class_1657) { // if ((LivingEntity) (Object) this instanceof PlayerEntity)
            class_1657 playerEntity = (class_1657) (Object) this;

            handlePlayerKillCommand(playerEntity, info);
        } else //noinspection ConstantConditions
            if (((Object) this instanceof class_1309)) {
            class_1309 livingEntity = (class_1309) (Object) this;

            handleOtherLivingEntityKillCommand(livingEntity, info);
        }

        // If not already cancelled, cancel the kill command and replace it with a new damage source just for it.
        // This is so I can differentiate between the kill command and the void in the general damage code
        if (!info.isCancelled()) {
            this.damage(CustomDamageSource.KILL_COMMAND, Float.MAX_VALUE);
            info.cancel();
        }
    }

    /**
     * Handle player damage.
     *
     * @param playerEntity the player entity
     * @param damageSource the damage source
     * @param amount       the amount
     * @param info         the info
     */
    // Generic Damage to Players
    private void handlePlayerDamage(class_1657 playerEntity, class_1282 damageSource, float amount, CallbackInfo info) {
        class_1661 inventory = playerEntity.field_7514;
        class_2371<class_1799> armorItems = inventory.field_7548;

        for (class_1799 armorPiece : armorItems) {
            if (!(armorPiece.method_7909() instanceof InvulnerabilityHandler))
                continue;

            InvulnerabilityHandler invulnerabilityHandlerPiece = (InvulnerabilityHandler) armorPiece.method_7909();

            if (invulnerabilityHandlerPiece.denyGeneralDamage(armorPiece, damageSource, amount, playerEntity))
                info.cancel();
        }
    }

    /**
     * Handle other living entity damage.
     *
     * @param livingEntity the living entity
     * @param damageSource the damage source
     * @param amount       the amount
     * @param info         the info
     */
    // Generic Damage to Other Living Entities
    private void handleOtherLivingEntityDamage(class_1309 livingEntity, class_1282 damageSource, float amount, CallbackInfo info) {
        Iterable<class_1799> armorItems = livingEntity.method_5661();

        for (class_1799 armorPiece : armorItems) {
            if (!(armorPiece.method_7909() instanceof InvulnerabilityHandler))
                continue;

            InvulnerabilityHandler invulnerabilityHandlerPiece = (InvulnerabilityHandler) armorPiece.method_7909();

            if (invulnerabilityHandlerPiece.denyGeneralDamage(armorPiece, damageSource, amount, livingEntity))
                info.cancel();
        }
    }

    /**
     * Handle player kill command.
     *
     * @param playerEntity the player entity
     * @param info         the info
     */
    // Kill Command Specifically for Player
    private void handlePlayerKillCommand(class_1657 playerEntity, CallbackInfo info) {
        class_1661 inventory = playerEntity.field_7514;
        class_2371<class_1799> armorItems = inventory.field_7548;

        for (class_1799 armorPiece : armorItems) {
            if (!(armorPiece.method_7909() instanceof InvulnerabilityHandler))
                continue;

            InvulnerabilityHandler invulnerabilityHandlerPiece = (InvulnerabilityHandler) armorPiece.method_7909();

            if (invulnerabilityHandlerPiece.denyKillCommand(armorPiece, playerEntity))
                info.cancel();
        }
    }

    /**
     * Handle other living entity kill command.
     *
     * @param livingEntity the living entity
     * @param info         the info
     */
    // Kill Command Specifically for Other Living Entities
    private void handleOtherLivingEntityKillCommand(class_1309 livingEntity, CallbackInfo info) {
        Iterable<class_1799> armorItems = livingEntity.method_5661();

        for (class_1799 armorPiece : armorItems) {
            if (!(armorPiece.method_7909() instanceof InvulnerabilityHandler))
                continue;

            InvulnerabilityHandler invulnerabilityHandlerPiece = (InvulnerabilityHandler) armorPiece.method_7909();

            if (invulnerabilityHandlerPiece.denyKillCommand(armorPiece, livingEntity))
                info.cancel();
        }
    }
}