package me.alexisevelyn.randomtech.api.mixin.recipe;

import me.alexisevelyn.randomtech.api.items.energy.EnergyHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5357;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

// NOTE: This mixin only exists because you can't specify nbt data in a crafting recipe.

/**
 * The type Smithing recipe nbt modifier mixin.
 */
@SuppressWarnings("UnusedMixin") // The mixin is used, just is loaded by Fabric and not Sponge methods
@Mixin(class_5357.class)
public abstract class SmithingRecipeNBTModifierMixin {
//	@Shadow @Final private Identifier id; // Recipe ID
//	@Shadow @Final private Ingredient base; // Old Item
//	@Shadow @Final private Ingredient addition; // Conversion Ingredient
	@Shadow @Final private class_1799 result; // New Item

	/**
	 * Craft.
	 *
	 * @param inventory the inventory
	 * @param info      the info
	 */
    // Cancellable must be allowed, otherwise the game crashes when trying to modify the return value
	@Inject(at = @At("TAIL"), method = "craft(Lnet/minecraft/inventory/Inventory;)Lnet/minecraft/item/ItemStack;", cancellable = true)
	private void craft(class_1263 inventory, CallbackInfoReturnable<class_1799> info) {
		class_1799 oldItemStack = inventory.method_5438(0);
		class_1799 newItemStack = result.method_7972();

		class_1792 item = newItemStack.method_7909();

		class_2487 compoundTag = oldItemStack.method_7969();

		if (item instanceof EnergyHelper)
			info.setReturnValue(((EnergyHelper) item).onCraft(oldItemStack, newItemStack, compoundTag));
	}
}