package me.alexisevelyn.randomtech.api.utilities;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * The type Calculation helper.
 */
public class CalculationHelper {
    /**
     * Add vectors block pos.
     *
     * @param firstVector  the first vector
     * @param secondVector the second vector
     * @return the block pos
     */
    public static class_2338 addVectors(@NotNull class_2382 firstVector, @NotNull class_2382 secondVector) {
        return new class_2338(firstVector.method_10263() + secondVector.method_10263(), firstVector.method_10264() + secondVector.method_10264(), firstVector.method_10260() + secondVector.method_10260());
    }

    /**
     * Subtract vectors block pos.
     *
     * @param firstVector  the first vector
     * @param secondVector the second vector
     * @return the block pos
     */
    public static class_2338 subtractVectors(@NotNull class_2382 firstVector, @NotNull class_2382 secondVector) {
        return new class_2338(firstVector.method_10263() - secondVector.method_10263(), firstVector.method_10264() - secondVector.method_10264(), firstVector.method_10260() - secondVector.method_10260());
    }

    /**
     * Multiply vectors block pos.
     *
     * @param firstVector  the first vector
     * @param secondVector the second vector
     * @return the block pos
     */
    public static class_2338 multiplyVectors(@NotNull class_2382 firstVector, @NotNull class_2382 secondVector) {
        return new class_2338(firstVector.method_10263() * secondVector.method_10263(), firstVector.method_10264() * secondVector.method_10264(), firstVector.method_10260() * secondVector.method_10260());
    }

    /**
     * Divide vectors block pos.
     *
     * @param firstVector  the first vector
     * @param secondVector the second vector
     * @return the block pos
     */
    public static class_2338 divideVectors(@NotNull class_2382 firstVector, @NotNull class_2382 secondVector) {
        return new class_2338(firstVector.method_10263() / secondVector.method_10263(), firstVector.method_10264() / secondVector.method_10264(), firstVector.method_10260() / secondVector.method_10260());
    }

    /**
     * Distance vectors double.
     *
     * @param firstVector  the first vector
     * @param secondVector the second vector
     * @return the double
     */
    public static double distanceVectors(@NotNull class_2382 firstVector, @NotNull class_2382 secondVector) {
        class_2338 subtractedVectors = subtractVectors(firstVector, secondVector);
        return class_3532.method_15382(subtractedVectors.method_10263()) + class_3532.method_15382(subtractedVectors.method_10264()) + class_3532.method_15382(subtractedVectors.method_10260());
    }

    /**
     * Gets direction.
     *
     * @param firstVector The vector of the block you are checking from
     * @param secondVector The vector of the block you are checking
     * @return the direction
     */
    @Nullable
    public static class_2350 getDirection(@NotNull class_2382 firstVector, @NotNull class_2382 secondVector) {
        class_2382 result = subtractVectors(secondVector, firstVector);

        if (result.equals(class_2350.field_11043.method_10163()))
            return class_2350.field_11043;

        if (result.equals(class_2350.field_11035.method_10163()))
            return class_2350.field_11035;

        if (result.equals(class_2350.field_11034.method_10163()))
            return class_2350.field_11034;

        if (result.equals(class_2350.field_11039.method_10163()))
            return class_2350.field_11039;

        if (result.equals(class_2350.field_11036.method_10163()))
            return class_2350.field_11036;

        if (result.equals(class_2350.field_11033.method_10163()))
            return class_2350.field_11033;

        return class_2350.method_16365(result.method_10263(), result.method_10264(), result.method_10260());
    }
}
