package me.alexisevelyn.randomtech.api.utilities;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_465;
import reborncore.client.screen.builder.BuiltScreenHandler;

/**
 * The interface Gui factory.
 */
@Environment(EnvType.CLIENT)
public interface GuiFactory extends ScreenRegistry.Factory<BuiltScreenHandler, class_465<BuiltScreenHandler>> {
    /**
     * Create handled screen.
     *
     * @param syncId       the sync id
     * @param playerEntity the player entity
     * @param blockEntity  the block entity
     * @return the handled screen
     */
    class_465<BuiltScreenHandler> create(int syncId, class_1657 playerEntity, class_2586 blockEntity);

    /**
     * Create handled screen.
     *
     * @param builtScreenHandler the built screen handler
     * @param playerInventory    the player inventory
     * @param text               the text
     * @return the handled screen
     */
    @Override
    default class_465<BuiltScreenHandler> create(BuiltScreenHandler builtScreenHandler, class_1661 playerInventory, class_2561 text) {
        class_1657 playerEntity = playerInventory.field_7546;

        class_2586 blockEntity = builtScreenHandler.getBlockEntity();
        return create(builtScreenHandler.field_7763, playerEntity, blockEntity);
    }
}
