package me.alexisevelyn.randomtech.api.utilities;

import me.alexisevelyn.randomtech.api.items.energy.EnergyHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import reborncore.common.powerSystem.PowerSystem;
import team.reborn.energy.Energy;
import team.reborn.energy.EnergyHandler;
import team.reborn.energy.EnergyHolder;

import java.util.List;

/**
 * The type Item manager.
 */
public class ItemManager {
    /**
     * Init powered items.
     *
     * @param item     the item
     * @param itemList the item list
     */
    public static void initPoweredItems(class_1792 item, class_2371<class_1799> itemList) {
        // Can be used to add multiple versions of items (e.g. a charged and discharged variant of each armor piece)
        class_1799 uncharged = new class_1799(item);
        class_1799 charged = new class_1799(item);

        class_2487 tag = uncharged.method_7969();

        if (tag != null)
            tag.method_10569("CustomModelData", 1337); // Sets the model to show as dead in the creative inventory and REI

        Energy.of(charged).set(Energy.of(charged).getMaxStored());

        itemList.add(uncharged);
        itemList.add(charged);
    }

    /**
     * Calculate current power for conversion double.
     *
     * @param oldItemStack the old item stack
     * @param newItemStack the new item stack
     * @return the double
     */
    // This converts the old Item Stack's durability to energy based on the current durability, max durability, and max energy capacity.
    protected static double calculateCurrentPowerForConversion(class_1799 oldItemStack, class_1799 newItemStack) {
         EnergyHandler energyHandler = Energy.of(newItemStack);
         double oldDurability = oldItemStack.method_7936() - oldItemStack.method_7919();

         if (newItemStack.method_7909() instanceof EnergyHelper){
             EnergyHelper customEnergyItem = (EnergyHelper) newItemStack.method_7909();

             return (oldDurability * customEnergyItem.getMaxEnergy(newItemStack)) / oldItemStack.method_7936();
        }

         return (oldDurability * energyHandler.getMaxStored()) / oldItemStack.method_7936();
    }

    /**
     * Convert stack to energy item stack item stack.
     *
     * @param oldStack the old stack
     * @param newStack the new stack
     * @param tag      the tag
     * @return the item stack
     */
    public static class_1799 convertStackToEnergyItemStack(class_1799 oldStack, class_1799 newStack, class_2487 tag) {
        // Copy over existing NBT Data such as Enchants
        if (tag != null) {
            class_2487 oldTag = tag.method_10553();
            oldTag.method_10551("Damage");

            newStack.method_7980(oldTag);
        }

        if (!(oldStack.method_7909() instanceof EnergyHolder))
            // Keep Durability of Armor and Tools as Charge By Default When First Crafted
            Energy.of(newStack).set(calculateCurrentPowerForConversion(oldStack, newStack));

        // Sets item model to discharged state if crafted while dead
//        if (Energy.of(newStack).getEnergy() == 0)
//            setDischargedModelData(newStack, false);

        return newStack;
    }

    /**
     * Power level tooltip.
     *
     * @param itemStack the item stack
     * @param tooltip   the tooltip
     */
    @Environment(EnvType.CLIENT)
    public static void powerLevelTooltip(class_1799 itemStack, List<class_2561> tooltip) {
        class_1792 item = itemStack.method_7909();

        if (!(item instanceof EnergyHelper))
            return;

        double currentEnergy = Energy.of(itemStack).getEnergy();
        double maxEnergy = ((EnergyHelper) item).getMaxEnergy(itemStack);

        if (currentEnergy == maxEnergy)
            return;

        // Could use item.durability
        class_2561 energy = new class_2588("text.randomtech.power_level", PowerSystem.getLocaliszedPowerNoSuffix(currentEnergy), PowerSystem.getLocaliszedPower(maxEnergy));
        tooltip.add(energy);

        // Just to put a newline below dead tool energy display
        if (currentEnergy == 0)
            tooltip.add(new class_2585(""));
    }

    /**
     * Use energy.
     *
     * @param livingEntity the living entity
     * @param stack        the stack
     * @param cost         the cost
     */
    // This method exists to allow energy to not be used if the player is in Creative mode
    public static void useEnergy(class_1309 livingEntity, class_1799 stack, int cost) {
        if (livingEntity instanceof class_1657) {
            class_1657 playerEntity = (class_1657) livingEntity;

            if (playerEntity.method_7337())
                return;
        }

        // If more than max amount of energy, just set to rest of energy level
        EnergyHandler currentEnergy = Energy.of(stack);
        if (cost > currentEnergy.getEnergy()) {
            Energy.of(stack).use(currentEnergy.getEnergy());
            return;
        }

        Energy.of(stack).use(cost);
    }
}
