package me.alexisevelyn.randomtech.api.utilities;

import me.alexisevelyn.randomtech.api.items.tools.generic.GenericPoweredTool;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5338;
import net.minecraft.class_79;

/**
 * The type Mining manager.
 */
public class MiningManager {
    /**
     * Can mine boolean.
     *
     * @param context the context
     * @return the boolean
     */
    public static boolean canMine(class_1838 context) {
        class_1657 playerEntity = context.method_8036();
        class_1799 itemStack = context.method_8041();

        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2680 blockState = world.method_8320(blockPos);

        if (playerEntity == null)
            return false;

        return canMine(playerEntity, itemStack, blockState, world, blockPos);
    }

    /**
     * Can mine boolean.
     *
     * @param playerEntity  the player entity
     * @param toolItemStack the tool item stack
     * @param blockState    the block state
     * @param world         the world
     * @param blockPos      the block pos
     * @return the boolean
     */
    // TODO: Check if block requires silk touch.
    public static boolean canMine(class_1657 playerEntity, class_1799 toolItemStack, class_2680 blockState, class_1937 world, class_2338 blockPos) {
        boolean canMine = playerEntity.method_7305(blockState);
        class_1792 item = toolItemStack.method_7909();

        // This checks if the tool is dead
        if (item instanceof GenericPoweredTool && !((GenericPoweredTool) item).isUsable(toolItemStack))
            return false;

        // Checks if block needs silk touch and if so, check if tool has silk touch
        if (!(toolHasSilkTouch(toolItemStack) > 0) && (needsSilkTouch(blockState, world, blockPos) > 0))
            return false;

        if (checkUnbreakableBlock(playerEntity, toolItemStack, blockState, world, blockPos))
            return true;

        return !(blockState.method_26214(world, blockPos) < 0) && canMine;
    }

    /**
     * Check unbreakable block boolean.
     *
     * @param playerEntity  the player entity
     * @param toolItemStack the tool item stack
     * @param blockState    the block state
     * @param world         the world
     * @param blockPos      the block pos
     * @return the boolean
     */
    // Checks if the block can be broken by the tool. Requires special override in the tool's class.
    public static boolean checkUnbreakableBlock(class_1657 playerEntity, class_1799 toolItemStack, class_2680 blockState, class_1937 world, class_2338 blockPos) {
        if (!(blockState.method_26214(world, blockPos) < 0))
            return false;

        if (!(toolItemStack.method_7909() instanceof GenericPoweredTool))
            return false;

        GenericPoweredTool genericPoweredTool = (GenericPoweredTool) toolItemStack.method_7909();
        return genericPoweredTool.canBreakUnbreakableBlock(blockState, playerEntity, world, blockPos);
    }

    /**
     * Needs silk touch int.
     *
     * @param context the context
     * @return the int
     */
    public static int needsSilkTouch(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2680 blockState = world.method_8320(blockPos);

        return needsSilkTouch(blockState, world, blockPos);
    }

    /**
     * Needs silk touch int.
     *
     * @param blockState the block state
     * @param world      the world
     * @param blockPos   the block pos
     * @return the int
     */
    // This is an integer so I can return the level of silk touch needed
    public static int needsSilkTouch(class_2680 blockState, class_1937 world, class_2338 blockPos) {
        class_2960 blockLootTableID = blockState.method_26204().method_26162();
        class_5338 lootPoolEntryType = class_2378.field_25293.method_10223(blockLootTableID);
        class_79 lootPoolEntry;

        // TODO: Figure out how to tell if a block needs silk touch
        return 0;
    }

    /**
     * Tool has silk touch short.
     *
     * @param itemStack the item stack
     * @return the short
     */
    // This is an integer so I can return the level of silk touch on the tool
    public static short toolHasSilkTouch(class_1799 itemStack) {
        // Enchantments: [{lvl: 5s, id: "minecraft:efficiency"}, {lvl: 1s, id: "minecraft:silk_touch"}]

        class_2499 enchantments = itemStack.method_7921();
        class_2487 compoundTag;
        class_2520 currentID;

        short silkTouchLevel = 0;

        for (int i = 0; i < enchantments.size(); i++) {
            compoundTag = enchantments.method_10602(i);
            currentID = compoundTag.method_10580("id");

            if (currentID == null)
                break;

            if (currentID.method_10714().equals("minecraft:silk_touch")) {
                silkTouchLevel = compoundTag.method_10568("lvl");

                break;
            }
        }

        // System.out.println("Silk Touch Level: " + silkTouchLevel);

        return silkTouchLevel;
    }
}
