package me.alexisevelyn.randomtech.api.utilities.enchanting;

import me.alexisevelyn.randomtech.api.items.armor.generic.GenericPoweredArmor;
import me.alexisevelyn.randomtech.api.items.energy.EnergyHelper;
import me.alexisevelyn.randomtech.api.items.tools.generic.*;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1886;

/**
 * The type Custom enchantment helper.
 */
public class CustomEnchantmentHelper {
    /**
     * The enum Valid enchant.
     */
    public enum ValidEnchant {
        VANILLA,
        FALSE,
        TRUE
    }

    /**
     * Is valid enchantment valid enchant.
     *
     * @param itemStack the item stack
     * @param target    the target
     * @return the valid enchant
     */
    // I need to be able to tell whether or not to interfere with vanilla enchant mechanics, so I'm using an enum to have 3 possible outcomes instead of just 2.
    public static ValidEnchant isValidEnchantment(class_1799 itemStack, class_1886 target) {
        if (itemStack.method_7909() instanceof EnergyHelper) {
            // I use unbreaking to affect energy usage, so I'm allowing Unbreaking and Mending.
            if (target == class_1886.field_9082) {
                return ValidEnchant.TRUE;
            }
        }

        // Every Vanilla Mining Tool Except For Swords
        if ((itemStack.method_7909() instanceof GenericPoweredAxe || itemStack.method_7909() instanceof GenericPoweredHoe || itemStack.method_7909() instanceof GenericPoweredPickaxe || itemStack.method_7909() instanceof GenericPoweredShovel) && target == class_1886.field_9069) {
            return ValidEnchant.TRUE;
        }

        // For Swords and Axes Specifically
        if ((itemStack.method_7909() instanceof GenericPoweredSword || itemStack.method_7909() instanceof GenericPoweredAxe) && target == class_1886.field_9074) {
            return ValidEnchant.TRUE;
        }

        // Disables Mining Tool Enchants For Sword
        // NOTE: Don't disable axe, vanilla allows axe to use Mining Tool Enchants
        // I don't know why vanilla axes don't allow Looting, but I'm allowing it on my axes
        if ((itemStack.method_7909() instanceof GenericPoweredSword) && target == class_1886.field_9069) {
            return ValidEnchant.FALSE;
        }

        // For Armor - Should be unnecessary given that I extend ArmorItem, but it can't hurt.
        if (itemStack.method_7909() instanceof GenericPoweredArmor) {
            GenericPoweredArmor armor = (GenericPoweredArmor) itemStack.method_7909();

            if (target == class_1886.field_9068)
                return ValidEnchant.TRUE;
            else if (armor.method_7685() == class_1304.field_6169 && target == class_1886.field_9080)
                return ValidEnchant.TRUE;
            else if (armor.method_7685() == class_1304.field_6174 && target == class_1886.field_9071)
                return ValidEnchant.TRUE;
            else if (armor.method_7685() == class_1304.field_6172 && target == class_1886.field_9076)
                return ValidEnchant.TRUE;
            else if (armor.method_7685() == class_1304.field_6166 && target == class_1886.field_9079)
                return ValidEnchant.TRUE;
        }

        // TODO: Implement these tool and armor enchants when I create tool and armor that needs them.
        // Unimplemented Custom Items
        // Fishing Rod, Trident, Bow, Wearable, Crossbow, Vanishable

        return ValidEnchant.VANILLA;
    }
}
