/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.bean.WxMenu;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.StringUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.MediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.WxMpCustomMessage;
import me.chanjar.weixin.mp.bean.WxMpGroup;
import me.chanjar.weixin.mp.bean.WxMpMassGroupMessage;
import me.chanjar.weixin.mp.bean.WxMpMassNews;
import me.chanjar.weixin.mp.bean.WxMpMassOpenIdsMessage;
import me.chanjar.weixin.mp.bean.WxMpMassVideo;
import me.chanjar.weixin.mp.bean.WxMpSemanticQuery;
import me.chanjar.weixin.mp.bean.WxMpTemplateMessage;
import me.chanjar.weixin.mp.bean.result.WxMpMassSendResult;
import me.chanjar.weixin.mp.bean.result.WxMpMassUploadResult;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpQrCodeTicket;
import me.chanjar.weixin.mp.bean.result.WxMpSemanticQueryResult;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserCumulate;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import me.chanjar.weixin.mp.bean.result.WxMpUserSummary;
import me.chanjar.weixin.mp.util.http.QrCodeRequestExecutor;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WxMpServiceImpl
implements WxMpService {
    protected final Logger log = LoggerFactory.getLogger(WxMpServiceImpl.class);
    protected final Object globalAccessTokenRefreshLock = new Object();
    protected final Object globalJsapiTicketRefreshLock = new Object();
    protected WxMpConfigStorage wxMpConfigStorage;
    protected CloseableHttpClient httpClient;
    protected HttpHost httpProxy;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;
    protected WxSessionManager sessionManager = new StandardSessionManager();

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.wxMpConfigStorage.getToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.wxMpConfigStorage.expireAccessToken();
        }
        if (this.wxMpConfigStorage.isAccessTokenExpired()) {
            Object object = this.globalAccessTokenRefreshLock;
            synchronized (object) {
                if (this.wxMpConfigStorage.isAccessTokenExpired()) {
                    String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.wxMpConfigStorage.getAppId() + "&secret=" + this.wxMpConfigStorage.getSecret();
                    try {
                        CloseableHttpClient httpclient;
                        CloseableHttpResponse response;
                        String resultContent;
                        WxError error;
                        HttpGet httpGet = new HttpGet(url);
                        if (this.httpProxy != null) {
                            RequestConfig config = RequestConfig.custom().setProxy(this.httpProxy).build();
                            httpGet.setConfig(config);
                        }
                        if ((error = WxError.fromJson((String)(resultContent = new BasicResponseHandler().handleResponse((HttpResponse)(response = (httpclient = this.getHttpclient()).execute((HttpUriRequest)httpGet)))))).getErrorCode() != 0) {
                            throw new WxErrorException(error);
                        }
                        WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
                        this.wxMpConfigStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
                    }
                    catch (ClientProtocolException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.wxMpConfigStorage.getAccessToken();
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.wxMpConfigStorage.expireJsapiTicket();
        }
        if (this.wxMpConfigStorage.isJsapiTicketExpired()) {
            Object object = this.globalJsapiTicketRefreshLock;
            synchronized (object) {
                if (this.wxMpConfigStorage.isJsapiTicketExpired()) {
                    String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi";
                    String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
                    JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
                    JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                    String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
                    int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                    this.wxMpConfigStorage.updateJsapiTicket(jsapiTicket, expiresInSeconds);
                }
            }
        }
        return this.wxMpConfigStorage.getJsapiTicket();
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        try {
            String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
            WxJsapiSignature jsapiSignature = new WxJsapiSignature();
            jsapiSignature.setTimestamp(timestamp);
            jsapiSignature.setNoncestr(noncestr);
            jsapiSignature.setUrl(url);
            jsapiSignature.setSignature(signature);
            return jsapiSignature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void customMessageSend(WxMpCustomMessage message) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/custom/send";
        this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)message.toJson());
    }

    @Override
    public void menuCreate(WxMenu menu) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/create";
        this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)menu.toJson());
    }

    @Override
    public void menuDelete() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete";
        this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
    }

    @Override
    public WxMenu menuGet() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/menu/get";
        try {
            String resultContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
            return WxMenu.fromJson((String)resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 46003) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, String fileType, InputStream inputStream) throws WxErrorException, IOException {
        return this.mediaUpload(mediaType, FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType));
    }

    @Override
    public WxMediaUploadResult mediaUpload(String mediaType, File file) throws WxErrorException {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/upload?type=" + mediaType;
        return (WxMediaUploadResult)this.execute((RequestExecutor)new MediaUploadRequestExecutor(), url, (Object)file);
    }

    @Override
    public File mediaDownload(String media_id) throws WxErrorException {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/get";
        return (File)this.execute((RequestExecutor)new MediaDownloadRequestExecutor(), url, (Object)("media_id=" + media_id));
    }

    @Override
    public WxMpMassUploadResult massNewsUpload(WxMpMassNews news) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/media/uploadnews";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)news.toJson());
        return WxMpMassUploadResult.fromJson(responseContent);
    }

    @Override
    public WxMpMassUploadResult massVideoUpload(WxMpMassVideo video) throws WxErrorException {
        String url = "http://file.api.weixin.qq.com/cgi-bin/media/uploadvideo";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)video.toJson());
        return WxMpMassUploadResult.fromJson(responseContent);
    }

    @Override
    public WxMpMassSendResult massGroupMessageSend(WxMpMassGroupMessage message) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)message.toJson());
        return WxMpMassSendResult.fromJson(responseContent);
    }

    @Override
    public WxMpMassSendResult massOpenIdsMessageSend(WxMpMassOpenIdsMessage message) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/mass/send";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)message.toJson());
        return WxMpMassSendResult.fromJson(responseContent);
    }

    @Override
    public WxMpGroup groupCreate(String name) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/create";
        JsonObject json = new JsonObject();
        JsonObject groupJson = new JsonObject();
        json.add("group", (JsonElement)groupJson);
        groupJson.addProperty("name", name);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
        return WxMpGroup.fromJson(responseContent);
    }

    @Override
    public List<WxMpGroup> groupGet() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/get";
        String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, null);
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("groups"), new TypeToken<List<WxMpGroup>>(){}.getType());
    }

    @Override
    public long userGetGroup(String openid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/getid";
        JsonObject o = new JsonObject();
        o.addProperty("openid", openid);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)o.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return GsonHelper.getAsLong((JsonElement)tmpJsonElement.getAsJsonObject().get("groupid"));
    }

    @Override
    public void groupUpdate(WxMpGroup group) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/update";
        this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)group.toJson());
    }

    @Override
    public void userUpdateGroup(String openid, long to_groupid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/groups/members/update";
        JsonObject json = new JsonObject();
        json.addProperty("openid", openid);
        json.addProperty("to_groupid", (Number)to_groupid);
        this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
    }

    @Override
    public void userUpdateRemark(String openid, String remark) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/user/info/updateremark";
        JsonObject json = new JsonObject();
        json.addProperty("openid", openid);
        json.addProperty("remark", remark);
        this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
    }

    @Override
    public WxMpUser userInfo(String openid, String lang) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/user/info";
        lang = lang == null ? "zh_CN" : lang;
        String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, (Object)("openid=" + openid + "&lang=" + lang));
        return WxMpUser.fromJson(responseContent);
    }

    @Override
    public WxMpUserList userList(String next_openid) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/user/get";
        String responseContent = (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, (Object)(next_openid == null ? null : "next_openid=" + next_openid));
        return WxMpUserList.fromJson(responseContent);
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateTmpTicket(int scene_id, Integer expire_seconds) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create";
        JsonObject json = new JsonObject();
        json.addProperty("action_name", "QR_SCENE");
        if (expire_seconds != null) {
            json.addProperty("expire_seconds", (Number)expire_seconds);
        }
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        scene.addProperty("scene_id", (Number)scene_id);
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
        return WxMpQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public WxMpQrCodeTicket qrCodeCreateLastTicket(int scene_id) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create";
        JsonObject json = new JsonObject();
        json.addProperty("action_name", "QR_LIMIT_SCENE");
        JsonObject actionInfo = new JsonObject();
        JsonObject scene = new JsonObject();
        scene.addProperty("scene_id", (Number)scene_id);
        actionInfo.add("scene", (JsonElement)scene);
        json.add("action_info", (JsonElement)actionInfo);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)json.toString());
        return WxMpQrCodeTicket.fromJson(responseContent);
    }

    @Override
    public File qrCodePicture(WxMpQrCodeTicket ticket) throws WxErrorException {
        String url = "https://mp.weixin.qq.com/cgi-bin/showqrcode";
        return this.execute(new QrCodeRequestExecutor(), url, ticket);
    }

    @Override
    public String shortUrl(String long_url) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/shorturl";
        JsonObject o = new JsonObject();
        o.addProperty("action", "long2short");
        o.addProperty("long_url", long_url);
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)o.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return tmpJsonElement.getAsJsonObject().get("short_url").getAsString();
    }

    @Override
    public String templateSend(WxMpTemplateMessage templateMessage) throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)templateMessage.toJson());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return tmpJsonElement.getAsJsonObject().get("msgid").getAsString();
    }

    @Override
    public WxMpSemanticQueryResult semanticQuery(WxMpSemanticQuery semanticQuery) throws WxErrorException {
        String url = "https://api.weixin.qq.com/semantic/semproxy/search";
        String responseContent = (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)semanticQuery.toJson());
        return WxMpSemanticQueryResult.fromJson(responseContent);
    }

    @Override
    public String oauth2buildAuthorizationUrl(String scope, String state) {
        return this.oauth2buildAuthorizationUrl(this.wxMpConfigStorage.getOauth2redirectUri(), scope, state);
    }

    @Override
    public String oauth2buildAuthorizationUrl(String redirectURI, String scope, String state) {
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?";
        url = url + "appid=" + this.wxMpConfigStorage.getAppId();
        url = url + "&redirect_uri=" + URIUtil.encodeURIComponent((String)redirectURI);
        url = url + "&response_type=code";
        url = url + "&scope=" + scope;
        if (state != null) {
            url = url + "&state=" + state;
        }
        url = url + "#wechat_redirect";
        return url;
    }

    @Override
    public WxMpOAuth2AccessToken oauth2getAccessToken(String code) throws WxErrorException {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?";
        url = url + "appid=" + this.wxMpConfigStorage.getAppId();
        url = url + "&secret=" + this.wxMpConfigStorage.getSecret();
        url = url + "&code=" + code;
        url = url + "&grant_type=authorization_code";
        try {
            SimpleGetRequestExecutor executor = new SimpleGetRequestExecutor();
            String responseText = (String)executor.execute(this.getHttpclient(), this.httpProxy, url, null);
            return WxMpOAuth2AccessToken.fromJson(responseText);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WxMpOAuth2AccessToken oauth2refreshAccessToken(String refreshToken) throws WxErrorException {
        String url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?";
        url = url + "appid=" + this.wxMpConfigStorage.getAppId();
        url = url + "&grant_type=refresh_token";
        url = url + "&refresh_token=" + refreshToken;
        try {
            SimpleGetRequestExecutor executor = new SimpleGetRequestExecutor();
            String responseText = (String)executor.execute(this.getHttpclient(), this.httpProxy, url, null);
            return WxMpOAuth2AccessToken.fromJson(responseText);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WxMpUser oauth2getUserInfo(WxMpOAuth2AccessToken oAuth2AccessToken, String lang) throws WxErrorException {
        String url = "https://api.weixin.qq.com/sns/userinfo?";
        url = url + "access_token=" + oAuth2AccessToken.getAccessToken();
        url = url + "&openid=" + oAuth2AccessToken.getOpenId();
        url = lang == null ? url + "&lang=zh_CN" : url + "&lang=" + lang;
        try {
            SimpleGetRequestExecutor executor = new SimpleGetRequestExecutor();
            String responseText = (String)executor.execute(this.getHttpclient(), this.httpProxy, url, null);
            return WxMpUser.fromJson(responseText);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean oauth2validateAccessToken(WxMpOAuth2AccessToken oAuth2AccessToken) {
        String url = "https://api.weixin.qq.com/sns/auth?";
        url = url + "access_token=" + oAuth2AccessToken.getAccessToken();
        url = url + "&openid=" + oAuth2AccessToken.getOpenId();
        try {
            SimpleGetRequestExecutor executor = new SimpleGetRequestExecutor();
            executor.execute(this.getHttpclient(), this.httpProxy, url, null);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (WxErrorException e) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getCallbackIP() throws WxErrorException {
        String url = "https://api.weixin.qq.com/cgi-bin/getcallbackip";
        String responseContent = this.get(url, null);
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        JsonArray ipList = tmpJsonElement.getAsJsonObject().get("ip_list").getAsJsonArray();
        String[] ipArray = new String[ipList.size()];
        for (int i = 0; i < ipList.size(); ++i) {
            ipArray[i] = ipList.get(i).getAsString();
        }
        return ipArray;
    }

    @Override
    public List<WxMpUserSummary> getUserSummary(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getusersummary";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.post(url, param.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("list"), new TypeToken<List<WxMpUserSummary>>(){}.getType());
    }

    @Override
    public List<WxMpUserCumulate> getUserCumulate(Date beginDate, Date endDate) throws WxErrorException {
        String url = "https://api.weixin.qq.com/datacube/getusercumulate";
        JsonObject param = new JsonObject();
        param.addProperty("begin_date", SIMPLE_DATE_FORMAT.format(beginDate));
        param.addProperty("end_date", SIMPLE_DATE_FORMAT.format(endDate));
        String responseContent = this.post(url, param.toString());
        JsonElement tmpJsonElement = Streams.parse((JsonReader)new JsonReader((Reader)new StringReader(responseContent)));
        return (List)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement.getAsJsonObject().get("list"), new TypeToken<List<WxMpUserCumulate>>(){}.getType());
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute((RequestExecutor)new SimpleGetRequestExecutor(), url, (Object)queryParam);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute((RequestExecutor)new SimplePostRequestExecutor(), url, (Object)postData);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        this.log.debug("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{}ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                } else {
                    throw e;
                }
                if (++retryTimes < this.maxRetryTimes) continue;
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri;
        uriWithAccessToken = uriWithAccessToken + (uri.indexOf(63) == -1 ? "?access_token=" + accessToken : "&access_token=" + accessToken);
        try {
            return (T)executor.execute(this.getHttpclient(), this.httpProxy, uriWithAccessToken, data);
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40001) {
                this.wxMpConfigStorage.expireAccessToken();
                return this.execute(executor, uri, data);
            }
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            return null;
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected CloseableHttpClient getHttpclient() {
        return this.httpClient;
    }

    @Override
    public void setWxMpConfigStorage(WxMpConfigStorage wxConfigProvider) {
        this.wxMpConfigStorage = wxConfigProvider;
        String http_proxy_host = this.wxMpConfigStorage.getHttp_proxy_host();
        int http_proxy_port = this.wxMpConfigStorage.getHttp_proxy_port();
        String http_proxy_username = this.wxMpConfigStorage.getHttp_proxy_username();
        String http_proxy_password = this.wxMpConfigStorage.getHttp_proxy_password();
        if (StringUtils.isNotBlank((CharSequence)http_proxy_host)) {
            if (StringUtils.isNotBlank((CharSequence)http_proxy_username)) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(http_proxy_host, http_proxy_port), (Credentials)new UsernamePasswordCredentials(http_proxy_username, http_proxy_password));
                this.httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            } else {
                this.httpClient = HttpClients.createDefault();
            }
            this.httpProxy = new HttpHost(http_proxy_host, http_proxy_port);
        } else {
            this.httpClient = HttpClients.createDefault();
        }
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }
}

