/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.android.aligntextview;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import me.codeboy.android.aligntextview.R;
import me.codeboy.android.aligntextview.util.CBAlignTextViewUtil;

public class CBAlignTextView
extends TextView {
    private static final char SPACE = ' ';
    private List<Integer> addCharPosition = new ArrayList<Integer>();
    private static List<Character> punctuation = new ArrayList<Character>();
    private CharSequence oldText = "";
    private CharSequence newText = "";
    private boolean inProcess = false;
    private boolean isAddPadding = false;
    private boolean isConvert = false;
    private boolean isAddListener = false;

    public CBAlignTextView(Context context) {
        super(context);
        this.addLayoutListener();
    }

    public CBAlignTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CBAlignTextView);
        this.isConvert = ta.getBoolean(R.styleable.CBAlignTextView_punctuationConvert, false);
        ta.recycle();
        this.addLayoutListener();
        TypedArray tsa = context.obtainStyledAttributes(attrs, new int[]{16843087});
        String text = tsa.getString(0);
        tsa.recycle();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            this.setText(text);
        }
    }

    public boolean onTextContextMenuItem(int id2) {
        if (id2 == 0x1020021) {
            if (this.isFocused()) {
                int selStart = this.getSelectionStart();
                int selEnd = this.getSelectionEnd();
                int min = Math.max(0, Math.min(selStart, selEnd));
                int max = Math.max(0, Math.max(selStart, selEnd));
                try {
                    Class<?> cls = ((Object)((Object)this)).getClass().getSuperclass();
                    Method getSelectTextMethod = cls.getDeclaredMethod("getTransformedText", Integer.TYPE, Integer.TYPE);
                    getSelectTextMethod.setAccessible(true);
                    CharSequence selectedText = (CharSequence)getSelectTextMethod.invoke((Object)this, min, max);
                    this.copy(selectedText.toString());
                    Method closeMenuMethod = Build.VERSION.SDK_INT < 23 ? cls.getDeclaredMethod("stopSelectionActionMode", new Class[0]) : cls.getDeclaredMethod("stopTextActionMode", new Class[0]);
                    closeMenuMethod.setAccessible(true);
                    closeMenuMethod.invoke((Object)this, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return super.onTextContextMenuItem(id2);
    }

    private void copy(String text) {
        ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
        int start = this.newText.toString().indexOf(text);
        int end = start + text.length();
        StringBuilder sb = new StringBuilder(text);
        for (int i = this.addCharPosition.size() - 1; i >= 0; --i) {
            int position = this.addCharPosition.get(i);
            if (position >= end || position < start) continue;
            sb.deleteCharAt(position - start);
        }
        ClipData clip = ClipData.newPlainText(null, (CharSequence)sb.toString());
        clipboard.setPrimaryClip(clip);
    }

    private String processText(Paint paint, String text, int width) {
        if (text == null || text.length() == 0) {
            return "";
        }
        String[] lines = text.split("\\n");
        StringBuilder newText = new StringBuilder();
        for (String line : lines) {
            newText.append('\n');
            newText.append(this.processLine(paint, line, width, newText.length() - 1));
        }
        if (newText.length() > 0) {
            newText.deleteCharAt(0);
        }
        return newText.toString();
    }

    private String processLine(Paint paint, String text, int width, int addCharacterStartPosition) {
        if (text == null || text.length() == 0) {
            return "";
        }
        StringBuilder old = new StringBuilder(text);
        int startPosition = 0;
        float chineseWidth = paint.measureText("\u4e2d");
        float spaceWidth = paint.measureText(" ");
        int maxChineseCount = (int)((float)width / chineseWidth);
        if (--maxChineseCount <= 0) {
            return "";
        }
        for (int i = maxChineseCount; i < old.length(); ++i) {
            if (!(paint.measureText(old.substring(startPosition, i + 1)) > (float)width - spaceWidth)) continue;
            float gap = (float)width - spaceWidth - paint.measureText(old.substring(startPosition, i));
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int j = startPosition; j < i; ++j) {
                char ch = old.charAt(j);
                if (!punctuation.contains(Character.valueOf(ch))) continue;
                positions.add(j + 1);
            }
            int number = (int)(gap / spaceWidth);
            int use = 0;
            if (positions.size() > 0) {
                for (int k = 0; k < positions.size() && number > 0; ++k) {
                    int times = number / (positions.size() - k);
                    int position = (Integer)positions.get(k / positions.size());
                    for (int m = 0; m < times; ++m) {
                        old.insert(position + m, ' ');
                        this.addCharPosition.add(position + m + addCharacterStartPosition);
                        ++use;
                        --number;
                    }
                }
            }
            old.insert(i += use, ' ');
            this.addCharPosition.add(i + addCharacterStartPosition);
            startPosition = i + 1;
            i += maxChineseCount;
        }
        return old.toString();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.addCharPosition == null) {
            super.setText(text, type);
            return;
        }
        if (!this.inProcess && text != null && !text.equals(this.newText)) {
            this.oldText = text;
            if (!this.isAddListener) {
                this.addLayoutListener();
            }
            this.process(false);
            super.setText(this.newText, type);
        } else {
            this.inProcess = false;
            super.setText(text, type);
        }
    }

    public CharSequence getRealText() {
        return this.oldText;
    }

    private void process(boolean setText) {
        if (this.oldText == null) {
            this.oldText = "";
        }
        if (!this.inProcess && this.getVisibility() == 0) {
            this.addCharPosition.clear();
            if (this.isConvert) {
                this.oldText = CBAlignTextViewUtil.replacePunctuation(this.oldText.toString());
            }
            if (this.getWidth() == 0) {
                return;
            }
            if (!this.isAddPadding) {
                int spaceWidth = (int)this.getPaint().measureText(" ");
                this.newText = this.processText((Paint)this.getPaint(), this.oldText.toString(), this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() - spaceWidth);
                this.setPadding(this.getPaddingLeft() + spaceWidth, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
                this.isAddPadding = true;
            } else {
                this.newText = this.processText((Paint)this.getPaint(), this.oldText.toString(), this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
            }
            this.inProcess = true;
            if (setText) {
                this.setText(this.newText);
            }
        }
    }

    private void addLayoutListener() {
        this.isAddListener = true;
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (CBAlignTextView.this.getWidth() == 0) {
                    return;
                }
                CBAlignTextView.this.process(true);
                if (Build.VERSION.SDK_INT >= 16) {
                    CBAlignTextView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    CBAlignTextView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                CBAlignTextView.this.isAddListener = false;
            }
        });
    }

    public void setPunctuationConvert(boolean convert) {
        this.isConvert = convert;
    }

    static {
        punctuation.clear();
        punctuation.add(Character.valueOf(','));
        punctuation.add(Character.valueOf('.'));
        punctuation.add(Character.valueOf('?'));
        punctuation.add(Character.valueOf('!'));
        punctuation.add(Character.valueOf(';'));
        punctuation.add(Character.valueOf('\uff0c'));
        punctuation.add(Character.valueOf('\u3002'));
        punctuation.add(Character.valueOf('\uff1f'));
        punctuation.add(Character.valueOf('\uff01'));
        punctuation.add(Character.valueOf('\uff1b'));
        punctuation.add(Character.valueOf('\uff09'));
        punctuation.add(Character.valueOf('\u3011'));
        punctuation.add(Character.valueOf(')'));
        punctuation.add(Character.valueOf(']'));
        punctuation.add(Character.valueOf('}'));
    }
}

