/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.common.base.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class CBFile {
    public String getFileContent(String filePath) throws IOException {
        return this.getFileContent(filePath, "UTF-8");
    }

    public String getFileContent(String filePath, String encoding) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), encoding));
        String content = this.getContent(buff);
        buff.close();
        return content;
    }

    public List<String> getFileContentAsList(String filePath) throws IOException {
        return Arrays.asList(this.getFileContent(filePath).split("\\n"));
    }

    public List<String> getFileContentAsList(File file) throws IOException {
        return this.getFileContentAsList(file, "UTF-8");
    }

    public List<String> getFileContentAsList(String filePath, String encoding) throws IOException {
        return Arrays.asList(this.getFileContent(filePath, encoding).split("\\n"));
    }

    public List<String> getFileContentAsList(File file, String encoding) throws IOException {
        return Arrays.asList(this.getFileContent(new FileInputStream(file), encoding).split("\\n"));
    }

    public String getFileContent(File file) throws IOException {
        return this.getFileContent(new FileInputStream(file));
    }

    public String getFileContent(InputStream is) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String content = this.getContent(buff);
        buff.close();
        return content;
    }

    public String getFileContent(InputStream is, String encoding) throws IOException {
        BufferedReader buff = new BufferedReader(new InputStreamReader(is, encoding));
        String content = this.getContent(buff);
        buff.close();
        return content;
    }

    private String getContent(BufferedReader buff) throws IOException {
        String line;
        StringBuffer content = new StringBuffer();
        while ((line = buff.readLine()) != null) {
            content.append('\n');
            content.append(line);
        }
        return content.substring(1).toString();
    }

    public void saveContentToFile(String content, String filePath) throws IOException {
        this.saveContentToFile(content, filePath, "UTF-8");
    }

    public void saveContentToFile(URL url, String filePath) throws IOException {
        InputStream is = url.openStream();
        FileOutputStream fos = new FileOutputStream(filePath);
        byte[] b = new byte[1024];
        int len = 0;
        while ((len = is.read(b)) != -1) {
            fos.write(b, 0, len);
        }
        fos.flush();
        fos.close();
        is.close();
    }

    public void saveContentToFile(String content, String filePath, String encoding) throws IOException {
        BufferedWriter buff = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), encoding));
        buff.write(content);
        buff.flush();
        buff.close();
    }
}

