/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.common.base.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import me.codeboy.common.base.net.CBNetRequest;
import me.codeboy.common.base.security.CBHostnameVerifier;
import me.codeboy.common.base.security.CBX509TrustManager;

public class CBHttps
extends CBNetRequest {
    @Override
    public String get(String address, String encoding) throws IOException {
        String line;
        StringBuffer netString = new StringBuffer();
        URL url = new URL(address);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        this.insertRequestHeader(conn);
        this.insertUserAgent(conn);
        BufferedReader buff = new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding));
        while ((line = buff.readLine()) != null) {
            netString.append("\n");
            netString.append(line);
        }
        buff.close();
        return netString.substring(1);
    }

    @Override
    public String post(String address, String encoding, String params) throws IOException {
        String line;
        StringBuffer netString = new StringBuffer();
        URL url = new URL(address);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        this.insertRequestHeader(conn);
        this.insertUserAgent(conn);
        conn.setDoOutput(true);
        conn.getOutputStream().write(params.getBytes(encoding));
        BufferedReader buff = new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding));
        while ((line = buff.readLine()) != null) {
            netString.append("\n");
            netString.append(line);
        }
        buff.close();
        return netString.substring(1);
    }

    @Override
    public void saveNetworkFile(String address, String filePath) throws IOException {
        int len;
        URL url = new URL(address);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        InputStream is = conn.getInputStream();
        File desFile = new File(filePath);
        FileOutputStream os = new FileOutputStream(desFile);
        byte[] b = new byte[1024];
        while ((len = is.read(b)) != -1) {
            ((OutputStream)os).write(b, 0, len);
        }
        ((OutputStream)os).close();
        is.close();
    }

    static {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            TrustManager[] xtmArray = new X509TrustManager[]{new CBX509TrustManager()};
            sslContext.init(null, xtmArray, new SecureRandom());
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(new CBHostnameVerifier());
    }
}

