/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.common.base.net;

import java.io.IOException;
import java.net.URLConnection;
import java.util.Map;
import me.codeboy.common.base.net.CBNetParam;

public abstract class CBNetRequest {
    private String userAgent;
    private Map<String, String> header;

    public CBNetRequest setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public CBNetRequest addDefaultPcUserAgent() {
        this.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2490.80 Safari/537.36";
        return this;
    }

    public CBNetRequest addDefaultMobileUserAgent() {
        this.userAgent = "Mozilla/5.0 (Linux; Android 5.1.1; Nexus 5 Build/LMY48M) AppleWebKit/537.36 (KHTML, like Gecko) ";
        return this;
    }

    public CBNetRequest setRequestHeader(Map<String, String> header) {
        this.header = header;
        return this;
    }

    public String get(String address) throws IOException {
        return this.get(address, "UTF-8");
    }

    public abstract String get(String var1, String var2) throws IOException;

    public String post(String address, String ... params) throws IOException {
        return this.post(address, "UTF-8", CBNetParam.paramsToString(params));
    }

    public String post(String address, String encoding, String ... params) throws IOException {
        return this.post(address, encoding, CBNetParam.paramsToString(params));
    }

    public String post(String address, Map<String, String> params) throws IOException {
        return this.post(address, "UTF-8", CBNetParam.paramsToString(params));
    }

    public String post(String address, String encoding, Map<String, String> params) throws IOException {
        return this.post(address, encoding, CBNetParam.paramsToString(params));
    }

    public abstract String post(String var1, String var2, String var3) throws IOException;

    public abstract void saveNetworkFile(String var1, String var2) throws IOException;

    protected void insertUserAgent(URLConnection conn) {
        if (this.userAgent != null) {
            conn.setRequestProperty("User-Agent", this.userAgent);
        }
    }

    protected void insertRequestHeader(URLConnection conn) {
        if (this.header != null) {
            for (Map.Entry<String, String> entry : this.header.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }
}

