/*
 * Decompiled with CFR 0.152.
 */
package me.codeboy.common.base.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CBMapSortUtil<K, V> {
    private final int GROW_UP = 1;
    private final int GROW_DOWN = -1;

    public Map<K, V> getMapSortByValueUp(Map<K, V> sourceMap) {
        return this.sortByValue(sourceMap, 1);
    }

    public Map<K, V> getMapSortByValueDown(Map<K, V> sourceMap) {
        return this.sortByValue(sourceMap, -1);
    }

    public Map<K, V> getMapSortByKeyUp(Map<K, V> sourceMap) {
        return this.sortByKey(sourceMap, 1);
    }

    public Map<K, V> getMapSortByKeyDown(Map<K, V> sourceMap) {
        return this.sortByKey(sourceMap, -1);
    }

    private Map<K, V> sortByKey(Map<K, V> sourceMap, final int growthPattern) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(sourceMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                Object k1 = o1.getKey();
                Object k2 = o2.getKey();
                return CBMapSortUtil.this.compareValue(k1, k2) * growthPattern;
            }
        });
        LinkedHashMap desMap = new LinkedHashMap();
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry item = (Map.Entry)list.get(i);
            desMap.put(item.getKey(), item.getValue());
        }
        return desMap;
    }

    private Map<K, V> sortByValue(Map<K, V> sourceMap, final int growthPattern) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(sourceMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                Object v1 = o1.getValue();
                Object v2 = o2.getValue();
                return CBMapSortUtil.this.compareValue(v1, v2) * growthPattern;
            }
        });
        LinkedHashMap desMap = new LinkedHashMap();
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry item = (Map.Entry)list.get(i);
            desMap.put(item.getKey(), item.getValue());
        }
        return desMap;
    }

    private int compareValue(Object v1, Object v2) {
        if (v1 instanceof Integer) {
            return Integer.compare((Integer)v1, (Integer)v2);
        }
        if (v1 instanceof Float) {
            return Float.compare(((Float)v1).floatValue(), ((Float)v2).floatValue());
        }
        if (v1 instanceof Double) {
            return Double.compare((Double)v1, (Double)v2);
        }
        if (v1 instanceof Long) {
            return Long.compare((Long)v1, (Long)v2);
        }
        if (v1 instanceof Character) {
            return Character.compare(((Character)v1).charValue(), ((Character)v2).charValue());
        }
        if (v1 instanceof Short) {
            return Short.compare((Short)v1, (Short)v2);
        }
        return 0;
    }
}

