/*
 * Decompiled with CFR 0.152.
 */
package me.johnniang.wechat.config;

import java.util.Map;
import me.johnniang.wechat.properties.WechatProperties;
import me.johnniang.wechat.service.WechatService;
import me.johnniang.wechat.service.impl.DefaultWechatServiceImpl;
import me.johnniang.wechat.support.message.handler.WechatMessageHandler;
import me.johnniang.wechat.support.message.handler.WechatMessageHandlerComposite;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WechatProperties.class})
@ConditionalOnClass(value={WechatService.class})
public class WechatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WechatService wechatService(WechatProperties wechatProperties) {
        return new DefaultWechatServiceImpl(wechatProperties);
    }

    @Bean
    public WechatMessageHandlerComposite handlerComposite(ApplicationContext applicationContext) {
        WechatMessageHandlerComposite handlerComposite = new WechatMessageHandlerComposite();
        Map wechatMessageHandlerMap = applicationContext.getBeansOfType(WechatMessageHandler.class);
        return handlerComposite.addHanlders(wechatMessageHandlerMap.values());
    }
}

