/*
 * Decompiled with CFR 0.152.
 */
package me.johnniang.wechat.service.impl;

import me.johnniang.wechat.exception.WechatException;
import me.johnniang.wechat.properties.WechatProperties;
import me.johnniang.wechat.service.WechatService;
import me.johnniang.wechat.support.token.WechatToken;
import me.johnniang.wechat.support.user.WechatUser;
import me.johnniang.wechat.util.WechatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class DefaultWechatServiceImpl
implements WechatService {
    private static final Logger log = LoggerFactory.getLogger(DefaultWechatServiceImpl.class);
    private final WechatProperties wechatProperties;

    public DefaultWechatServiceImpl(WechatProperties wechatProperties) {
        this.wechatProperties = wechatProperties;
    }

    @Override
    public WechatToken getWechatToken() {
        Assert.hasText((String)this.wechatProperties.getAccessTokenUrl(), (String)"Wechat access token url must not be blank");
        Assert.hasText((String)this.wechatProperties.getAppId(), (String)"Wechat app id must not be blank");
        Assert.hasText((String)this.wechatProperties.getAppSecret(), (String)"Wechat app secret must not be blank");
        String accessTokenUrl = String.format(this.wechatProperties.getAccessTokenUrl(), "client_credential", this.wechatProperties.getAppId(), this.wechatProperties.getAppSecret());
        WechatToken wechatToken = WechatUtils.request(accessTokenUrl, "get", null, WechatToken.class);
        WechatUtils.shouldResponseSuccessfully(wechatToken);
        log.debug("Wechat token: [{}]", (Object)wechatToken);
        return wechatToken;
    }

    @Override
    public String getWechatTokenString() {
        return this.getWechatToken().getAccessToken();
    }

    @Override
    public boolean checkSignature(String signature, String timestamp, String nonce) {
        Assert.hasText((String)signature, (String)"Signature must not be blank");
        Assert.hasText((String)timestamp, (String)"Timestamp must not be blank");
        Assert.hasText((String)nonce, (String)"Nonce must not be blank");
        Assert.hasText((String)this.wechatProperties.getValidationToken(), (String)"Wechat validation token must not be blank");
        return WechatUtils.checkSignature(signature, timestamp, nonce, this.wechatProperties.getValidationToken());
    }

    @Override
    public WechatUser getWechatUser(String openid) {
        Assert.hasText((String)openid, (String)"Openid must not be blank");
        Assert.hasText((String)this.wechatProperties.getUserInfoUrl(), (String)"Wechat get user info url must not be blank");
        return this.getWechatUserBy(String.format(this.wechatProperties.getUserInfoUrl(), this.getWechatTokenString(), openid));
    }

    @Override
    public WechatUser getWechatUserViaSns(String openid, String oAuth2AccessToken) {
        Assert.hasText((String)openid, (String)"openid must not be blank");
        Assert.hasText((String)oAuth2AccessToken, (String)"OAuth2 access token must not be blank");
        Assert.hasText((String)this.wechatProperties.getSnsUserInfoUrl(), (String)"Wechat get user info via sns url must not be blank");
        return this.getWechatUserBy(String.format(this.wechatProperties.getSnsUserInfoUrl(), oAuth2AccessToken, openid));
    }

    private WechatUser getWechatUserBy(@NonNull String requestUserUrl) {
        Assert.hasText((String)requestUserUrl, (String)"Request user url must not be blank");
        WechatUser wechatUser = WechatUtils.request(requestUserUrl, "get", null, WechatUser.class);
        if (!WechatUtils.isResponseSuccessfully(wechatUser)) {
            throw new WechatException("Failed to get wechat user").setData(wechatUser);
        }
        log.debug("Got wechat user: [{}]", (Object)wechatUser);
        return wechatUser;
    }
}

