/*
 * Decompiled with CFR 0.152.
 */
package me.johnniang.wechat.support.message.handler;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.johnniang.wechat.support.message.WechatMessage;
import me.johnniang.wechat.support.message.handler.WechatMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class WechatMessageHandlerComposite
implements WechatMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(WechatMessageHandlerComposite.class);
    private final List<WechatMessageHandler> messageHandlers = new LinkedList<WechatMessageHandler>();
    private WechatMessageHandler postMessageHandler;
    private final Map<WechatMessage, WechatMessageHandler> messageHandlersCache = new ConcurrentHashMap<WechatMessage, WechatMessageHandler>(256);

    @Override
    public boolean supportsMessage(WechatMessage wechatMessage) {
        return this.getWechatMessageHandler(wechatMessage) != null;
    }

    @Override
    public WechatMessage handleMessage(WechatMessage wechatMessage) {
        WechatMessageHandler handler = this.getWechatMessageHandler(wechatMessage);
        WechatMessage passiveMessage = null;
        if (handler != null) {
            passiveMessage = handler.handleMessage(wechatMessage);
        } else {
            log.warn("Unsupported wechat message: [{}]", (Object)wechatMessage);
        }
        if (this.postMessageHandler != null && this.postMessageHandler.supportsMessage(wechatMessage)) {
            this.postMessageHandler.handleMessage(wechatMessage);
        }
        return passiveMessage;
    }

    public void setPostMessageHandler(WechatMessageHandler postMessageHandler) {
        this.postMessageHandler = postMessageHandler;
    }

    public WechatMessageHandler getPostMessageHandler() {
        return this.postMessageHandler;
    }

    public WechatMessageHandlerComposite addHandler(@NonNull WechatMessageHandler handler) {
        Assert.notNull((Object)handler, (String)"Wechat message handler must not be null");
        this.messageHandlers.add(handler);
        return this;
    }

    public WechatMessageHandlerComposite addHandlers(WechatMessageHandler ... handlers) {
        for (WechatMessageHandler handler : handlers) {
            this.addHandler(handler);
        }
        return this;
    }

    public WechatMessageHandlerComposite addHanlders(@NonNull Collection<? extends WechatMessageHandler> handlers) {
        if (!CollectionUtils.isEmpty(handlers)) {
            handlers.forEach(this::addHandler);
        }
        return this;
    }

    public List<WechatMessageHandler> getMessageHandlers() {
        return Collections.unmodifiableList(this.messageHandlers);
    }

    public void clear() {
        this.messageHandlersCache.clear();
        this.messageHandlers.clear();
    }

    private WechatMessageHandler getWechatMessageHandler(WechatMessage message) {
        Assert.notNull((Object)message, (String)"Wechat message must not be null");
        WechatMessageHandler cachedHandler = this.messageHandlersCache.get(message);
        if (cachedHandler == null) {
            log.debug("Getting new handler for wechat message");
            for (WechatMessageHandler handler : this.messageHandlers) {
                if (!handler.supportsMessage(message)) continue;
                cachedHandler = handler;
                this.messageHandlersCache.put(message, cachedHandler);
                break;
            }
        } else {
            log.debug("Got cached handler: [{}]", (Object)cachedHandler);
        }
        return cachedHandler;
    }
}

