/*
 * Decompiled with CFR 0.152.
 */
package me.johnniang.wechat.support.message.kefu;

import java.util.List;
import me.johnniang.wechat.support.message.WechatMessage;
import me.johnniang.wechat.support.message.kefu.Image;
import me.johnniang.wechat.support.message.kefu.KfMessage;
import me.johnniang.wechat.support.message.kefu.News;
import me.johnniang.wechat.support.message.kefu.Text;
import me.johnniang.wechat.support.message.kefu.Video;
import me.johnniang.wechat.support.message.kefu.Voice;
import me.johnniang.wechat.support.message.type.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class KfMessageBuilder {
    private static final Logger log = LoggerFactory.getLogger(KfMessageBuilder.class);

    private KfMessageBuilder() {
    }

    @NonNull
    public static KfMessage buildTextMessage(@NonNull String touser, @NonNull String content) {
        Assert.hasText((String)content, (String)"content must not be blank");
        KfMessage kfMessage = new KfMessage(touser, MessageType.text);
        Text text = new Text(content);
        kfMessage.setText(text);
        return kfMessage;
    }

    @NonNull
    public static KfMessage buildImageMessage(@NonNull String touser, @NonNull String mediaId) {
        Assert.hasText((String)mediaId, (String)"media id must not be blank");
        KfMessage kfMessage = new KfMessage(touser, MessageType.image);
        Image image = new Image(mediaId);
        kfMessage.setImage(image);
        return kfMessage;
    }

    @NonNull
    public static KfMessage buildVoiceMessage(@NonNull String touser, @NonNull String mediaId) {
        Assert.hasText((String)mediaId, (String)"media id must not be blank");
        KfMessage kfMessage = new KfMessage(touser, MessageType.voice);
        Voice voice = new Voice(mediaId);
        kfMessage.setVoice(voice);
        return kfMessage;
    }

    @NonNull
    public static KfMessage buildVideoMessage(@NonNull String touser, @NonNull String mediaId, @NonNull String thumbMediaId, String title, String description) {
        Assert.hasText((String)mediaId, (String)"media id must not be blank");
        Assert.hasText((String)thumbMediaId, (String)"Thumb media id must not be blank");
        KfMessage kfMessage = new KfMessage(touser, MessageType.video);
        kfMessage.setVideo(new Video(mediaId, thumbMediaId, title, description));
        return kfMessage;
    }

    @NonNull
    public static KfMessage buildNewsMessage(@NonNull String touser, @NonNull List<News.Article> articles) {
        Assert.hasText((String)touser, (String)"to user openid must not be empty");
        Assert.notEmpty(articles, (String)"articles must not be empty");
        KfMessage kfMessage = new KfMessage(touser, MessageType.news);
        News news = new News(articles);
        kfMessage.setNews(news);
        return kfMessage;
    }

    @Nullable
    public static KfMessage buildFromWechatMessage(@NonNull String touser, @NonNull WechatMessage wechatMessage) {
        KfMessage kfMessage;
        Assert.notNull((Object)wechatMessage, (String)"Wechat message must not be null");
        switch (wechatMessage.getMsgType()) {
            case text: {
                kfMessage = KfMessageBuilder.buildTextMessage(touser, wechatMessage.getContent());
                break;
            }
            case image: {
                kfMessage = KfMessageBuilder.buildImageMessage(touser, wechatMessage.getMediaId());
                break;
            }
            case voice: {
                kfMessage = KfMessageBuilder.buildVoiceMessage(touser, wechatMessage.getMediaId());
                break;
            }
            case video: {
                kfMessage = KfMessageBuilder.buildVideoMessage(touser, wechatMessage.getMediaId(), wechatMessage.getThumbMediaId(), wechatMessage.getTitle(), wechatMessage.getDescription());
                break;
            }
            default: {
                log.warn("Temporarily not support kf message building from wechat message which type is " + (Object)((Object)wechatMessage.getMsgType()));
                kfMessage = null;
            }
        }
        return kfMessage;
    }
}

