/*
 * Decompiled with CFR 0.152.
 */
package me.johnniang.wechat.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import me.johnniang.wechat.exception.RequestFailureException;
import me.johnniang.wechat.exception.ResponseFailureException;
import me.johnniang.wechat.util.JsonUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final int TIMEOUT = 5000;

    private HttpClientUtils() {
    }

    @NonNull
    public static HttpClient getHttpClient() {
        return HttpClientContainer.HTTP_CLIENT;
    }

    @NonNull
    public static HttpClient getHttpsClient() {
        return HttpClientContainer.HTTPS_CLIENT;
    }

    @NonNull
    public static HttpResponse requestViaHttp(@NonNull String requestUrl, @NonNull String method, @Nullable HttpEntity entity, NameValuePair ... params) throws IOException {
        return HttpClientUtils.requestForResponse(requestUrl, method, entity, HttpClientUtils.getHttpClient(), params);
    }

    @NonNull
    public static HttpResponse requestViaHttps(@NonNull String requestUrl, @NonNull String method, @Nullable HttpEntity entity, NameValuePair ... params) throws IOException {
        return HttpClientUtils.requestForResponse(requestUrl, method, entity, HttpClientUtils.getHttpsClient(), params);
    }

    @NonNull
    public static HttpResponse requestAutoForResponse(@NonNull String requestUrl, @NonNull String method, @Nullable HttpEntity entity, NameValuePair ... params) throws IOException {
        HttpClient client;
        String scheme = URI.create(requestUrl).getScheme();
        if (HTTPS.equals(scheme)) {
            client = HttpClientUtils.getHttpsClient();
        } else if (HTTP.equals(scheme)) {
            client = HttpClientUtils.getHttpClient();
        } else {
            log.error("Unsupported scheme: [{}], url: [{}]", (Object)scheme, (Object)requestUrl);
            throw new UnsupportedSchemeException("Unsupported scheme: " + scheme);
        }
        return HttpClientUtils.requestForResponse(requestUrl, method, entity, client, params);
    }

    @NonNull
    public static HttpResponse requestForResponse(@NonNull String requestUrl, @NonNull String method, @Nullable HttpEntity entity, @NonNull HttpClient httpClient, NameValuePair ... params) throws IOException {
        Assert.hasText((String)requestUrl, (String)"Request url must not be blank");
        Assert.hasText((String)method, (String)"Http method name must not be blank");
        Assert.notNull((Object)httpClient, (String)"Http client must not be null");
        RequestBuilder requestBuilder = RequestBuilder.create((String)method).setUri(requestUrl);
        if (params != null) {
            requestBuilder.addParameters(params);
        }
        requestBuilder.setEntity(entity);
        HttpUriRequest request = requestBuilder.build();
        return httpClient.execute(request);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <D, T> T request(@NonNull String requestUrl, @NonNull String method, @Nullable D data, @NonNull Class<T> responseType, @Nullable Charset charset, @NonNull ObjectMapper objectMapper, NameValuePair ... params) {
        T t;
        Assert.notNull((Object)objectMapper, (String)"Object mapper must not be null");
        HttpResponse response = null;
        try {
            StringEntity stringEntity = null;
            if (HttpClientUtils.isNeedConvert(data)) {
                stringEntity = new StringEntity(objectMapper.writeValueAsString(data), charset);
            } else if (data != null) {
                stringEntity = new StringEntity(data.toString(), charset);
            }
            response = HttpClientUtils.requestAutoForResponse(requestUrl, method, stringEntity, params);
            HttpClientUtils.shouldResponseSuccessfully(response);
            log.debug("Response status: [{}]", (Object)response);
            t = HttpClientUtils.convertResponse(response.getEntity(), responseType, charset, objectMapper);
        }
        catch (JsonProcessingException e) {
            try {
                throw new RequestFailureException("Failed to parse object to xml or json or failed to parse xml or json to object", e).setRequestUrl(requestUrl).setMethod(method);
                catch (UnsupportedEncodingException e2) {
                    throw new RequestFailureException("Unsupported encoding", e2).setRequestUrl(requestUrl).setMethod(method);
                }
                catch (IOException e3) {
                    throw new RequestFailureException("Failed to request " + requestUrl, e3).setRequestUrl(requestUrl).setMethod(method);
                }
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly(response);
        return t;
    }

    @NonNull
    public static List<NameValuePair> convertToNvpParams(@NonNull Object paramObject) throws IOException {
        Map<?, ?> paramMap = JsonUtils.objectToMap(paramObject);
        LinkedList<NameValuePair> nvpParams = new LinkedList<NameValuePair>();
        paramMap.forEach((key, value) -> nvpParams.add((NameValuePair)new BasicNameValuePair(key.toString(), value.toString())));
        return nvpParams;
    }

    @Nullable
    public static <T> T postFormData(@NonNull String requestUrl, @NonNull HttpEntity multipartEntity, @NonNull Class<T> responseType, @Nullable Charset responseCharset, @NonNull ObjectMapper objectMapper) {
        T t;
        Assert.notNull((Object)multipartEntity, (String)"Multipart http entity must not be null");
        String method = "post";
        HttpResponse response = null;
        try {
            response = HttpClientUtils.requestAutoForResponse(requestUrl, method, multipartEntity, new NameValuePair[0]);
            HttpClientUtils.shouldResponseSuccessfully(response);
            log.debug("Response status: [{}]", (Object)response);
            t = HttpClientUtils.convertResponse(response.getEntity(), responseType, responseCharset, objectMapper);
        }
        catch (IOException e) {
            try {
                throw new RequestFailureException("Faile to request " + requestUrl, e).setRequestUrl(requestUrl).setMethod(method);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly(response);
        return t;
    }

    private static boolean isNeedConvert(@Nullable Object data) {
        if (data == null) {
            return false;
        }
        return HttpClientUtils.isNeedConvert(data.getClass());
    }

    private static boolean isNeedConvert(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Clazz type must not be null");
        boolean ignorable = clazz.isPrimitive() || ClassUtils.isPrimitiveArray(clazz) || ClassUtils.isPrimitiveWrapper(clazz) || ClassUtils.isPrimitiveWrapperArray(clazz) || clazz.equals(String.class);
        return !ignorable;
    }

    private static void shouldResponseSuccessfully(@NonNull HttpResponse response) {
        Assert.notNull((Object)response, (String)"Http response must not be null");
        if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
            throw new ResponseFailureException("Failed to response").setResponse(response);
        }
    }

    @Nullable
    private static <T> T convertResponse(@NonNull HttpEntity httpEntity, @NonNull Class<T> responseType, @Nullable Charset responseCharset, @NonNull ObjectMapper objectMapper) throws IOException {
        Assert.notNull((Object)httpEntity, (String)"Http entity must not be null");
        Assert.notNull(responseType, (String)"Response type must not be null");
        Assert.notNull((Object)objectMapper, (String)"Object mapper must not be null");
        if (byte[].class.isAssignableFrom(responseType)) {
            return (T)IOUtils.toByteArray((InputStream)httpEntity.getContent());
        }
        String responseContent = EntityUtils.toString((HttpEntity)httpEntity, (Charset)responseCharset);
        if (String.class.isAssignableFrom(responseType)) {
            return (T)responseContent;
        }
        if (StringUtils.isNotBlank((CharSequence)responseContent)) {
            return (T)objectMapper.readValue(responseContent, responseType);
        }
        return null;
    }

    public static void closeQuietly(@Nullable HttpResponse response) {
        if (response instanceof CloseableHttpResponse) {
            try {
                ((CloseableHttpResponse)response).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class HttpClientContainer {
        private static final CloseableHttpClient HTTP_CLIENT = HttpClientContainer.createHttpClient();
        private static final CloseableHttpClient HTTPS_CLIENT;

        private HttpClientContainer() {
        }

        @NonNull
        public static CloseableHttpClient createHttpClient() {
            return HttpClients.custom().setDefaultRequestConfig(HttpClientContainer.getReqeustConfig()).build();
        }

        @NonNull
        public static CloseableHttpClient createHttpsClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build();
            return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setDefaultRequestConfig(HttpClientContainer.getReqeustConfig()).build();
        }

        private static RequestConfig getReqeustConfig() {
            return RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        }

        static {
            try {
                HTTPS_CLIENT = HttpClientContainer.createHttpsClient();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to create https client", e);
            }
        }
    }
}

