/*
 * Decompiled with CFR 0.152.
 */
package me.johnniang.wechat.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JsonUtils {
    public static final ObjectMapper DEFAULT_JSON_MAPPER = JsonUtils.createDefaultJsonMapper();

    private JsonUtils() {
    }

    public static ObjectMapper createDefaultJsonMapper() {
        return JsonUtils.createDefaultJsonMapper(null);
    }

    @NonNull
    public static ObjectMapper createDefaultJsonMapper(@Nullable PropertyNamingStrategy strategy) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (strategy != null) {
            mapper.setPropertyNamingStrategy(strategy);
        }
        return mapper;
    }

    @NonNull
    public static <T> T jsonToObject(@NonNull String json, @NonNull Class<T> type) throws IOException {
        return JsonUtils.jsonToObject(json, type, DEFAULT_JSON_MAPPER);
    }

    @NonNull
    public static <T> T jsonToObject(@NonNull String json, @NonNull Class<T> type, @NonNull ObjectMapper objectMapper) throws IOException {
        Assert.hasText((String)json, (String)"Json content must not be blank");
        Assert.notNull(type, (String)"Target type must not be null");
        Assert.notNull((Object)objectMapper, (String)"Object mapper must not null");
        return (T)objectMapper.readValue(json, type);
    }

    @NonNull
    public static <T> T inputStreamToObject(@NonNull InputStream inputStream, @NonNull Class<T> type) throws IOException {
        return JsonUtils.inputStreamToObject(inputStream, type, null);
    }

    @NonNull
    public static <T> T inputStreamToObject(@NonNull InputStream inputStream, @NonNull Class<T> type, @NonNull ObjectMapper objectMapper) throws IOException {
        Assert.notNull((Object)inputStream, (String)"Input stream must not be null");
        String json = IOUtils.toString((InputStream)inputStream);
        return JsonUtils.jsonToObject(json, type, objectMapper);
    }

    @NonNull
    public static String objectToJson(@NonNull Object source) throws JsonProcessingException {
        return JsonUtils.objectToJson(source, DEFAULT_JSON_MAPPER);
    }

    @NonNull
    public static String objectToJson(@NonNull Object source, @NonNull ObjectMapper objectMapper) throws JsonProcessingException {
        Assert.notNull((Object)source, (String)"Source object must not be null");
        Assert.notNull((Object)objectMapper, (String)"Object mapper must not null");
        return objectMapper.writeValueAsString(source);
    }

    @NonNull
    public static <T> T mapToObject(@NonNull Map<String, ?> sourceMap, @NonNull Class<T> type) throws IOException {
        return JsonUtils.mapToObject(sourceMap, type, DEFAULT_JSON_MAPPER);
    }

    @NonNull
    public static <T> T mapToObject(@NonNull Map<String, ?> sourceMap, @NonNull Class<T> type, @NonNull ObjectMapper objectMapper) throws IOException {
        Assert.notEmpty(sourceMap, (String)"Source map must not be empty");
        String json = JsonUtils.objectToJson(sourceMap, objectMapper);
        return JsonUtils.jsonToObject(json, type, objectMapper);
    }

    @NonNull
    public static Map<?, ?> objectToMap(@NonNull Object source) throws IOException {
        return JsonUtils.objectToMap(source, DEFAULT_JSON_MAPPER);
    }

    @NonNull
    public static Map<?, ?> objectToMap(@NonNull Object source, @NonNull ObjectMapper objectMapper) throws IOException {
        String json = JsonUtils.objectToJson(source, objectMapper);
        return JsonUtils.jsonToObject(json, Map.class, objectMapper);
    }
}

