/*
 * Decompiled with CFR 0.152.
 */
package me.johnniang.wechat.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import me.johnniang.wechat.exception.WechatException;
import me.johnniang.wechat.support.WechatBaseResponse;
import me.johnniang.wechat.support.WechatConstant;
import me.johnniang.wechat.util.HttpClientUtils;
import me.johnniang.wechat.util.JsonUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class WechatUtils {
    private static final Logger log = LoggerFactory.getLogger(WechatUtils.class);

    private WechatUtils() {
    }

    @Nullable
    public static <D, T> T request(@NonNull String requestUrl, @NonNull String method, @Nullable D data, @NonNull Class<T> responseType) {
        return HttpClientUtils.request(requestUrl, method, data, responseType, WechatConstant.WECHAT_CHARSET, JsonUtils.DEFAULT_JSON_MAPPER, new NameValuePair[0]);
    }

    @Nullable
    public static <D, T> T request(@NonNull String requestUrl, @NonNull String method, @Nullable D data, @NonNull Class<T> responseType, @NonNull ObjectMapper objectMapper) {
        return HttpClientUtils.request(requestUrl, method, data, responseType, WechatConstant.WECHAT_CHARSET, objectMapper, new NameValuePair[0]);
    }

    public static boolean isResponseSuccessfully(@NonNull WechatBaseResponse baseResponse) {
        Assert.notNull((Object)baseResponse, (String)"Base response must not be null");
        return baseResponse.getErrcode() == 0;
    }

    public static void shouldResponseSuccessfully(@NonNull WechatBaseResponse baseResponse) {
        Assert.notNull((Object)baseResponse, (String)"Base response must not be null");
        if (baseResponse.getErrcode() != 0) {
            log.error("Wechat response error: [{}]", (Object)baseResponse.printErrorDetail());
            throw new WechatException("Wechat response error").setData(baseResponse);
        }
    }

    public static long getCurrentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getRandomString(int length) {
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    public static boolean checkSignature(@NonNull String signature, String ... datas) {
        Assert.hasText((String)signature, (String)"signature must not be blank");
        Assert.notEmpty((Object[])datas, (String)"To check data must not be empty");
        Arrays.sort(datas);
        StringBuilder stringBuilder = new StringBuilder();
        for (String data : datas) {
            stringBuilder.append(data);
        }
        String sha1Hex = DigestUtils.sha1Hex((String)stringBuilder.toString());
        boolean matched = signature.equalsIgnoreCase(sha1Hex);
        if (!matched) {
            log.warn("Signature: [{}] is mismatch, actual signature: [{}]", (Object)signature, (Object)sha1Hex);
        } else {
            log.debug("Signature: [{}] is match the sha1hex: [{}]", (Object)signature, (Object)sha1Hex);
        }
        return matched;
    }

    @NonNull
    public static String getSha1Sign(SortedMap<String, Object> sortedMap, String ... ignoreKeys) {
        Assert.notNull(sortedMap, (String)"To be signed map must not be null");
        List<String> ignoreKeyList = Arrays.asList(ignoreKeys);
        StringBuffer stringBuffer = new StringBuffer();
        sortedMap.forEach((key, value) -> {
            if (!ignoreKeyList.contains(key)) {
                stringBuffer.append((String)key).append("=").append(value).append('&');
            }
        });
        String toBeSignedString = stringBuffer.toString();
        toBeSignedString = StringUtils.removeEnd((String)toBeSignedString, (String)"&");
        log.debug("Before signing string: [{}]", (Object)toBeSignedString);
        String signature = DigestUtils.sha1Hex((String)toBeSignedString);
        log.debug("Signature of sha1: [{}]", (Object)signature);
        return signature;
    }

    @NonNull
    public static String getMD5SignWithKey(SortedMap<?, ?> map, @NonNull String key) {
        List<String> ignoreKeys = Arrays.asList("sign", "key");
        return WechatUtils.getMD5SignWithKey(map, key, ignoreKeys);
    }

    @NonNull
    public static String getMD5SignWithKey(@NonNull Map<?, ?> map, @NonNull String key, @Nullable List<?> ignoreKeys) {
        Assert.notEmpty(map, (String)"Map to calculate must not be empty");
        Assert.hasText((String)key, (String)"Key to calculate must not be blank");
        StringBuffer stringBuffer = new StringBuffer();
        map.forEach((mapKey, mapValue) -> {
            if (!(null == mapValue || ignoreKeys != null && ignoreKeys.contains(mapKey))) {
                stringBuffer.append(mapKey).append('=').append(mapValue).append('&');
            }
        });
        stringBuffer.append("key=").append(key);
        log.debug("Signing string: [{}]", (Object)stringBuffer.toString());
        String result = DigestUtils.md5Hex((String)stringBuffer.toString());
        log.debug("Signed result: [{}] for string: [{}]", (Object)result, (Object)stringBuffer.toString());
        return result;
    }

    @NonNull
    public static String getMD5SignWithKey(@NonNull Object data, @NonNull String key, @NonNull ObjectMapper objectMapper) {
        SortedMap<?, ?> sortedMap = WechatUtils.convertToSortedMap(data, objectMapper);
        return WechatUtils.getMD5SignWithKey(sortedMap, key);
    }

    @NonNull
    private static SortedMap<?, ?> convertToSortedMap(@NonNull Object data, @NonNull ObjectMapper objectMapper) {
        try {
            String dataJson = JsonUtils.objectToJson(data, objectMapper);
            return JsonUtils.jsonToObject(dataJson, TreeMap.class);
        }
        catch (IOException e) {
            throw new WechatException("Object to map processing error", e).setData(data);
        }
    }
}

