/*
 * Decompiled with CFR 0.152.
 */
package me.johnniang.wechat.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import me.johnniang.wechat.util.JsonUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class XmlUtils {
    public static final XmlMapper DEFAULT_XML_MAPPER = XmlUtils.createDefaultXmlMapper();

    private XmlUtils() {
    }

    public static XmlMapper createDefaultXmlMapper() {
        return XmlUtils.createDefaultXmlMapper(null);
    }

    public static XmlMapper createDefaultXmlMapper(@Nullable PropertyNamingStrategy strategy) {
        XmlMapper mapper = new XmlMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        if (strategy != null) {
            mapper.setPropertyNamingStrategy(strategy);
        }
        return mapper;
    }

    @NonNull
    public static <T> T xmlToObject(@NonNull String xml, @NonNull Class<T> type) throws IOException {
        return XmlUtils.xmlToObject(xml, type, DEFAULT_XML_MAPPER);
    }

    @NonNull
    public static <T> T xmlToObject(@NonNull String xml, @NonNull Class<T> type, @NonNull XmlMapper xmlMapper) throws IOException {
        return JsonUtils.jsonToObject(xml, type, (ObjectMapper)xmlMapper);
    }

    @NonNull
    public static <T> T inputStreamToObject(@NonNull InputStream inputStream, @NonNull Class<T> type) throws IOException {
        return XmlUtils.inputStreamToObject(inputStream, type, DEFAULT_XML_MAPPER);
    }

    @NonNull
    public static <T> T inputStreamToObject(@NonNull InputStream inputStream, @NonNull Class<T> type, @NonNull XmlMapper xmlMapper) throws IOException {
        return JsonUtils.inputStreamToObject(inputStream, type, (ObjectMapper)xmlMapper);
    }

    @NonNull
    public static String objectToXml(@NonNull Object source) throws JsonProcessingException {
        return XmlUtils.objectToXml(source, DEFAULT_XML_MAPPER);
    }

    @NonNull
    public static String objectToXml(@NonNull Object source, @NonNull XmlMapper xmlMapper) throws JsonProcessingException {
        return JsonUtils.objectToJson(source, (ObjectMapper)xmlMapper);
    }

    @NonNull
    public static <T> T mapToObject(@NonNull Map<String, ?> sourceMap, @NonNull Class<T> type) throws IOException {
        return XmlUtils.mapToObject(sourceMap, type, DEFAULT_XML_MAPPER);
    }

    @NonNull
    public static <T> T mapToObject(@NonNull Map<String, ?> sourceMap, @NonNull Class<T> type, @NonNull XmlMapper xmlMapper) throws IOException {
        return JsonUtils.mapToObject(sourceMap, type, (ObjectMapper)xmlMapper);
    }

    @NonNull
    public static Map<?, ?> objectToMap(@NonNull Object source, @NonNull XmlMapper xmlMapper) throws IOException {
        return JsonUtils.objectToMap(source, (ObjectMapper)xmlMapper);
    }
}

