/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.account.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.account.data.db.AccountConverters;
import me.proton.core.account.data.db.SessionDetailsDao;
import me.proton.core.account.data.entity.SessionDetailsEntity;
import me.proton.core.account.domain.entity.AccountType;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.network.domain.session.SessionId;

public final class SessionDetailsDao_Impl
extends SessionDetailsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<SessionDetailsEntity> __insertionAdapterOfSessionDetailsEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final AccountConverters __accountConverters = new AccountConverters();
    private final EntityDeletionOrUpdateAdapter<SessionDetailsEntity> __deletionAdapterOfSessionDetailsEntity;
    private final EntityDeletionOrUpdateAdapter<SessionDetailsEntity> __updateAdapterOfSessionDetailsEntity;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfClearPassword;

    public SessionDetailsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSessionDetailsEntity = new EntityInsertionAdapter<SessionDetailsEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `SessionDetailsEntity` (`sessionId`,`initialEventId`,`requiredAccountType`,`secondFactorEnabled`,`twoPassModeEnabled`,`password`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, SessionDetailsEntity value) {
                String _tmp = SessionDetailsDao_Impl.this.__commonConverters.fromSessionIdToString(value.getSessionId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getInitialEventId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getInitialEventId());
                }
                String _tmp_1 = SessionDetailsDao_Impl.this.__accountConverters.fromAccountTypeToString(value.getRequiredAccountType());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                int _tmp_2 = value.getSecondFactorEnabled() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp_2);
                int _tmp_3 = value.getTwoPassModeEnabled() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_3);
                if (value.getPassword() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPassword());
                }
            }
        };
        this.__deletionAdapterOfSessionDetailsEntity = new EntityDeletionOrUpdateAdapter<SessionDetailsEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `SessionDetailsEntity` WHERE `sessionId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, SessionDetailsEntity value) {
                String _tmp = SessionDetailsDao_Impl.this.__commonConverters.fromSessionIdToString(value.getSessionId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfSessionDetailsEntity = new EntityDeletionOrUpdateAdapter<SessionDetailsEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `SessionDetailsEntity` SET `sessionId` = ?,`initialEventId` = ?,`requiredAccountType` = ?,`secondFactorEnabled` = ?,`twoPassModeEnabled` = ?,`password` = ? WHERE `sessionId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, SessionDetailsEntity value) {
                String _tmp = SessionDetailsDao_Impl.this.__commonConverters.fromSessionIdToString(value.getSessionId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getInitialEventId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getInitialEventId());
                }
                String _tmp_1 = SessionDetailsDao_Impl.this.__accountConverters.fromAccountTypeToString(value.getRequiredAccountType());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                int _tmp_2 = value.getSecondFactorEnabled() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp_2);
                int _tmp_3 = value.getTwoPassModeEnabled() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_3);
                if (value.getPassword() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPassword());
                }
                String _tmp_4 = SessionDetailsDao_Impl.this.__commonConverters.fromSessionIdToString(value.getSessionId());
                if (_tmp_4 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_4);
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM SessionDetailsEntity WHERE sessionId = ?";
                return "DELETE FROM SessionDetailsEntity WHERE sessionId = ?";
            }
        };
        this.__preparedStmtOfClearPassword = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE SessionDetailsEntity SET password = null WHERE sessionId = ?";
                return "UPDATE SessionDetailsEntity SET password = null WHERE sessionId = ?";
            }
        };
    }

    public Object insertOrIgnore(final SessionDetailsEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SessionDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    SessionDetailsDao_Impl.this.__insertionAdapterOfSessionDetailsEntity.insert((Object[])entities);
                    SessionDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SessionDetailsDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final SessionDetailsEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SessionDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    SessionDetailsDao_Impl.this.__deletionAdapterOfSessionDetailsEntity.handleMultiple((Object[])entities);
                    SessionDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SessionDetailsDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final SessionDetailsEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                SessionDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    SessionDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += SessionDetailsDao_Impl.this.__updateAdapterOfSessionDetailsEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    SessionDetailsDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final SessionDetailsEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return SessionDetailsDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object delete(final SessionId sessionId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = SessionDetailsDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                String _tmp = SessionDetailsDao_Impl.this.__commonConverters.fromSessionIdToString(sessionId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                SessionDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    SessionDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SessionDetailsDao_Impl.this.__db.endTransaction();
                    SessionDetailsDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object clearPassword(final SessionId sessionId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = SessionDetailsDao_Impl.this.__preparedStmtOfClearPassword.acquire();
                int _argIndex = 1;
                String _tmp = SessionDetailsDao_Impl.this.__commonConverters.fromSessionIdToString(sessionId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                SessionDetailsDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    SessionDetailsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    SessionDetailsDao_Impl.this.__db.endTransaction();
                    SessionDetailsDao_Impl.this.__preparedStmtOfClearPassword.release(_stmt);
                }
            }
        }, arg1);
    }

    public Flow<SessionDetailsEntity> findBySessionId(SessionId sessionId) {
        String _sql = "SELECT * FROM SessionDetailsEntity WHERE sessionId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SessionDetailsEntity WHERE sessionId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"SessionDetailsEntity"}, (Callable)new Callable<SessionDetailsEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SessionDetailsEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SessionDetailsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    SessionDetailsEntity _result;
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfInitialEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initialEventId");
                    int _cursorIndexOfRequiredAccountType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requiredAccountType");
                    int _cursorIndexOfSecondFactorEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"secondFactorEnabled");
                    int _cursorIndexOfTwoPassModeEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"twoPassModeEnabled");
                    int _cursorIndexOfPassword = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"password");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        SessionId _tmpSessionId = SessionDetailsDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_1);
                        String _tmpInitialEventId = _cursor.isNull(_cursorIndexOfInitialEventId) ? null : _cursor.getString(_cursorIndexOfInitialEventId);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfRequiredAccountType) ? null : _cursor.getString(_cursorIndexOfRequiredAccountType);
                        AccountType _tmpRequiredAccountType = SessionDetailsDao_Impl.this.__accountConverters.fromStringToAccountType(_tmp_2);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfSecondFactorEnabled);
                        boolean _tmpSecondFactorEnabled = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfTwoPassModeEnabled);
                        boolean _tmpTwoPassModeEnabled = _tmp_4 != 0;
                        String _tmpPassword = _cursor.isNull(_cursorIndexOfPassword) ? null : _cursor.getString(_cursorIndexOfPassword);
                        _result = new SessionDetailsEntity(_tmpSessionId, _tmpInitialEventId, _tmpRequiredAccountType, _tmpSecondFactorEnabled, _tmpTwoPassModeEnabled, _tmpPassword);
                    } else {
                        _result = null;
                    }
                    SessionDetailsEntity sessionDetailsEntity = _result;
                    return sessionDetailsEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getBySessionId(SessionId sessionId, Continuation<? super SessionDetailsEntity> arg1) {
        String _sql = "SELECT * FROM SessionDetailsEntity WHERE sessionId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SessionDetailsEntity WHERE sessionId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromSessionIdToString(sessionId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<SessionDetailsEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SessionDetailsEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)SessionDetailsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    SessionDetailsEntity _result;
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfInitialEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"initialEventId");
                    int _cursorIndexOfRequiredAccountType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requiredAccountType");
                    int _cursorIndexOfSecondFactorEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"secondFactorEnabled");
                    int _cursorIndexOfTwoPassModeEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"twoPassModeEnabled");
                    int _cursorIndexOfPassword = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"password");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        SessionId _tmpSessionId = SessionDetailsDao_Impl.this.__commonConverters.fromStringToSessionId(_tmp_1);
                        String _tmpInitialEventId = _cursor.isNull(_cursorIndexOfInitialEventId) ? null : _cursor.getString(_cursorIndexOfInitialEventId);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfRequiredAccountType) ? null : _cursor.getString(_cursorIndexOfRequiredAccountType);
                        AccountType _tmpRequiredAccountType = SessionDetailsDao_Impl.this.__accountConverters.fromStringToAccountType(_tmp_2);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfSecondFactorEnabled);
                        boolean _tmpSecondFactorEnabled = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfTwoPassModeEnabled);
                        boolean _tmpTwoPassModeEnabled = _tmp_4 != 0;
                        String _tmpPassword = _cursor.isNull(_cursorIndexOfPassword) ? null : _cursor.getString(_cursorIndexOfPassword);
                        _result = new SessionDetailsEntity(_tmpSessionId, _tmpInitialEventId, _tmpRequiredAccountType, _tmpSecondFactorEnabled, _tmpTwoPassModeEnabled, _tmpPassword);
                    } else {
                        _result = null;
                    }
                    SessionDetailsEntity sessionDetailsEntity = _result;
                    return sessionDetailsEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

