/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.key.data.db;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.key.data.db.PublicAddressKeyDao;
import me.proton.core.key.data.entity.PublicAddressKeyEntity;

public final class PublicAddressKeyDao_Impl
extends PublicAddressKeyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PublicAddressKeyEntity> __insertionAdapterOfPublicAddressKeyEntity;
    private final EntityDeletionOrUpdateAdapter<PublicAddressKeyEntity> __deletionAdapterOfPublicAddressKeyEntity;
    private final EntityDeletionOrUpdateAdapter<PublicAddressKeyEntity> __updateAdapterOfPublicAddressKeyEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByEmail;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public PublicAddressKeyDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPublicAddressKeyEntity = new EntityInsertionAdapter<PublicAddressKeyEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `PublicAddressKeyEntity` (`email`,`flags`,`publicKey`,`isPrimary`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, PublicAddressKeyEntity value) {
                if (value.getEmail() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEmail());
                }
                stmt.bindLong(2, (long)value.getFlags());
                if (value.getPublicKey() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPublicKey());
                }
                int _tmp = value.isPrimary() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
            }
        };
        this.__deletionAdapterOfPublicAddressKeyEntity = new EntityDeletionOrUpdateAdapter<PublicAddressKeyEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `PublicAddressKeyEntity` WHERE `email` = ? AND `publicKey` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PublicAddressKeyEntity value) {
                if (value.getEmail() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEmail());
                }
                if (value.getPublicKey() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPublicKey());
                }
            }
        };
        this.__updateAdapterOfPublicAddressKeyEntity = new EntityDeletionOrUpdateAdapter<PublicAddressKeyEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `PublicAddressKeyEntity` SET `email` = ?,`flags` = ?,`publicKey` = ?,`isPrimary` = ? WHERE `email` = ? AND `publicKey` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PublicAddressKeyEntity value) {
                if (value.getEmail() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEmail());
                }
                stmt.bindLong(2, (long)value.getFlags());
                if (value.getPublicKey() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getPublicKey());
                }
                int _tmp = value.isPrimary() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                if (value.getEmail() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getEmail());
                }
                if (value.getPublicKey() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPublicKey());
                }
            }
        };
        this.__preparedStmtOfDeleteByEmail = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM PublicAddressKeyEntity WHERE email = ?";
                return "DELETE FROM PublicAddressKeyEntity WHERE email = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM PublicAddressKeyEntity";
                return "DELETE FROM PublicAddressKeyEntity";
            }
        };
    }

    public Object insertOrIgnore(final PublicAddressKeyEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                PublicAddressKeyDao_Impl.this.__db.beginTransaction();
                try {
                    PublicAddressKeyDao_Impl.this.__insertionAdapterOfPublicAddressKeyEntity.insert((Object[])entities);
                    PublicAddressKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PublicAddressKeyDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final PublicAddressKeyEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                PublicAddressKeyDao_Impl.this.__db.beginTransaction();
                try {
                    PublicAddressKeyDao_Impl.this.__deletionAdapterOfPublicAddressKeyEntity.handleMultiple((Object[])entities);
                    PublicAddressKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PublicAddressKeyDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final PublicAddressKeyEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                PublicAddressKeyDao_Impl.this.__db.beginTransaction();
                try {
                    PublicAddressKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += PublicAddressKeyDao_Impl.this.__updateAdapterOfPublicAddressKeyEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    PublicAddressKeyDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final PublicAddressKeyEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return PublicAddressKeyDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object deleteByEmail(final String email, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PublicAddressKeyDao_Impl.this.__preparedStmtOfDeleteByEmail.acquire();
                int _argIndex = 1;
                if (email == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, email);
                }
                PublicAddressKeyDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PublicAddressKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PublicAddressKeyDao_Impl.this.__db.endTransaction();
                    PublicAddressKeyDao_Impl.this.__preparedStmtOfDeleteByEmail.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object deleteAll(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = PublicAddressKeyDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                PublicAddressKeyDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PublicAddressKeyDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    PublicAddressKeyDao_Impl.this.__db.endTransaction();
                    PublicAddressKeyDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, arg0);
    }

    public Flow<List<PublicAddressKeyEntity>> findAllByEmail(String email) {
        String _sql = "SELECT * FROM PublicAddressKeyEntity WHERE email = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PublicAddressKeyEntity WHERE email = ?", (int)1);
        int _argIndex = 1;
        if (email == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, email);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"PublicAddressKeyEntity"}, (Callable)new Callable<List<PublicAddressKeyEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PublicAddressKeyEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PublicAddressKeyDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flags");
                    int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"publicKey");
                    int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPrimary");
                    ArrayList<PublicAddressKeyEntity> _result = new ArrayList<PublicAddressKeyEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        int _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
                        String _tmpPublicKey = _cursor.isNull(_cursorIndexOfPublicKey) ? null : _cursor.getString(_cursorIndexOfPublicKey);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsPrimary);
                        boolean _tmpIsPrimary = _tmp != 0;
                        PublicAddressKeyEntity _item = new PublicAddressKeyEntity(_tmpEmail, _tmpFlags, _tmpPublicKey, _tmpIsPrimary);
                        _result.add(_item);
                    }
                    ArrayList<PublicAddressKeyEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

