/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.key.data.entity.SignedKeyListEntity;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.data.db.dao.AddressDao;
import me.proton.core.user.data.entity.AddressEntity;
import me.proton.core.user.domain.entity.AddressId;

public final class AddressDao_Impl
extends AddressDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AddressEntity> __insertionAdapterOfAddressEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final UserConverters __userConverters = new UserConverters();
    private final EntityDeletionOrUpdateAdapter<AddressEntity> __deletionAdapterOfAddressEntity;
    private final EntityDeletionOrUpdateAdapter<AddressEntity> __updateAdapterOfAddressEntity;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll_1;

    public AddressDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAddressEntity = new EntityInsertionAdapter<AddressEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `AddressEntity` (`userId`,`addressId`,`email`,`displayName`,`signature`,`domainId`,`canSend`,`canReceive`,`enabled`,`type`,`order`,`signedKeyList_data`,`signedKeyList_signature`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
                String _tmp = AddressDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = AddressDao_Impl.this.__userConverters.fromAddressIdToString(value.getAddressId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getEmail());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getSignature() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSignature());
                }
                if (value.getDomainId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getDomainId());
                }
                int _tmp_2 = value.getCanSend() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_2);
                int _tmp_3 = value.getCanReceive() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_3);
                int _tmp_4 = value.getEnabled() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_4);
                if (value.getType() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)value.getType().intValue());
                }
                stmt.bindLong(11, (long)value.getOrder());
                SignedKeyListEntity _tmpSignedKeyList = value.getSignedKeyList();
                if (_tmpSignedKeyList != null) {
                    if (_tmpSignedKeyList.getData() == null) {
                        stmt.bindNull(12);
                    } else {
                        stmt.bindString(12, _tmpSignedKeyList.getData());
                    }
                    if (_tmpSignedKeyList.getSignature() == null) {
                        stmt.bindNull(13);
                    } else {
                        stmt.bindString(13, _tmpSignedKeyList.getSignature());
                    }
                } else {
                    stmt.bindNull(12);
                    stmt.bindNull(13);
                }
            }
        };
        this.__deletionAdapterOfAddressEntity = new EntityDeletionOrUpdateAdapter<AddressEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `AddressEntity` WHERE `addressId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
                String _tmp = AddressDao_Impl.this.__userConverters.fromAddressIdToString(value.getAddressId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfAddressEntity = new EntityDeletionOrUpdateAdapter<AddressEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `AddressEntity` SET `userId` = ?,`addressId` = ?,`email` = ?,`displayName` = ?,`signature` = ?,`domainId` = ?,`canSend` = ?,`canReceive` = ?,`enabled` = ?,`type` = ?,`order` = ?,`signedKeyList_data` = ?,`signedKeyList_signature` = ? WHERE `addressId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
                String _tmp = AddressDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = AddressDao_Impl.this.__userConverters.fromAddressIdToString(value.getAddressId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getEmail());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getSignature() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSignature());
                }
                if (value.getDomainId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getDomainId());
                }
                int _tmp_2 = value.getCanSend() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_2);
                int _tmp_3 = value.getCanReceive() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_3);
                int _tmp_4 = value.getEnabled() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_4);
                if (value.getType() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)value.getType().intValue());
                }
                stmt.bindLong(11, (long)value.getOrder());
                SignedKeyListEntity _tmpSignedKeyList = value.getSignedKeyList();
                if (_tmpSignedKeyList != null) {
                    if (_tmpSignedKeyList.getData() == null) {
                        stmt.bindNull(12);
                    } else {
                        stmt.bindString(12, _tmpSignedKeyList.getData());
                    }
                    if (_tmpSignedKeyList.getSignature() == null) {
                        stmt.bindNull(13);
                    } else {
                        stmt.bindString(13, _tmpSignedKeyList.getSignature());
                    }
                } else {
                    stmt.bindNull(12);
                    stmt.bindNull(13);
                }
                String _tmp_5 = AddressDao_Impl.this.__userConverters.fromAddressIdToString(value.getAddressId());
                if (_tmp_5 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_5);
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM AddressEntity WHERE addressId = ?";
                return "DELETE FROM AddressEntity WHERE addressId = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM AddressEntity WHERE userId = ?";
                return "DELETE FROM AddressEntity WHERE userId = ?";
            }
        };
        this.__preparedStmtOfDeleteAll_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM AddressEntity";
                return "DELETE FROM AddressEntity";
            }
        };
    }

    public Object insertOrIgnore(final AddressEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AddressDao_Impl.this.__db.beginTransaction();
                try {
                    AddressDao_Impl.this.__insertionAdapterOfAddressEntity.insert((Object[])entities);
                    AddressDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AddressDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final AddressEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AddressDao_Impl.this.__db.beginTransaction();
                try {
                    AddressDao_Impl.this.__deletionAdapterOfAddressEntity.handleMultiple((Object[])entities);
                    AddressDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AddressDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final AddressEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                AddressDao_Impl.this.__db.beginTransaction();
                try {
                    AddressDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += AddressDao_Impl.this.__updateAdapterOfAddressEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    AddressDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final AddressEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return AddressDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object delete(final AddressId addressId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AddressDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                String _tmp = AddressDao_Impl.this.__userConverters.fromAddressIdToString(addressId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                AddressDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AddressDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AddressDao_Impl.this.__db.endTransaction();
                    AddressDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object deleteAll(final UserId userId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AddressDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                int _argIndex = 1;
                String _tmp = AddressDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                AddressDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AddressDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AddressDao_Impl.this.__db.endTransaction();
                    AddressDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object deleteAll(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AddressDao_Impl.this.__preparedStmtOfDeleteAll_1.acquire();
                AddressDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AddressDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AddressDao_Impl.this.__db.endTransaction();
                    AddressDao_Impl.this.__preparedStmtOfDeleteAll_1.release(_stmt);
                }
            }
        }, arg0);
    }

    public Flow<AddressEntity> findByAddressId(AddressId addressId) {
        String _sql = "SELECT * FROM AddressEntity WHERE addressId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AddressEntity WHERE addressId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__userConverters.fromAddressIdToString(addressId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"AddressEntity"}, (Callable)new Callable<AddressEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AddressEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AddressDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    AddressEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addressId");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signature");
                    int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"domainId");
                    int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canSend");
                    int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canReceive");
                    int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_data");
                    int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_signature");
                    if (_cursor.moveToFirst()) {
                        SignedKeyListEntity _tmpSignedKeyList;
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AddressDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfAddressId) ? null : _cursor.getString(_cursorIndexOfAddressId);
                        AddressId _tmpAddressId = AddressDao_Impl.this.__userConverters.fromStringToAddressId(_tmp_2);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        String _tmpSignature = _cursor.isNull(_cursorIndexOfSignature) ? null : _cursor.getString(_cursorIndexOfSignature);
                        String _tmpDomainId = _cursor.isNull(_cursorIndexOfDomainId) ? null : _cursor.getString(_cursorIndexOfDomainId);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
                        boolean _tmpCanSend = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
                        boolean _tmpCanReceive = _tmp_4 != 0;
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
                        boolean _tmpEnabled = _tmp_5 != 0;
                        Integer _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                        int _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                        if (!_cursor.isNull(_cursorIndexOfData) || !_cursor.isNull(_cursorIndexOfSignature_1)) {
                            String _tmpData = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                            String _tmpSignature_1 = _cursor.isNull(_cursorIndexOfSignature_1) ? null : _cursor.getString(_cursorIndexOfSignature_1);
                            _tmpSignedKeyList = new SignedKeyListEntity(_tmpData, _tmpSignature_1);
                        } else {
                            _tmpSignedKeyList = null;
                        }
                        _result = new AddressEntity(_tmpUserId, _tmpAddressId, _tmpEmail, _tmpDisplayName, _tmpSignature, _tmpDomainId, _tmpCanSend, _tmpCanReceive, _tmpEnabled, _tmpType, _tmpOrder, _tmpSignedKeyList);
                    } else {
                        _result = null;
                    }
                    AddressEntity addressEntity = _result;
                    return addressEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Flow<List<AddressEntity>> findAllByUserId(UserId userId) {
        String _sql = "SELECT * FROM AddressEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AddressEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"AddressEntity"}, (Callable)new Callable<List<AddressEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AddressEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AddressDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addressId");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signature");
                    int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"domainId");
                    int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canSend");
                    int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canReceive");
                    int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_data");
                    int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_signature");
                    ArrayList<AddressEntity> _result = new ArrayList<AddressEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        SignedKeyListEntity _tmpSignedKeyList;
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AddressDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfAddressId) ? null : _cursor.getString(_cursorIndexOfAddressId);
                        AddressId _tmpAddressId = AddressDao_Impl.this.__userConverters.fromStringToAddressId(_tmp_2);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        String _tmpSignature = _cursor.isNull(_cursorIndexOfSignature) ? null : _cursor.getString(_cursorIndexOfSignature);
                        String _tmpDomainId = _cursor.isNull(_cursorIndexOfDomainId) ? null : _cursor.getString(_cursorIndexOfDomainId);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
                        boolean _tmpCanSend = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
                        boolean _tmpCanReceive = _tmp_4 != 0;
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
                        boolean _tmpEnabled = _tmp_5 != 0;
                        Integer _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                        int _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                        if (!_cursor.isNull(_cursorIndexOfData) || !_cursor.isNull(_cursorIndexOfSignature_1)) {
                            String _tmpData = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                            String _tmpSignature_1 = _cursor.isNull(_cursorIndexOfSignature_1) ? null : _cursor.getString(_cursorIndexOfSignature_1);
                            _tmpSignedKeyList = new SignedKeyListEntity(_tmpData, _tmpSignature_1);
                        } else {
                            _tmpSignedKeyList = null;
                        }
                        AddressEntity _item = new AddressEntity(_tmpUserId, _tmpAddressId, _tmpEmail, _tmpDisplayName, _tmpSignature, _tmpDomainId, _tmpCanSend, _tmpCanReceive, _tmpEnabled, _tmpType, _tmpOrder, _tmpSignedKeyList);
                        _result.add(_item);
                    }
                    ArrayList<AddressEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getByAddressId(AddressId addressId, Continuation<? super AddressEntity> arg1) {
        String _sql = "SELECT * FROM AddressEntity WHERE addressId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AddressEntity WHERE addressId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__userConverters.fromAddressIdToString(addressId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<AddressEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AddressEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AddressDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    AddressEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addressId");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signature");
                    int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"domainId");
                    int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canSend");
                    int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canReceive");
                    int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_data");
                    int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_signature");
                    if (_cursor.moveToFirst()) {
                        SignedKeyListEntity _tmpSignedKeyList;
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AddressDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfAddressId) ? null : _cursor.getString(_cursorIndexOfAddressId);
                        AddressId _tmpAddressId = AddressDao_Impl.this.__userConverters.fromStringToAddressId(_tmp_2);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        String _tmpSignature = _cursor.isNull(_cursorIndexOfSignature) ? null : _cursor.getString(_cursorIndexOfSignature);
                        String _tmpDomainId = _cursor.isNull(_cursorIndexOfDomainId) ? null : _cursor.getString(_cursorIndexOfDomainId);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
                        boolean _tmpCanSend = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
                        boolean _tmpCanReceive = _tmp_4 != 0;
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
                        boolean _tmpEnabled = _tmp_5 != 0;
                        Integer _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                        int _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                        if (!_cursor.isNull(_cursorIndexOfData) || !_cursor.isNull(_cursorIndexOfSignature_1)) {
                            String _tmpData = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                            String _tmpSignature_1 = _cursor.isNull(_cursorIndexOfSignature_1) ? null : _cursor.getString(_cursorIndexOfSignature_1);
                            _tmpSignedKeyList = new SignedKeyListEntity(_tmpData, _tmpSignature_1);
                        } else {
                            _tmpSignedKeyList = null;
                        }
                        _result = new AddressEntity(_tmpUserId, _tmpAddressId, _tmpEmail, _tmpDisplayName, _tmpSignature, _tmpDomainId, _tmpCanSend, _tmpCanReceive, _tmpEnabled, _tmpType, _tmpOrder, _tmpSignedKeyList);
                    } else {
                        _result = null;
                    }
                    AddressEntity addressEntity = _result;
                    return addressEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public Object getAllUserId(UserId userId, Continuation<? super List<AddressEntity>> arg1) {
        String _sql = "SELECT * FROM AddressEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AddressEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<AddressEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AddressEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AddressDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addressId");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signature");
                    int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"domainId");
                    int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canSend");
                    int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canReceive");
                    int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order");
                    int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_data");
                    int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_signature");
                    ArrayList<AddressEntity> _result = new ArrayList<AddressEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        SignedKeyListEntity _tmpSignedKeyList;
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AddressDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfAddressId) ? null : _cursor.getString(_cursorIndexOfAddressId);
                        AddressId _tmpAddressId = AddressDao_Impl.this.__userConverters.fromStringToAddressId(_tmp_2);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        String _tmpSignature = _cursor.isNull(_cursorIndexOfSignature) ? null : _cursor.getString(_cursorIndexOfSignature);
                        String _tmpDomainId = _cursor.isNull(_cursorIndexOfDomainId) ? null : _cursor.getString(_cursorIndexOfDomainId);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
                        boolean _tmpCanSend = _tmp_3 != 0;
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
                        boolean _tmpCanReceive = _tmp_4 != 0;
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
                        boolean _tmpEnabled = _tmp_5 != 0;
                        Integer _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                        int _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                        if (!_cursor.isNull(_cursorIndexOfData) || !_cursor.isNull(_cursorIndexOfSignature_1)) {
                            String _tmpData = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                            String _tmpSignature_1 = _cursor.isNull(_cursorIndexOfSignature_1) ? null : _cursor.getString(_cursorIndexOfSignature_1);
                            _tmpSignedKeyList = new SignedKeyListEntity(_tmpData, _tmpSignature_1);
                        } else {
                            _tmpSignedKeyList = null;
                        }
                        AddressEntity _item = new AddressEntity(_tmpUserId, _tmpAddressId, _tmpEmail, _tmpDisplayName, _tmpSignature, _tmpDomainId, _tmpCanSend, _tmpCanReceive, _tmpEnabled, _tmpType, _tmpOrder, _tmpSignedKeyList);
                        _result.add(_item);
                    }
                    ArrayList<AddressEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

