/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.key.data.entity.SignedKeyListEntity;
import me.proton.core.key.domain.entity.key.KeyId;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.data.db.dao.AddressWithKeysDao;
import me.proton.core.user.data.entity.AddressEntity;
import me.proton.core.user.data.entity.AddressKeyEntity;
import me.proton.core.user.data.entity.AddressWithKeys;
import me.proton.core.user.domain.entity.AddressId;

public final class AddressWithKeysDao_Impl
extends AddressWithKeysDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AddressEntity> __insertionAdapterOfAddressEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final UserConverters __userConverters = new UserConverters();
    private final EntityDeletionOrUpdateAdapter<AddressEntity> __deletionAdapterOfAddressEntity;
    private final EntityDeletionOrUpdateAdapter<AddressEntity> __updateAdapterOfAddressEntity;

    public AddressWithKeysDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAddressEntity = new EntityInsertionAdapter<AddressEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `AddressEntity` (`userId`,`addressId`,`email`,`displayName`,`signature`,`domainId`,`canSend`,`canReceive`,`enabled`,`type`,`order`,`signedKeyList_data`,`signedKeyList_signature`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
                String _tmp = AddressWithKeysDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = AddressWithKeysDao_Impl.this.__userConverters.fromAddressIdToString(value.getAddressId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getEmail());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getSignature() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSignature());
                }
                if (value.getDomainId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getDomainId());
                }
                int _tmp_2 = value.getCanSend() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_2);
                int _tmp_3 = value.getCanReceive() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_3);
                int _tmp_4 = value.getEnabled() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_4);
                if (value.getType() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)value.getType().intValue());
                }
                stmt.bindLong(11, (long)value.getOrder());
                SignedKeyListEntity _tmpSignedKeyList = value.getSignedKeyList();
                if (_tmpSignedKeyList != null) {
                    if (_tmpSignedKeyList.getData() == null) {
                        stmt.bindNull(12);
                    } else {
                        stmt.bindString(12, _tmpSignedKeyList.getData());
                    }
                    if (_tmpSignedKeyList.getSignature() == null) {
                        stmt.bindNull(13);
                    } else {
                        stmt.bindString(13, _tmpSignedKeyList.getSignature());
                    }
                } else {
                    stmt.bindNull(12);
                    stmt.bindNull(13);
                }
            }
        };
        this.__deletionAdapterOfAddressEntity = new EntityDeletionOrUpdateAdapter<AddressEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `AddressEntity` WHERE `addressId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
                String _tmp = AddressWithKeysDao_Impl.this.__userConverters.fromAddressIdToString(value.getAddressId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfAddressEntity = new EntityDeletionOrUpdateAdapter<AddressEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `AddressEntity` SET `userId` = ?,`addressId` = ?,`email` = ?,`displayName` = ?,`signature` = ?,`domainId` = ?,`canSend` = ?,`canReceive` = ?,`enabled` = ?,`type` = ?,`order` = ?,`signedKeyList_data` = ?,`signedKeyList_signature` = ? WHERE `addressId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
                String _tmp = AddressWithKeysDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = AddressWithKeysDao_Impl.this.__userConverters.fromAddressIdToString(value.getAddressId());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getEmail());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getSignature() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSignature());
                }
                if (value.getDomainId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getDomainId());
                }
                int _tmp_2 = value.getCanSend() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_2);
                int _tmp_3 = value.getCanReceive() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_3);
                int _tmp_4 = value.getEnabled() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_4);
                if (value.getType() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)value.getType().intValue());
                }
                stmt.bindLong(11, (long)value.getOrder());
                SignedKeyListEntity _tmpSignedKeyList = value.getSignedKeyList();
                if (_tmpSignedKeyList != null) {
                    if (_tmpSignedKeyList.getData() == null) {
                        stmt.bindNull(12);
                    } else {
                        stmt.bindString(12, _tmpSignedKeyList.getData());
                    }
                    if (_tmpSignedKeyList.getSignature() == null) {
                        stmt.bindNull(13);
                    } else {
                        stmt.bindString(13, _tmpSignedKeyList.getSignature());
                    }
                } else {
                    stmt.bindNull(12);
                    stmt.bindNull(13);
                }
                String _tmp_5 = AddressWithKeysDao_Impl.this.__userConverters.fromAddressIdToString(value.getAddressId());
                if (_tmp_5 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_5);
                }
            }
        };
    }

    public Object insertOrIgnore(final AddressEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AddressWithKeysDao_Impl.this.__db.beginTransaction();
                try {
                    AddressWithKeysDao_Impl.this.__insertionAdapterOfAddressEntity.insert((Object[])entities);
                    AddressWithKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AddressWithKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final AddressEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AddressWithKeysDao_Impl.this.__db.beginTransaction();
                try {
                    AddressWithKeysDao_Impl.this.__deletionAdapterOfAddressEntity.handleMultiple((Object[])entities);
                    AddressWithKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AddressWithKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final AddressEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                AddressWithKeysDao_Impl.this.__db.beginTransaction();
                try {
                    AddressWithKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += AddressWithKeysDao_Impl.this.__updateAdapterOfAddressEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    AddressWithKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final AddressEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return AddressWithKeysDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Flow<List<AddressWithKeys>> findByUserId(UserId userId) {
        String _sql = "SELECT * FROM AddressEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AddressEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])new String[]{"AddressKeyEntity", "AddressEntity"}, (Callable)new Callable<List<AddressWithKeys>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AddressWithKeys> call() throws Exception {
                AddressWithKeysDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<AddressWithKeys> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)AddressWithKeysDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addressId");
                        int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                        int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                        int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signature");
                        int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"domainId");
                        int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canSend");
                        int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canReceive");
                        int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_data");
                        int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_signature");
                        HashMap _collectionKeys = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfAddressId);
                            ArrayList _tmpKeysCollection = (ArrayList)_collectionKeys.get(_tmpKey);
                            if (_tmpKeysCollection != null) continue;
                            _tmpKeysCollection = new ArrayList();
                            _collectionKeys.put(_tmpKey, _tmpKeysCollection);
                        }
                        _cursor.moveToPosition(-1);
                        AddressWithKeysDao_Impl.this.__fetchRelationshipAddressKeyEntityAsmeProtonCoreUserDataEntityAddressKeyEntity(_collectionKeys);
                        ArrayList<AddressWithKeys> _result = new ArrayList<AddressWithKeys>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            AddressEntity _tmpEntity;
                            if (!(_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfAddressId) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfDisplayName) && _cursor.isNull(_cursorIndexOfSignature) && _cursor.isNull(_cursorIndexOfDomainId) && _cursor.isNull(_cursorIndexOfCanSend) && _cursor.isNull(_cursorIndexOfCanReceive) && _cursor.isNull(_cursorIndexOfEnabled) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfOrder) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature_1))) {
                                SignedKeyListEntity _tmpSignedKeyList;
                                String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                UserId _tmpUserId = AddressWithKeysDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                                String _tmp_2 = _cursor.isNull(_cursorIndexOfAddressId) ? null : _cursor.getString(_cursorIndexOfAddressId);
                                AddressId _tmpAddressId = AddressWithKeysDao_Impl.this.__userConverters.fromStringToAddressId(_tmp_2);
                                String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                                String _tmpSignature = _cursor.isNull(_cursorIndexOfSignature) ? null : _cursor.getString(_cursorIndexOfSignature);
                                String _tmpDomainId = _cursor.isNull(_cursorIndexOfDomainId) ? null : _cursor.getString(_cursorIndexOfDomainId);
                                int _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
                                boolean _tmpCanSend = _tmp_3 != 0;
                                int _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
                                boolean _tmpCanReceive = _tmp_4 != 0;
                                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
                                boolean _tmpEnabled = _tmp_5 != 0;
                                Integer _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                                int _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                                if (!_cursor.isNull(_cursorIndexOfData) || !_cursor.isNull(_cursorIndexOfSignature_1)) {
                                    String _tmpData = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                                    String _tmpSignature_1 = _cursor.isNull(_cursorIndexOfSignature_1) ? null : _cursor.getString(_cursorIndexOfSignature_1);
                                    _tmpSignedKeyList = new SignedKeyListEntity(_tmpData, _tmpSignature_1);
                                } else {
                                    _tmpSignedKeyList = null;
                                }
                                _tmpEntity = new AddressEntity(_tmpUserId, _tmpAddressId, _tmpEmail, _tmpDisplayName, _tmpSignature, _tmpDomainId, _tmpCanSend, _tmpCanReceive, _tmpEnabled, _tmpType, _tmpOrder, _tmpSignedKeyList);
                            } else {
                                _tmpEntity = null;
                            }
                            ArrayList _tmpKeysCollection_1 = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfAddressId);
                            _tmpKeysCollection_1 = (ArrayList)_collectionKeys.get(_tmpKey_1);
                            if (_tmpKeysCollection_1 == null) {
                                _tmpKeysCollection_1 = new ArrayList();
                            }
                            AddressWithKeys _item = new AddressWithKeys(_tmpEntity, _tmpKeysCollection_1);
                            _result.add(_item);
                        }
                        AddressWithKeysDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    AddressWithKeysDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getByUserId(UserId userId, Continuation<? super List<AddressWithKeys>> arg1) {
        String _sql = "SELECT * FROM AddressEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AddressEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<AddressWithKeys>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AddressWithKeys> call() throws Exception {
                AddressWithKeysDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<AddressWithKeys> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)AddressWithKeysDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addressId");
                        int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                        int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                        int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signature");
                        int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"domainId");
                        int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canSend");
                        int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"canReceive");
                        int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"enabled");
                        int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                        int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"order");
                        int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_data");
                        int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signedKeyList_signature");
                        HashMap _collectionKeys = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfAddressId);
                            ArrayList _tmpKeysCollection = (ArrayList)_collectionKeys.get(_tmpKey);
                            if (_tmpKeysCollection != null) continue;
                            _tmpKeysCollection = new ArrayList();
                            _collectionKeys.put(_tmpKey, _tmpKeysCollection);
                        }
                        _cursor.moveToPosition(-1);
                        AddressWithKeysDao_Impl.this.__fetchRelationshipAddressKeyEntityAsmeProtonCoreUserDataEntityAddressKeyEntity(_collectionKeys);
                        ArrayList<AddressWithKeys> _result = new ArrayList<AddressWithKeys>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            AddressEntity _tmpEntity;
                            if (!(_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfAddressId) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfDisplayName) && _cursor.isNull(_cursorIndexOfSignature) && _cursor.isNull(_cursorIndexOfDomainId) && _cursor.isNull(_cursorIndexOfCanSend) && _cursor.isNull(_cursorIndexOfCanReceive) && _cursor.isNull(_cursorIndexOfEnabled) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfOrder) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature_1))) {
                                SignedKeyListEntity _tmpSignedKeyList;
                                String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                UserId _tmpUserId = AddressWithKeysDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                                String _tmp_2 = _cursor.isNull(_cursorIndexOfAddressId) ? null : _cursor.getString(_cursorIndexOfAddressId);
                                AddressId _tmpAddressId = AddressWithKeysDao_Impl.this.__userConverters.fromStringToAddressId(_tmp_2);
                                String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                                String _tmpSignature = _cursor.isNull(_cursorIndexOfSignature) ? null : _cursor.getString(_cursorIndexOfSignature);
                                String _tmpDomainId = _cursor.isNull(_cursorIndexOfDomainId) ? null : _cursor.getString(_cursorIndexOfDomainId);
                                int _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
                                boolean _tmpCanSend = _tmp_3 != 0;
                                int _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
                                boolean _tmpCanReceive = _tmp_4 != 0;
                                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
                                boolean _tmpEnabled = _tmp_5 != 0;
                                Integer _tmpType = _cursor.isNull(_cursorIndexOfType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfType));
                                int _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                                if (!_cursor.isNull(_cursorIndexOfData) || !_cursor.isNull(_cursorIndexOfSignature_1)) {
                                    String _tmpData = _cursor.isNull(_cursorIndexOfData) ? null : _cursor.getString(_cursorIndexOfData);
                                    String _tmpSignature_1 = _cursor.isNull(_cursorIndexOfSignature_1) ? null : _cursor.getString(_cursorIndexOfSignature_1);
                                    _tmpSignedKeyList = new SignedKeyListEntity(_tmpData, _tmpSignature_1);
                                } else {
                                    _tmpSignedKeyList = null;
                                }
                                _tmpEntity = new AddressEntity(_tmpUserId, _tmpAddressId, _tmpEmail, _tmpDisplayName, _tmpSignature, _tmpDomainId, _tmpCanSend, _tmpCanReceive, _tmpEnabled, _tmpType, _tmpOrder, _tmpSignedKeyList);
                            } else {
                                _tmpEntity = null;
                            }
                            ArrayList _tmpKeysCollection_1 = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfAddressId);
                            _tmpKeysCollection_1 = (ArrayList)_collectionKeys.get(_tmpKey_1);
                            if (_tmpKeysCollection_1 == null) {
                                _tmpKeysCollection_1 = new ArrayList();
                            }
                            AddressWithKeys _item = new AddressWithKeys(_tmpEntity, _tmpKeysCollection_1);
                            _result.add(_item);
                        }
                        AddressWithKeysDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return arrayList;
                }
                finally {
                    AddressWithKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipAddressKeyEntityAsmeProtonCoreUserDataEntityAddressKeyEntity(HashMap<String, ArrayList<AddressKeyEntity>> _map) {
        Set<String> __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            HashMap<String, ArrayList<Object>> _tmpInnerMap = new HashMap<String, ArrayList<AddressKeyEntity>>(999);
            int _tmpIndex = 0;
            for (String _mapKey : __mapKeySet) {
                _tmpInnerMap.put(_mapKey, _map.get(_mapKey));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipAddressKeyEntityAsmeProtonCoreUserDataEntityAddressKeyEntity(_tmpInnerMap);
                _tmpInnerMap = new HashMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipAddressKeyEntityAsmeProtonCoreUserDataEntityAddressKeyEntity(_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `addressId`,`keyId`,`version`,`privateKey`,`isPrimary`,`flags`,`token`,`signature`,`fingerprint`,`fingerprints`,`activation`,`active` FROM `AddressKeyEntity` WHERE `addressId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"addressId");
            if (_itemKeyIndex == -1) {
                return;
            }
            int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addressId");
            int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"keyId");
            int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"version");
            int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"privateKey");
            int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPrimary");
            int _cursorIndexOfFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flags");
            int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"token");
            int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"signature");
            int _cursorIndexOfFingerprint = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fingerprint");
            int _cursorIndexOfFingerprints = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fingerprints");
            int _cursorIndexOfActivation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activation");
            int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"active");
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList<AddressKeyEntity> _tmpRelation = _map.get(_tmpKey);
                if (_tmpRelation == null) continue;
                String _tmp = _cursor.isNull(_cursorIndexOfAddressId) ? null : _cursor.getString(_cursorIndexOfAddressId);
                AddressId _tmpAddressId = this.__userConverters.fromStringToAddressId(_tmp);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfKeyId) ? null : _cursor.getString(_cursorIndexOfKeyId);
                KeyId _tmpKeyId = this.__userConverters.fromStringToKeyId(_tmp_1);
                int _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
                String _tmpPrivateKey = _cursor.isNull(_cursorIndexOfPrivateKey) ? null : _cursor.getString(_cursorIndexOfPrivateKey);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPrimary);
                boolean _tmpIsPrimary = _tmp_2 != 0;
                int _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
                String _tmpToken = _cursor.isNull(_cursorIndexOfToken) ? null : _cursor.getString(_cursorIndexOfToken);
                String _tmpSignature = _cursor.isNull(_cursorIndexOfSignature) ? null : _cursor.getString(_cursorIndexOfSignature);
                String _tmpFingerprint = _cursor.isNull(_cursorIndexOfFingerprint) ? null : _cursor.getString(_cursorIndexOfFingerprint);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfFingerprints) ? null : _cursor.getString(_cursorIndexOfFingerprints);
                List _tmpFingerprints = this.__commonConverters.fromStringToListOfString(_tmp_3);
                String _tmpActivation = _cursor.isNull(_cursorIndexOfActivation) ? null : _cursor.getString(_cursorIndexOfActivation);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfActive);
                boolean _tmpActive = _tmp_4 != 0;
                AddressKeyEntity _item_1 = new AddressKeyEntity(_tmpAddressId, _tmpKeyId, _tmpVersion, _tmpPrivateKey, _tmpIsPrimary, _tmpFlags, _tmpToken, _tmpSignature, _tmpFingerprint, _tmpFingerprints, _tmpActivation, _tmpActive);
                _tmpRelation.add(_item_1);
            }
        }
    }
}

