/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.crypto.android.keystore.CryptoConverters;
import me.proton.core.crypto.common.keystore.EncryptedByteArray;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.key.domain.entity.key.KeyId;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.data.db.dao.UserWithKeysDao;
import me.proton.core.user.data.entity.UserEntity;
import me.proton.core.user.data.entity.UserKeyEntity;
import me.proton.core.user.data.entity.UserWithKeys;

public final class UserWithKeysDao_Impl
extends UserWithKeysDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserEntity> __insertionAdapterOfUserEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final CryptoConverters __cryptoConverters = new CryptoConverters();
    private final EntityDeletionOrUpdateAdapter<UserEntity> __deletionAdapterOfUserEntity;
    private final EntityDeletionOrUpdateAdapter<UserEntity> __updateAdapterOfUserEntity;
    private final UserConverters __userConverters = new UserConverters();

    public UserWithKeysDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `UserEntity` (`userId`,`email`,`name`,`displayName`,`currency`,`credit`,`usedSpace`,`maxSpace`,`maxUpload`,`role`,`private`,`subscribed`,`services`,`delinquent`,`passphrase`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                String _tmp = UserWithKeysDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEmail());
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getCurrency() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getCurrency());
                }
                stmt.bindLong(6, (long)value.getCredit());
                stmt.bindLong(7, value.getUsedSpace());
                stmt.bindLong(8, value.getMaxSpace());
                stmt.bindLong(9, value.getMaxUpload());
                if (value.getRole() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)value.getRole().intValue());
                }
                int _tmp_1 = value.getPrivate() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp_1);
                stmt.bindLong(12, (long)value.getSubscribed());
                stmt.bindLong(13, (long)value.getServices());
                if (value.getDelinquent() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)value.getDelinquent().intValue());
                }
                byte[] _tmp_2 = UserWithKeysDao_Impl.this.__cryptoConverters.fromEncryptedByteArrayToByteArray(value.getPassphrase());
                if (_tmp_2 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindBlob(15, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `UserEntity` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                String _tmp = UserWithKeysDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `UserEntity` SET `userId` = ?,`email` = ?,`name` = ?,`displayName` = ?,`currency` = ?,`credit` = ?,`usedSpace` = ?,`maxSpace` = ?,`maxUpload` = ?,`role` = ?,`private` = ?,`subscribed` = ?,`services` = ?,`delinquent` = ?,`passphrase` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserEntity value) {
                String _tmp = UserWithKeysDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEmail());
                }
                if (value.getName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getName());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getCurrency() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getCurrency());
                }
                stmt.bindLong(6, (long)value.getCredit());
                stmt.bindLong(7, value.getUsedSpace());
                stmt.bindLong(8, value.getMaxSpace());
                stmt.bindLong(9, value.getMaxUpload());
                if (value.getRole() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)value.getRole().intValue());
                }
                int _tmp_1 = value.getPrivate() ? 1 : 0;
                stmt.bindLong(11, (long)_tmp_1);
                stmt.bindLong(12, (long)value.getSubscribed());
                stmt.bindLong(13, (long)value.getServices());
                if (value.getDelinquent() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)value.getDelinquent().intValue());
                }
                byte[] _tmp_2 = UserWithKeysDao_Impl.this.__cryptoConverters.fromEncryptedByteArrayToByteArray(value.getPassphrase());
                if (_tmp_2 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindBlob(15, _tmp_2);
                }
                String _tmp_3 = UserWithKeysDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_3 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_3);
                }
            }
        };
    }

    public Object insertOrIgnore(final UserEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                UserWithKeysDao_Impl.this.__db.beginTransaction();
                try {
                    UserWithKeysDao_Impl.this.__insertionAdapterOfUserEntity.insert((Object[])entities);
                    UserWithKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserWithKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final UserEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                UserWithKeysDao_Impl.this.__db.beginTransaction();
                try {
                    UserWithKeysDao_Impl.this.__deletionAdapterOfUserEntity.handleMultiple((Object[])entities);
                    UserWithKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserWithKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final UserEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                UserWithKeysDao_Impl.this.__db.beginTransaction();
                try {
                    UserWithKeysDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += UserWithKeysDao_Impl.this.__updateAdapterOfUserEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    UserWithKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final UserEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return UserWithKeysDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Flow<UserWithKeys> findByUserId(UserId userId) {
        String _sql = "SELECT * FROM UserEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM UserEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])new String[]{"UserKeyEntity", "UserEntity"}, (Callable)new Callable<UserWithKeys>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserWithKeys call() throws Exception {
                UserWithKeysDao_Impl.this.__db.beginTransaction();
                try {
                    UserWithKeys userWithKeys;
                    Cursor _cursor = DBUtil.query((RoomDatabase)UserWithKeysDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        UserWithKeys _result;
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                        int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                        int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
                        int _cursorIndexOfCredit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"credit");
                        int _cursorIndexOfUsedSpace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usedSpace");
                        int _cursorIndexOfMaxSpace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxSpace");
                        int _cursorIndexOfMaxUpload = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxUpload");
                        int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"role");
                        int _cursorIndexOfPrivate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"private");
                        int _cursorIndexOfSubscribed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subscribed");
                        int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
                        int _cursorIndexOfDelinquent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delinquent");
                        int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"passphrase");
                        HashMap _collectionKeys = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfUserId);
                            ArrayList _tmpKeysCollection = (ArrayList)_collectionKeys.get(_tmpKey);
                            if (_tmpKeysCollection != null) continue;
                            _tmpKeysCollection = new ArrayList();
                            _collectionKeys.put(_tmpKey, _tmpKeysCollection);
                        }
                        _cursor.moveToPosition(-1);
                        UserWithKeysDao_Impl.this.__fetchRelationshipUserKeyEntityAsmeProtonCoreUserDataEntityUserKeyEntity(_collectionKeys);
                        if (_cursor.moveToFirst()) {
                            UserEntity _tmpEntity;
                            if (!(_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfDisplayName) && _cursor.isNull(_cursorIndexOfCurrency) && _cursor.isNull(_cursorIndexOfCredit) && _cursor.isNull(_cursorIndexOfUsedSpace) && _cursor.isNull(_cursorIndexOfMaxSpace) && _cursor.isNull(_cursorIndexOfMaxUpload) && _cursor.isNull(_cursorIndexOfRole) && _cursor.isNull(_cursorIndexOfPrivate) && _cursor.isNull(_cursorIndexOfSubscribed) && _cursor.isNull(_cursorIndexOfServices) && _cursor.isNull(_cursorIndexOfDelinquent) && _cursor.isNull(_cursorIndexOfPassphrase))) {
                                String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                UserId _tmpUserId = UserWithKeysDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                                String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                                String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                                int _tmpCredit = _cursor.getInt(_cursorIndexOfCredit);
                                long _tmpUsedSpace = _cursor.getLong(_cursorIndexOfUsedSpace);
                                long _tmpMaxSpace = _cursor.getLong(_cursorIndexOfMaxSpace);
                                long _tmpMaxUpload = _cursor.getLong(_cursorIndexOfMaxUpload);
                                Integer _tmpRole = _cursor.isNull(_cursorIndexOfRole) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfRole));
                                int _tmp_2 = _cursor.getInt(_cursorIndexOfPrivate);
                                boolean _tmpPrivate = _tmp_2 != 0;
                                int _tmpSubscribed = _cursor.getInt(_cursorIndexOfSubscribed);
                                int _tmpServices = _cursor.getInt(_cursorIndexOfServices);
                                Integer _tmpDelinquent = _cursor.isNull(_cursorIndexOfDelinquent) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDelinquent));
                                byte[] _tmp_3 = _cursor.isNull(_cursorIndexOfPassphrase) ? null : _cursor.getBlob(_cursorIndexOfPassphrase);
                                EncryptedByteArray _tmpPassphrase = UserWithKeysDao_Impl.this.__cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_3);
                                _tmpEntity = new UserEntity(_tmpUserId, _tmpEmail, _tmpName, _tmpDisplayName, _tmpCurrency, _tmpCredit, _tmpUsedSpace, _tmpMaxSpace, _tmpMaxUpload, _tmpRole, _tmpPrivate, _tmpSubscribed, _tmpServices, _tmpDelinquent, _tmpPassphrase);
                            } else {
                                _tmpEntity = null;
                            }
                            ArrayList _tmpKeysCollection_1 = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfUserId);
                            _tmpKeysCollection_1 = (ArrayList)_collectionKeys.get(_tmpKey_1);
                            if (_tmpKeysCollection_1 == null) {
                                _tmpKeysCollection_1 = new ArrayList();
                            }
                            _result = new UserWithKeys(_tmpEntity, _tmpKeysCollection_1);
                        } else {
                            _result = null;
                        }
                        UserWithKeysDao_Impl.this.__db.setTransactionSuccessful();
                        userWithKeys = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return userWithKeys;
                }
                finally {
                    UserWithKeysDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getByUserId(UserId userId, Continuation<? super UserWithKeys> arg1) {
        String _sql = "SELECT * FROM UserEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM UserEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (CancellationSignal)_cancellationSignal, (Callable)new Callable<UserWithKeys>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserWithKeys call() throws Exception {
                UserWithKeysDao_Impl.this.__db.beginTransaction();
                try {
                    UserWithKeys userWithKeys;
                    Cursor _cursor = DBUtil.query((RoomDatabase)UserWithKeysDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)true, null);
                    try {
                        UserWithKeys _result;
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                        int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                        int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                        int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                        int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"currency");
                        int _cursorIndexOfCredit = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"credit");
                        int _cursorIndexOfUsedSpace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"usedSpace");
                        int _cursorIndexOfMaxSpace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxSpace");
                        int _cursorIndexOfMaxUpload = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"maxUpload");
                        int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"role");
                        int _cursorIndexOfPrivate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"private");
                        int _cursorIndexOfSubscribed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subscribed");
                        int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"services");
                        int _cursorIndexOfDelinquent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delinquent");
                        int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"passphrase");
                        HashMap _collectionKeys = new HashMap();
                        while (_cursor.moveToNext()) {
                            String _tmpKey = _cursor.getString(_cursorIndexOfUserId);
                            ArrayList _tmpKeysCollection = (ArrayList)_collectionKeys.get(_tmpKey);
                            if (_tmpKeysCollection != null) continue;
                            _tmpKeysCollection = new ArrayList();
                            _collectionKeys.put(_tmpKey, _tmpKeysCollection);
                        }
                        _cursor.moveToPosition(-1);
                        UserWithKeysDao_Impl.this.__fetchRelationshipUserKeyEntityAsmeProtonCoreUserDataEntityUserKeyEntity(_collectionKeys);
                        if (_cursor.moveToFirst()) {
                            UserEntity _tmpEntity;
                            if (!(_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfDisplayName) && _cursor.isNull(_cursorIndexOfCurrency) && _cursor.isNull(_cursorIndexOfCredit) && _cursor.isNull(_cursorIndexOfUsedSpace) && _cursor.isNull(_cursorIndexOfMaxSpace) && _cursor.isNull(_cursorIndexOfMaxUpload) && _cursor.isNull(_cursorIndexOfRole) && _cursor.isNull(_cursorIndexOfPrivate) && _cursor.isNull(_cursorIndexOfSubscribed) && _cursor.isNull(_cursorIndexOfServices) && _cursor.isNull(_cursorIndexOfDelinquent) && _cursor.isNull(_cursorIndexOfPassphrase))) {
                                String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                                UserId _tmpUserId = UserWithKeysDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                                String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                                String _tmpCurrency = _cursor.isNull(_cursorIndexOfCurrency) ? null : _cursor.getString(_cursorIndexOfCurrency);
                                int _tmpCredit = _cursor.getInt(_cursorIndexOfCredit);
                                long _tmpUsedSpace = _cursor.getLong(_cursorIndexOfUsedSpace);
                                long _tmpMaxSpace = _cursor.getLong(_cursorIndexOfMaxSpace);
                                long _tmpMaxUpload = _cursor.getLong(_cursorIndexOfMaxUpload);
                                Integer _tmpRole = _cursor.isNull(_cursorIndexOfRole) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfRole));
                                int _tmp_2 = _cursor.getInt(_cursorIndexOfPrivate);
                                boolean _tmpPrivate = _tmp_2 != 0;
                                int _tmpSubscribed = _cursor.getInt(_cursorIndexOfSubscribed);
                                int _tmpServices = _cursor.getInt(_cursorIndexOfServices);
                                Integer _tmpDelinquent = _cursor.isNull(_cursorIndexOfDelinquent) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDelinquent));
                                byte[] _tmp_3 = _cursor.isNull(_cursorIndexOfPassphrase) ? null : _cursor.getBlob(_cursorIndexOfPassphrase);
                                EncryptedByteArray _tmpPassphrase = UserWithKeysDao_Impl.this.__cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_3);
                                _tmpEntity = new UserEntity(_tmpUserId, _tmpEmail, _tmpName, _tmpDisplayName, _tmpCurrency, _tmpCredit, _tmpUsedSpace, _tmpMaxSpace, _tmpMaxUpload, _tmpRole, _tmpPrivate, _tmpSubscribed, _tmpServices, _tmpDelinquent, _tmpPassphrase);
                            } else {
                                _tmpEntity = null;
                            }
                            ArrayList _tmpKeysCollection_1 = null;
                            String _tmpKey_1 = _cursor.getString(_cursorIndexOfUserId);
                            _tmpKeysCollection_1 = (ArrayList)_collectionKeys.get(_tmpKey_1);
                            if (_tmpKeysCollection_1 == null) {
                                _tmpKeysCollection_1 = new ArrayList();
                            }
                            _result = new UserWithKeys(_tmpEntity, _tmpKeysCollection_1);
                        } else {
                            _result = null;
                        }
                        UserWithKeysDao_Impl.this.__db.setTransactionSuccessful();
                        userWithKeys = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        _statement.release();
                        throw throwable;
                    }
                    _cursor.close();
                    _statement.release();
                    return userWithKeys;
                }
                finally {
                    UserWithKeysDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __fetchRelationshipUserKeyEntityAsmeProtonCoreUserDataEntityUserKeyEntity(HashMap<String, ArrayList<UserKeyEntity>> _map) {
        Set<String> __mapKeySet = _map.keySet();
        if (__mapKeySet.isEmpty()) {
            return;
        }
        if (_map.size() > 999) {
            HashMap<String, ArrayList<Object>> _tmpInnerMap = new HashMap<String, ArrayList<UserKeyEntity>>(999);
            int _tmpIndex = 0;
            for (String _mapKey : __mapKeySet) {
                _tmpInnerMap.put(_mapKey, _map.get(_mapKey));
                if (++_tmpIndex != 999) continue;
                this.__fetchRelationshipUserKeyEntityAsmeProtonCoreUserDataEntityUserKeyEntity(_tmpInnerMap);
                _tmpInnerMap = new HashMap(999);
                _tmpIndex = 0;
            }
            if (_tmpIndex > 0) {
                this.__fetchRelationshipUserKeyEntityAsmeProtonCoreUserDataEntityUserKeyEntity(_tmpInnerMap);
            }
            return;
        }
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT `userId`,`keyId`,`version`,`privateKey`,`isPrimary`,`fingerprint`,`activation` FROM `UserKeyEntity` WHERE `userId` IN (");
        int _inputSize = __mapKeySet.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : __mapKeySet) {
            if (_item == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        try (Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_stmt, (boolean)false, null);){
            int _itemKeyIndex = CursorUtil.getColumnIndex((Cursor)_cursor, (String)"userId");
            if (_itemKeyIndex == -1) {
                return;
            }
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"keyId");
            int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"version");
            int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"privateKey");
            int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPrimary");
            int _cursorIndexOfFingerprint = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fingerprint");
            int _cursorIndexOfActivation = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activation");
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_itemKeyIndex);
                ArrayList<UserKeyEntity> _tmpRelation = _map.get(_tmpKey);
                if (_tmpRelation == null) continue;
                String _tmp = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                UserId _tmpUserId = this.__commonConverters.fromStringToUserId(_tmp);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfKeyId) ? null : _cursor.getString(_cursorIndexOfKeyId);
                KeyId _tmpKeyId = this.__userConverters.fromStringToKeyId(_tmp_1);
                int _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
                String _tmpPrivateKey = _cursor.isNull(_cursorIndexOfPrivateKey) ? null : _cursor.getString(_cursorIndexOfPrivateKey);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPrimary);
                boolean _tmpIsPrimary = _tmp_2 != 0;
                String _tmpFingerprint = _cursor.isNull(_cursorIndexOfFingerprint) ? null : _cursor.getString(_cursorIndexOfFingerprint);
                String _tmpActivation = _cursor.isNull(_cursorIndexOfActivation) ? null : _cursor.getString(_cursorIndexOfActivation);
                UserKeyEntity _item_1 = new UserKeyEntity(_tmpUserId, _tmpKeyId, _tmpVersion, _tmpPrivateKey, _tmpIsPrimary, _tmpFingerprint, _tmpActivation);
                _tmpRelation.add(_item_1);
            }
        }
    }
}

