/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.contact.data.local.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.contact.data.local.db.ContactConverters;
import me.proton.core.contact.data.local.db.dao.ContactEmailLabelDao;
import me.proton.core.contact.data.local.db.entity.ContactEmailLabelEntity;
import me.proton.core.contact.domain.entity.ContactEmailId;

public final class ContactEmailLabelDao_Impl
extends ContactEmailLabelDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ContactEmailLabelEntity> __insertionAdapterOfContactEmailLabelEntity;
    private final ContactConverters __contactConverters = new ContactConverters();
    private final EntityDeletionOrUpdateAdapter<ContactEmailLabelEntity> __deletionAdapterOfContactEmailLabelEntity;
    private final EntityDeletionOrUpdateAdapter<ContactEmailLabelEntity> __updateAdapterOfContactEmailLabelEntity;

    public ContactEmailLabelDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContactEmailLabelEntity = new EntityInsertionAdapter<ContactEmailLabelEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `ContactEmailLabelEntity` (`contactEmailId`,`labelId`) VALUES (?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ContactEmailLabelEntity value) {
                String _tmp = ContactEmailLabelDao_Impl.this.__contactConverters.fromContactEmailIdToString(value.getContactEmailId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getLabelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getLabelId());
                }
            }
        };
        this.__deletionAdapterOfContactEmailLabelEntity = new EntityDeletionOrUpdateAdapter<ContactEmailLabelEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `ContactEmailLabelEntity` WHERE `contactEmailId` = ? AND `labelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ContactEmailLabelEntity value) {
                String _tmp = ContactEmailLabelDao_Impl.this.__contactConverters.fromContactEmailIdToString(value.getContactEmailId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getLabelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getLabelId());
                }
            }
        };
        this.__updateAdapterOfContactEmailLabelEntity = new EntityDeletionOrUpdateAdapter<ContactEmailLabelEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `ContactEmailLabelEntity` SET `contactEmailId` = ?,`labelId` = ? WHERE `contactEmailId` = ? AND `labelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ContactEmailLabelEntity value) {
                String _tmp = ContactEmailLabelDao_Impl.this.__contactConverters.fromContactEmailIdToString(value.getContactEmailId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getLabelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getLabelId());
                }
                String _tmp_1 = ContactEmailLabelDao_Impl.this.__contactConverters.fromContactEmailIdToString(value.getContactEmailId());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getLabelId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getLabelId());
                }
            }
        };
    }

    public Object insertOrIgnore(final ContactEmailLabelEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ContactEmailLabelDao_Impl.this.__db.beginTransaction();
                try {
                    ContactEmailLabelDao_Impl.this.__insertionAdapterOfContactEmailLabelEntity.insert((Object[])entities);
                    ContactEmailLabelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactEmailLabelDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final ContactEmailLabelEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                ContactEmailLabelDao_Impl.this.__db.beginTransaction();
                try {
                    ContactEmailLabelDao_Impl.this.__deletionAdapterOfContactEmailLabelEntity.handleMultiple((Object[])entities);
                    ContactEmailLabelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactEmailLabelDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final ContactEmailLabelEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                ContactEmailLabelDao_Impl.this.__db.beginTransaction();
                try {
                    ContactEmailLabelDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += ContactEmailLabelDao_Impl.this.__updateAdapterOfContactEmailLabelEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    ContactEmailLabelDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final ContactEmailLabelEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return ContactEmailLabelDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Flow<List<String>> observeAllLabels(ContactEmailId contactEmailId) {
        String _sql = "SELECT labelId FROM ContactEmailLabelEntity WHERE contactEmailId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT labelId FROM ContactEmailLabelEntity WHERE contactEmailId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__contactConverters.fromContactEmailIdToString(contactEmailId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)true, (String[])new String[]{"ContactEmailLabelEntity"}, (Callable)new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> call() throws Exception {
                ContactEmailLabelDao_Impl.this.__db.beginTransaction();
                try {
                    ArrayList<String> arrayList;
                    Cursor _cursor = DBUtil.query((RoomDatabase)ContactEmailLabelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                    try {
                        ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                        while (_cursor.moveToNext()) {
                            String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                            _result.add(_item);
                        }
                        ContactEmailLabelDao_Impl.this.__db.setTransactionSuccessful();
                        arrayList = _result;
                    }
                    catch (Throwable throwable) {
                        _cursor.close();
                        throw throwable;
                    }
                    _cursor.close();
                    return arrayList;
                }
                finally {
                    ContactEmailLabelDao_Impl.this.__db.endTransaction();
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object deleteAllLabels(final ContactEmailId[] contactEmailIds, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("DELETE FROM ContactEmailLabelEntity WHERE contactEmailId IN (");
                int _inputSize = contactEmailIds.length;
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = ContactEmailLabelDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                for (ContactEmailId _item : contactEmailIds) {
                    String _tmp = ContactEmailLabelDao_Impl.this.__contactConverters.fromContactEmailIdToString(_item);
                    if (_tmp == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindString(_argIndex, _tmp);
                    }
                    ++_argIndex;
                }
                ContactEmailLabelDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    ContactEmailLabelDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    ContactEmailLabelDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

