/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.usersettings.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.usersettings.data.db.UserSettingsConverters;
import me.proton.core.usersettings.data.db.dao.UserSettingsDao;
import me.proton.core.usersettings.data.entity.FlagsEntity;
import me.proton.core.usersettings.data.entity.PasswordEntity;
import me.proton.core.usersettings.data.entity.RecoverySettingEntity;
import me.proton.core.usersettings.data.entity.TwoFAEntity;
import me.proton.core.usersettings.data.entity.UserSettingsEntity;

public final class UserSettingsDao_Impl
extends UserSettingsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserSettingsEntity> __insertionAdapterOfUserSettingsEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final UserSettingsConverters __userSettingsConverters = new UserSettingsConverters();
    private final EntityDeletionOrUpdateAdapter<UserSettingsEntity> __deletionAdapterOfUserSettingsEntity;
    private final EntityDeletionOrUpdateAdapter<UserSettingsEntity> __updateAdapterOfUserSettingsEntity;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public UserSettingsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserSettingsEntity = new EntityInsertionAdapter<UserSettingsEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `UserSettingsEntity` (`userId`,`news`,`locale`,`logAuth`,`invoiceText`,`density`,`theme`,`themeType`,`weekStart`,`dateFormat`,`timeFormat`,`welcome`,`earlyAccess`,`email_value`,`email_status`,`email_notify`,`email_reset`,`phone_value`,`phone_status`,`phone_notify`,`phone_reset`,`password_mode`,`password_expirationTime`,`twoFA_enabled`,`twoFA_allowed`,`twoFA_expirationTime`,`twoFA_u2fKeys`,`flags_welcomed`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserSettingsEntity value) {
                Integer _tmp_2;
                Integer _tmp_1;
                String _tmp = UserSettingsDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getNews() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, (long)value.getNews().intValue());
                }
                if (value.getLocale() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getLocale());
                }
                if (value.getLogAuth() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)value.getLogAuth().intValue());
                }
                if (value.getInvoiceText() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getInvoiceText());
                }
                if (value.getDensity() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)value.getDensity().intValue());
                }
                if (value.getTheme() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getTheme());
                }
                if (value.getThemeType() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, (long)value.getThemeType().intValue());
                }
                if (value.getWeekStart() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)value.getWeekStart().intValue());
                }
                if (value.getDateFormat() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)value.getDateFormat().intValue());
                }
                if (value.getTimeFormat() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, (long)value.getTimeFormat().intValue());
                }
                Integer n = value.getWelcome() == null ? null : (_tmp_1 = Integer.valueOf(value.getWelcome() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)_tmp_1.intValue());
                }
                Integer n2 = value.getEarlyAccess() == null ? null : (_tmp_2 = Integer.valueOf(value.getEarlyAccess() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, (long)_tmp_2.intValue());
                }
                RecoverySettingEntity _tmpEmail = value.getEmail();
                if (_tmpEmail != null) {
                    if (_tmpEmail.getValue() == null) {
                        stmt.bindNull(14);
                    } else {
                        stmt.bindString(14, _tmpEmail.getValue());
                    }
                    if (_tmpEmail.getStatus() == null) {
                        stmt.bindNull(15);
                    } else {
                        stmt.bindLong(15, (long)_tmpEmail.getStatus().intValue());
                    }
                    if (_tmpEmail.getNotify() == null) {
                        stmt.bindNull(16);
                    } else {
                        stmt.bindLong(16, (long)_tmpEmail.getNotify().intValue());
                    }
                    if (_tmpEmail.getReset() == null) {
                        stmt.bindNull(17);
                    } else {
                        stmt.bindLong(17, (long)_tmpEmail.getReset().intValue());
                    }
                } else {
                    stmt.bindNull(14);
                    stmt.bindNull(15);
                    stmt.bindNull(16);
                    stmt.bindNull(17);
                }
                RecoverySettingEntity _tmpPhone = value.getPhone();
                if (_tmpPhone != null) {
                    if (_tmpPhone.getValue() == null) {
                        stmt.bindNull(18);
                    } else {
                        stmt.bindString(18, _tmpPhone.getValue());
                    }
                    if (_tmpPhone.getStatus() == null) {
                        stmt.bindNull(19);
                    } else {
                        stmt.bindLong(19, (long)_tmpPhone.getStatus().intValue());
                    }
                    if (_tmpPhone.getNotify() == null) {
                        stmt.bindNull(20);
                    } else {
                        stmt.bindLong(20, (long)_tmpPhone.getNotify().intValue());
                    }
                    if (_tmpPhone.getReset() == null) {
                        stmt.bindNull(21);
                    } else {
                        stmt.bindLong(21, (long)_tmpPhone.getReset().intValue());
                    }
                } else {
                    stmt.bindNull(18);
                    stmt.bindNull(19);
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                }
                PasswordEntity _tmpPassword = value.getPassword();
                if (_tmpPassword != null) {
                    if (_tmpPassword.getMode() == null) {
                        stmt.bindNull(22);
                    } else {
                        stmt.bindLong(22, (long)_tmpPassword.getMode().intValue());
                    }
                    if (_tmpPassword.getExpirationTime() == null) {
                        stmt.bindNull(23);
                    } else {
                        stmt.bindLong(23, (long)_tmpPassword.getExpirationTime().intValue());
                    }
                } else {
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                }
                TwoFAEntity _tmpTwoFA = value.getTwoFA();
                if (_tmpTwoFA != null) {
                    if (_tmpTwoFA.getEnabled() == null) {
                        stmt.bindNull(24);
                    } else {
                        stmt.bindLong(24, (long)_tmpTwoFA.getEnabled().intValue());
                    }
                    if (_tmpTwoFA.getAllowed() == null) {
                        stmt.bindNull(25);
                    } else {
                        stmt.bindLong(25, (long)_tmpTwoFA.getAllowed().intValue());
                    }
                    if (_tmpTwoFA.getExpirationTime() == null) {
                        stmt.bindNull(26);
                    } else {
                        stmt.bindLong(26, (long)_tmpTwoFA.getExpirationTime().intValue());
                    }
                    String _tmp_3 = UserSettingsDao_Impl.this.__userSettingsConverters.fromListOfU2FKeyEntityToString(_tmpTwoFA.getU2fKeys());
                    if (_tmp_3 == null) {
                        stmt.bindNull(27);
                    } else {
                        stmt.bindString(27, _tmp_3);
                    }
                } else {
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                }
                FlagsEntity _tmpFlags = value.getFlags();
                if (_tmpFlags != null) {
                    Integer _tmp_4;
                    Integer n3 = _tmpFlags.getWelcomed() == null ? null : (_tmp_4 = Integer.valueOf(_tmpFlags.getWelcomed() != false ? 1 : 0));
                    if (_tmp_4 == null) {
                        stmt.bindNull(28);
                    } else {
                        stmt.bindLong(28, (long)_tmp_4.intValue());
                    }
                } else {
                    stmt.bindNull(28);
                }
            }
        };
        this.__deletionAdapterOfUserSettingsEntity = new EntityDeletionOrUpdateAdapter<UserSettingsEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `UserSettingsEntity` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserSettingsEntity value) {
                String _tmp = UserSettingsDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
            }
        };
        this.__updateAdapterOfUserSettingsEntity = new EntityDeletionOrUpdateAdapter<UserSettingsEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `UserSettingsEntity` SET `userId` = ?,`news` = ?,`locale` = ?,`logAuth` = ?,`invoiceText` = ?,`density` = ?,`theme` = ?,`themeType` = ?,`weekStart` = ?,`dateFormat` = ?,`timeFormat` = ?,`welcome` = ?,`earlyAccess` = ?,`email_value` = ?,`email_status` = ?,`email_notify` = ?,`email_reset` = ?,`phone_value` = ?,`phone_status` = ?,`phone_notify` = ?,`phone_reset` = ?,`password_mode` = ?,`password_expirationTime` = ?,`twoFA_enabled` = ?,`twoFA_allowed` = ?,`twoFA_expirationTime` = ?,`twoFA_u2fKeys` = ?,`flags_welcomed` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, UserSettingsEntity value) {
                Integer _tmp_2;
                Integer _tmp_1;
                String _tmp = UserSettingsDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getNews() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindLong(2, (long)value.getNews().intValue());
                }
                if (value.getLocale() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getLocale());
                }
                if (value.getLogAuth() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)value.getLogAuth().intValue());
                }
                if (value.getInvoiceText() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getInvoiceText());
                }
                if (value.getDensity() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)value.getDensity().intValue());
                }
                if (value.getTheme() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getTheme());
                }
                if (value.getThemeType() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, (long)value.getThemeType().intValue());
                }
                if (value.getWeekStart() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)value.getWeekStart().intValue());
                }
                if (value.getDateFormat() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindLong(10, (long)value.getDateFormat().intValue());
                }
                if (value.getTimeFormat() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindLong(11, (long)value.getTimeFormat().intValue());
                }
                Integer n = value.getWelcome() == null ? null : (_tmp_1 = Integer.valueOf(value.getWelcome() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)_tmp_1.intValue());
                }
                Integer n2 = value.getEarlyAccess() == null ? null : (_tmp_2 = Integer.valueOf(value.getEarlyAccess() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, (long)_tmp_2.intValue());
                }
                RecoverySettingEntity _tmpEmail = value.getEmail();
                if (_tmpEmail != null) {
                    if (_tmpEmail.getValue() == null) {
                        stmt.bindNull(14);
                    } else {
                        stmt.bindString(14, _tmpEmail.getValue());
                    }
                    if (_tmpEmail.getStatus() == null) {
                        stmt.bindNull(15);
                    } else {
                        stmt.bindLong(15, (long)_tmpEmail.getStatus().intValue());
                    }
                    if (_tmpEmail.getNotify() == null) {
                        stmt.bindNull(16);
                    } else {
                        stmt.bindLong(16, (long)_tmpEmail.getNotify().intValue());
                    }
                    if (_tmpEmail.getReset() == null) {
                        stmt.bindNull(17);
                    } else {
                        stmt.bindLong(17, (long)_tmpEmail.getReset().intValue());
                    }
                } else {
                    stmt.bindNull(14);
                    stmt.bindNull(15);
                    stmt.bindNull(16);
                    stmt.bindNull(17);
                }
                RecoverySettingEntity _tmpPhone = value.getPhone();
                if (_tmpPhone != null) {
                    if (_tmpPhone.getValue() == null) {
                        stmt.bindNull(18);
                    } else {
                        stmt.bindString(18, _tmpPhone.getValue());
                    }
                    if (_tmpPhone.getStatus() == null) {
                        stmt.bindNull(19);
                    } else {
                        stmt.bindLong(19, (long)_tmpPhone.getStatus().intValue());
                    }
                    if (_tmpPhone.getNotify() == null) {
                        stmt.bindNull(20);
                    } else {
                        stmt.bindLong(20, (long)_tmpPhone.getNotify().intValue());
                    }
                    if (_tmpPhone.getReset() == null) {
                        stmt.bindNull(21);
                    } else {
                        stmt.bindLong(21, (long)_tmpPhone.getReset().intValue());
                    }
                } else {
                    stmt.bindNull(18);
                    stmt.bindNull(19);
                    stmt.bindNull(20);
                    stmt.bindNull(21);
                }
                PasswordEntity _tmpPassword = value.getPassword();
                if (_tmpPassword != null) {
                    if (_tmpPassword.getMode() == null) {
                        stmt.bindNull(22);
                    } else {
                        stmt.bindLong(22, (long)_tmpPassword.getMode().intValue());
                    }
                    if (_tmpPassword.getExpirationTime() == null) {
                        stmt.bindNull(23);
                    } else {
                        stmt.bindLong(23, (long)_tmpPassword.getExpirationTime().intValue());
                    }
                } else {
                    stmt.bindNull(22);
                    stmt.bindNull(23);
                }
                TwoFAEntity _tmpTwoFA = value.getTwoFA();
                if (_tmpTwoFA != null) {
                    if (_tmpTwoFA.getEnabled() == null) {
                        stmt.bindNull(24);
                    } else {
                        stmt.bindLong(24, (long)_tmpTwoFA.getEnabled().intValue());
                    }
                    if (_tmpTwoFA.getAllowed() == null) {
                        stmt.bindNull(25);
                    } else {
                        stmt.bindLong(25, (long)_tmpTwoFA.getAllowed().intValue());
                    }
                    if (_tmpTwoFA.getExpirationTime() == null) {
                        stmt.bindNull(26);
                    } else {
                        stmt.bindLong(26, (long)_tmpTwoFA.getExpirationTime().intValue());
                    }
                    String _tmp_3 = UserSettingsDao_Impl.this.__userSettingsConverters.fromListOfU2FKeyEntityToString(_tmpTwoFA.getU2fKeys());
                    if (_tmp_3 == null) {
                        stmt.bindNull(27);
                    } else {
                        stmt.bindString(27, _tmp_3);
                    }
                } else {
                    stmt.bindNull(24);
                    stmt.bindNull(25);
                    stmt.bindNull(26);
                    stmt.bindNull(27);
                }
                FlagsEntity _tmpFlags = value.getFlags();
                if (_tmpFlags != null) {
                    Integer _tmp_4;
                    Integer n3 = _tmpFlags.getWelcomed() == null ? null : (_tmp_4 = Integer.valueOf(_tmpFlags.getWelcomed() != false ? 1 : 0));
                    if (_tmp_4 == null) {
                        stmt.bindNull(28);
                    } else {
                        stmt.bindLong(28, (long)_tmp_4.intValue());
                    }
                } else {
                    stmt.bindNull(28);
                }
                String _tmp_5 = UserSettingsDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_5 == null) {
                    stmt.bindNull(29);
                } else {
                    stmt.bindString(29, _tmp_5);
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM UserSettingsEntity WHERE userId = ?";
                return "DELETE FROM UserSettingsEntity WHERE userId = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM UserSettingsEntity";
                return "DELETE FROM UserSettingsEntity";
            }
        };
    }

    public Object insertOrIgnore(final UserSettingsEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                UserSettingsDao_Impl.this.__db.beginTransaction();
                try {
                    UserSettingsDao_Impl.this.__insertionAdapterOfUserSettingsEntity.insert((Object[])entities);
                    UserSettingsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserSettingsDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final UserSettingsEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                UserSettingsDao_Impl.this.__db.beginTransaction();
                try {
                    UserSettingsDao_Impl.this.__deletionAdapterOfUserSettingsEntity.handleMultiple((Object[])entities);
                    UserSettingsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserSettingsDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final UserSettingsEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                UserSettingsDao_Impl.this.__db.beginTransaction();
                try {
                    UserSettingsDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += UserSettingsDao_Impl.this.__updateAdapterOfUserSettingsEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    UserSettingsDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final UserSettingsEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return UserSettingsDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object delete(final UserId userId, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = UserSettingsDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                String _tmp = UserSettingsDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                UserSettingsDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    UserSettingsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserSettingsDao_Impl.this.__db.endTransaction();
                    UserSettingsDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, arg1);
    }

    public Object deleteAll(Continuation<? super Unit> arg0) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = UserSettingsDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                UserSettingsDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    UserSettingsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    UserSettingsDao_Impl.this.__db.endTransaction();
                    UserSettingsDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, arg0);
    }

    public Flow<UserSettingsEntity> observeByUserId(UserId userId) {
        String _sql = "SELECT * FROM UserSettingsEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM UserSettingsEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"UserSettingsEntity"}, (Callable)new Callable<UserSettingsEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserSettingsEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserSettingsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    UserSettingsEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfNews = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"news");
                    int _cursorIndexOfLocale = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locale");
                    int _cursorIndexOfLogAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logAuth");
                    int _cursorIndexOfInvoiceText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"invoiceText");
                    int _cursorIndexOfDensity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"density");
                    int _cursorIndexOfTheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"theme");
                    int _cursorIndexOfThemeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"themeType");
                    int _cursorIndexOfWeekStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"weekStart");
                    int _cursorIndexOfDateFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateFormat");
                    int _cursorIndexOfTimeFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeFormat");
                    int _cursorIndexOfWelcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"welcome");
                    int _cursorIndexOfEarlyAccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"earlyAccess");
                    int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email_value");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email_status");
                    int _cursorIndexOfNotify = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email_notify");
                    int _cursorIndexOfReset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email_reset");
                    int _cursorIndexOfValue_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phone_value");
                    int _cursorIndexOfStatus_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phone_status");
                    int _cursorIndexOfNotify_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phone_notify");
                    int _cursorIndexOfReset_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phone_reset");
                    int _cursorIndexOfMode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"password_mode");
                    int _cursorIndexOfExpirationTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"password_expirationTime");
                    int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"twoFA_enabled");
                    int _cursorIndexOfAllowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"twoFA_allowed");
                    int _cursorIndexOfExpirationTime_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"twoFA_expirationTime");
                    int _cursorIndexOfU2fKeys = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"twoFA_u2fKeys");
                    int _cursorIndexOfWelcomed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flags_welcomed");
                    if (_cursor.moveToFirst()) {
                        FlagsEntity _tmpFlags;
                        TwoFAEntity _tmpTwoFA;
                        PasswordEntity _tmpPassword;
                        RecoverySettingEntity _tmpPhone;
                        RecoverySettingEntity _tmpEmail;
                        Boolean _tmpEarlyAccess;
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = UserSettingsDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        Integer _tmpNews = _cursor.isNull(_cursorIndexOfNews) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNews));
                        String _tmpLocale = _cursor.isNull(_cursorIndexOfLocale) ? null : _cursor.getString(_cursorIndexOfLocale);
                        Integer _tmpLogAuth = _cursor.isNull(_cursorIndexOfLogAuth) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfLogAuth));
                        String _tmpInvoiceText = _cursor.isNull(_cursorIndexOfInvoiceText) ? null : _cursor.getString(_cursorIndexOfInvoiceText);
                        Integer _tmpDensity = _cursor.isNull(_cursorIndexOfDensity) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDensity));
                        String _tmpTheme = _cursor.isNull(_cursorIndexOfTheme) ? null : _cursor.getString(_cursorIndexOfTheme);
                        Integer _tmpThemeType = _cursor.isNull(_cursorIndexOfThemeType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfThemeType));
                        Integer _tmpWeekStart = _cursor.isNull(_cursorIndexOfWeekStart) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfWeekStart));
                        Integer _tmpDateFormat = _cursor.isNull(_cursorIndexOfDateFormat) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDateFormat));
                        Integer _tmpTimeFormat = _cursor.isNull(_cursorIndexOfTimeFormat) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTimeFormat));
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfWelcome) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfWelcome));
                        Boolean _tmpWelcome = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                        Integer _tmp_3 = _cursor.isNull(_cursorIndexOfEarlyAccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfEarlyAccess));
                        Boolean bl = _tmp_3 == null ? null : (_tmpEarlyAccess = Boolean.valueOf(_tmp_3 != 0));
                        if (!(_cursor.isNull(_cursorIndexOfValue) && _cursor.isNull(_cursorIndexOfStatus) && _cursor.isNull(_cursorIndexOfNotify) && _cursor.isNull(_cursorIndexOfReset))) {
                            String _tmpValue = _cursor.isNull(_cursorIndexOfValue) ? null : _cursor.getString(_cursorIndexOfValue);
                            Integer _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                            Integer _tmpNotify = _cursor.isNull(_cursorIndexOfNotify) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNotify));
                            Integer _tmpReset = _cursor.isNull(_cursorIndexOfReset) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfReset));
                            _tmpEmail = new RecoverySettingEntity(_tmpValue, _tmpStatus, _tmpNotify, _tmpReset);
                        } else {
                            _tmpEmail = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfValue_1) && _cursor.isNull(_cursorIndexOfStatus_1) && _cursor.isNull(_cursorIndexOfNotify_1) && _cursor.isNull(_cursorIndexOfReset_1))) {
                            String _tmpValue_1 = _cursor.isNull(_cursorIndexOfValue_1) ? null : _cursor.getString(_cursorIndexOfValue_1);
                            Integer _tmpStatus_1 = _cursor.isNull(_cursorIndexOfStatus_1) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus_1));
                            Integer _tmpNotify_1 = _cursor.isNull(_cursorIndexOfNotify_1) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNotify_1));
                            Integer _tmpReset_1 = _cursor.isNull(_cursorIndexOfReset_1) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfReset_1));
                            _tmpPhone = new RecoverySettingEntity(_tmpValue_1, _tmpStatus_1, _tmpNotify_1, _tmpReset_1);
                        } else {
                            _tmpPhone = null;
                        }
                        if (!_cursor.isNull(_cursorIndexOfMode) || !_cursor.isNull(_cursorIndexOfExpirationTime)) {
                            Integer _tmpMode = _cursor.isNull(_cursorIndexOfMode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMode));
                            Integer _tmpExpirationTime = _cursor.isNull(_cursorIndexOfExpirationTime) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExpirationTime));
                            _tmpPassword = new PasswordEntity(_tmpMode, _tmpExpirationTime);
                        } else {
                            _tmpPassword = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfEnabled) && _cursor.isNull(_cursorIndexOfAllowed) && _cursor.isNull(_cursorIndexOfExpirationTime_1) && _cursor.isNull(_cursorIndexOfU2fKeys))) {
                            Integer _tmpEnabled = _cursor.isNull(_cursorIndexOfEnabled) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfEnabled));
                            Integer _tmpAllowed = _cursor.isNull(_cursorIndexOfAllowed) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfAllowed));
                            Integer _tmpExpirationTime_1 = _cursor.isNull(_cursorIndexOfExpirationTime_1) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExpirationTime_1));
                            String _tmp_4 = _cursor.isNull(_cursorIndexOfU2fKeys) ? null : _cursor.getString(_cursorIndexOfU2fKeys);
                            List _tmpU2fKeys = UserSettingsDao_Impl.this.__userSettingsConverters.fromStringToListOfU2FKeyEntity(_tmp_4);
                            _tmpTwoFA = new TwoFAEntity(_tmpEnabled, _tmpAllowed, _tmpExpirationTime_1, _tmpU2fKeys);
                        } else {
                            _tmpTwoFA = null;
                        }
                        if (!_cursor.isNull(_cursorIndexOfWelcomed)) {
                            Integer _tmp_5 = _cursor.isNull(_cursorIndexOfWelcomed) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfWelcomed));
                            Boolean _tmpWelcomed = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                            _tmpFlags = new FlagsEntity(_tmpWelcomed);
                        } else {
                            _tmpFlags = null;
                        }
                        _result = new UserSettingsEntity(_tmpUserId, _tmpEmail, _tmpPhone, _tmpPassword, _tmpTwoFA, _tmpNews, _tmpLocale, _tmpLogAuth, _tmpInvoiceText, _tmpDensity, _tmpTheme, _tmpThemeType, _tmpWeekStart, _tmpDateFormat, _tmpTimeFormat, _tmpWelcome, _tmpEarlyAccess, _tmpFlags);
                    } else {
                        _result = null;
                    }
                    UserSettingsEntity userSettingsEntity = _result;
                    return userSettingsEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getByUserId(UserId userId, Continuation<? super UserSettingsEntity> arg1) {
        String _sql = "SELECT * FROM UserSettingsEntity WHERE userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM UserSettingsEntity WHERE userId = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<UserSettingsEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserSettingsEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)UserSettingsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    UserSettingsEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfNews = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"news");
                    int _cursorIndexOfLocale = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locale");
                    int _cursorIndexOfLogAuth = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"logAuth");
                    int _cursorIndexOfInvoiceText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"invoiceText");
                    int _cursorIndexOfDensity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"density");
                    int _cursorIndexOfTheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"theme");
                    int _cursorIndexOfThemeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"themeType");
                    int _cursorIndexOfWeekStart = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"weekStart");
                    int _cursorIndexOfDateFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"dateFormat");
                    int _cursorIndexOfTimeFormat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeFormat");
                    int _cursorIndexOfWelcome = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"welcome");
                    int _cursorIndexOfEarlyAccess = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"earlyAccess");
                    int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email_value");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email_status");
                    int _cursorIndexOfNotify = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email_notify");
                    int _cursorIndexOfReset = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email_reset");
                    int _cursorIndexOfValue_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phone_value");
                    int _cursorIndexOfStatus_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phone_status");
                    int _cursorIndexOfNotify_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phone_notify");
                    int _cursorIndexOfReset_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"phone_reset");
                    int _cursorIndexOfMode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"password_mode");
                    int _cursorIndexOfExpirationTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"password_expirationTime");
                    int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"twoFA_enabled");
                    int _cursorIndexOfAllowed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"twoFA_allowed");
                    int _cursorIndexOfExpirationTime_1 = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"twoFA_expirationTime");
                    int _cursorIndexOfU2fKeys = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"twoFA_u2fKeys");
                    int _cursorIndexOfWelcomed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flags_welcomed");
                    if (_cursor.moveToFirst()) {
                        FlagsEntity _tmpFlags;
                        TwoFAEntity _tmpTwoFA;
                        PasswordEntity _tmpPassword;
                        RecoverySettingEntity _tmpPhone;
                        RecoverySettingEntity _tmpEmail;
                        Boolean _tmpEarlyAccess;
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = UserSettingsDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        Integer _tmpNews = _cursor.isNull(_cursorIndexOfNews) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNews));
                        String _tmpLocale = _cursor.isNull(_cursorIndexOfLocale) ? null : _cursor.getString(_cursorIndexOfLocale);
                        Integer _tmpLogAuth = _cursor.isNull(_cursorIndexOfLogAuth) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfLogAuth));
                        String _tmpInvoiceText = _cursor.isNull(_cursorIndexOfInvoiceText) ? null : _cursor.getString(_cursorIndexOfInvoiceText);
                        Integer _tmpDensity = _cursor.isNull(_cursorIndexOfDensity) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDensity));
                        String _tmpTheme = _cursor.isNull(_cursorIndexOfTheme) ? null : _cursor.getString(_cursorIndexOfTheme);
                        Integer _tmpThemeType = _cursor.isNull(_cursorIndexOfThemeType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfThemeType));
                        Integer _tmpWeekStart = _cursor.isNull(_cursorIndexOfWeekStart) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfWeekStart));
                        Integer _tmpDateFormat = _cursor.isNull(_cursorIndexOfDateFormat) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfDateFormat));
                        Integer _tmpTimeFormat = _cursor.isNull(_cursorIndexOfTimeFormat) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfTimeFormat));
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfWelcome) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfWelcome));
                        Boolean _tmpWelcome = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                        Integer _tmp_3 = _cursor.isNull(_cursorIndexOfEarlyAccess) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfEarlyAccess));
                        Boolean bl = _tmp_3 == null ? null : (_tmpEarlyAccess = Boolean.valueOf(_tmp_3 != 0));
                        if (!(_cursor.isNull(_cursorIndexOfValue) && _cursor.isNull(_cursorIndexOfStatus) && _cursor.isNull(_cursorIndexOfNotify) && _cursor.isNull(_cursorIndexOfReset))) {
                            String _tmpValue = _cursor.isNull(_cursorIndexOfValue) ? null : _cursor.getString(_cursorIndexOfValue);
                            Integer _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                            Integer _tmpNotify = _cursor.isNull(_cursorIndexOfNotify) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNotify));
                            Integer _tmpReset = _cursor.isNull(_cursorIndexOfReset) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfReset));
                            _tmpEmail = new RecoverySettingEntity(_tmpValue, _tmpStatus, _tmpNotify, _tmpReset);
                        } else {
                            _tmpEmail = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfValue_1) && _cursor.isNull(_cursorIndexOfStatus_1) && _cursor.isNull(_cursorIndexOfNotify_1) && _cursor.isNull(_cursorIndexOfReset_1))) {
                            String _tmpValue_1 = _cursor.isNull(_cursorIndexOfValue_1) ? null : _cursor.getString(_cursorIndexOfValue_1);
                            Integer _tmpStatus_1 = _cursor.isNull(_cursorIndexOfStatus_1) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus_1));
                            Integer _tmpNotify_1 = _cursor.isNull(_cursorIndexOfNotify_1) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNotify_1));
                            Integer _tmpReset_1 = _cursor.isNull(_cursorIndexOfReset_1) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfReset_1));
                            _tmpPhone = new RecoverySettingEntity(_tmpValue_1, _tmpStatus_1, _tmpNotify_1, _tmpReset_1);
                        } else {
                            _tmpPhone = null;
                        }
                        if (!_cursor.isNull(_cursorIndexOfMode) || !_cursor.isNull(_cursorIndexOfExpirationTime)) {
                            Integer _tmpMode = _cursor.isNull(_cursorIndexOfMode) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMode));
                            Integer _tmpExpirationTime = _cursor.isNull(_cursorIndexOfExpirationTime) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExpirationTime));
                            _tmpPassword = new PasswordEntity(_tmpMode, _tmpExpirationTime);
                        } else {
                            _tmpPassword = null;
                        }
                        if (!(_cursor.isNull(_cursorIndexOfEnabled) && _cursor.isNull(_cursorIndexOfAllowed) && _cursor.isNull(_cursorIndexOfExpirationTime_1) && _cursor.isNull(_cursorIndexOfU2fKeys))) {
                            Integer _tmpEnabled = _cursor.isNull(_cursorIndexOfEnabled) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfEnabled));
                            Integer _tmpAllowed = _cursor.isNull(_cursorIndexOfAllowed) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfAllowed));
                            Integer _tmpExpirationTime_1 = _cursor.isNull(_cursorIndexOfExpirationTime_1) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfExpirationTime_1));
                            String _tmp_4 = _cursor.isNull(_cursorIndexOfU2fKeys) ? null : _cursor.getString(_cursorIndexOfU2fKeys);
                            List _tmpU2fKeys = UserSettingsDao_Impl.this.__userSettingsConverters.fromStringToListOfU2FKeyEntity(_tmp_4);
                            _tmpTwoFA = new TwoFAEntity(_tmpEnabled, _tmpAllowed, _tmpExpirationTime_1, _tmpU2fKeys);
                        } else {
                            _tmpTwoFA = null;
                        }
                        if (!_cursor.isNull(_cursorIndexOfWelcomed)) {
                            Integer _tmp_5 = _cursor.isNull(_cursorIndexOfWelcomed) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfWelcomed));
                            Boolean _tmpWelcomed = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                            _tmpFlags = new FlagsEntity(_tmpWelcomed);
                        } else {
                            _tmpFlags = null;
                        }
                        _result = new UserSettingsEntity(_tmpUserId, _tmpEmail, _tmpPhone, _tmpPassword, _tmpTwoFA, _tmpNews, _tmpLocale, _tmpLogAuth, _tmpInvoiceText, _tmpDensity, _tmpTheme, _tmpThemeType, _tmpWeekStart, _tmpDateFormat, _tmpTimeFormat, _tmpWelcome, _tmpEarlyAccess, _tmpFlags);
                    } else {
                        _result = null;
                    }
                    UserSettingsEntity userSettingsEntity = _result;
                    return userSettingsEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

