/*
 * Decompiled with CFR 0.152.
 */
package me.proton.core.account.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.account.data.db.AccountMetadataDao;
import me.proton.core.account.data.entity.AccountMetadataEntity;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.Product;
import me.proton.core.domain.entity.UserId;

public final class AccountMetadataDao_Impl
extends AccountMetadataDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AccountMetadataEntity> __insertionAdapterOfAccountMetadataEntity;
    private final CommonConverters __commonConverters = new CommonConverters();
    private final EntityDeletionOrUpdateAdapter<AccountMetadataEntity> __deletionAdapterOfAccountMetadataEntity;
    private final EntityDeletionOrUpdateAdapter<AccountMetadataEntity> __updateAdapterOfAccountMetadataEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMigrations;
    private final SharedSQLiteStatement __preparedStmtOfDelete;

    public AccountMetadataDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAccountMetadataEntity = new EntityInsertionAdapter<AccountMetadataEntity>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `AccountMetadataEntity` (`userId`,`product`,`primaryAtUtc`,`migrations`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AccountMetadataEntity value) {
                String _tmp = AccountMetadataDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = AccountMetadataDao_Impl.this.__commonConverters.fromProductToString(value.getProduct());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                stmt.bindLong(3, value.getPrimaryAtUtc());
                String _tmp_2 = AccountMetadataDao_Impl.this.__commonConverters.fromListOfStringToString(value.getMigrations());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
            }
        };
        this.__deletionAdapterOfAccountMetadataEntity = new EntityDeletionOrUpdateAdapter<AccountMetadataEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `AccountMetadataEntity` WHERE `userId` = ? AND `product` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AccountMetadataEntity value) {
                String _tmp = AccountMetadataDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = AccountMetadataDao_Impl.this.__commonConverters.fromProductToString(value.getProduct());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
            }
        };
        this.__updateAdapterOfAccountMetadataEntity = new EntityDeletionOrUpdateAdapter<AccountMetadataEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `AccountMetadataEntity` SET `userId` = ?,`product` = ?,`primaryAtUtc` = ?,`migrations` = ? WHERE `userId` = ? AND `product` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AccountMetadataEntity value) {
                String _tmp = AccountMetadataDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                String _tmp_1 = AccountMetadataDao_Impl.this.__commonConverters.fromProductToString(value.getProduct());
                if (_tmp_1 == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp_1);
                }
                stmt.bindLong(3, value.getPrimaryAtUtc());
                String _tmp_2 = AccountMetadataDao_Impl.this.__commonConverters.fromListOfStringToString(value.getMigrations());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = AccountMetadataDao_Impl.this.__commonConverters.fromUserIdToString(value.getUserId());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                String _tmp_4 = AccountMetadataDao_Impl.this.__commonConverters.fromProductToString(value.getProduct());
                if (_tmp_4 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_4);
                }
            }
        };
        this.__preparedStmtOfUpdateMigrations = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE AccountMetadataEntity SET migrations = ? WHERE product = ? AND userId = ?";
                return "UPDATE AccountMetadataEntity SET migrations = ? WHERE product = ? AND userId = ?";
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM AccountMetadataEntity WHERE product = ? AND userId = ?";
                return "DELETE FROM AccountMetadataEntity WHERE product = ? AND userId = ?";
            }
        };
    }

    public Object insertOrIgnore(final AccountMetadataEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AccountMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    AccountMetadataDao_Impl.this.__insertionAdapterOfAccountMetadataEntity.insert((Object[])entities);
                    AccountMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountMetadataDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object delete(final AccountMetadataEntity[] entities, Continuation<? super Unit> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AccountMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    AccountMetadataDao_Impl.this.__deletionAdapterOfAccountMetadataEntity.handleMultiple((Object[])entities);
                    AccountMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountMetadataDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object update(final AccountMetadataEntity[] entities, Continuation<? super Integer> arg1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int _total = 0;
                AccountMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    AccountMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Integer n = _total += AccountMetadataDao_Impl.this.__updateAdapterOfAccountMetadataEntity.handleMultiple((Object[])entities);
                    return n;
                }
                finally {
                    AccountMetadataDao_Impl.this.__db.endTransaction();
                }
            }
        }, arg1);
    }

    public Object insertOrUpdate(final AccountMetadataEntity[] entities, Continuation<? super Unit> $completion) {
        return RoomDatabaseKt.withTransaction((RoomDatabase)this.__db, (Function1)new Function1<Continuation<? super Unit>, Object>(){

            public Object invoke(Continuation<? super Unit> __cont) {
                return AccountMetadataDao_Impl.super.insertOrUpdate(entities, __cont);
            }
        }, $completion);
    }

    public Object updateMigrations(final Product product, final UserId userId, final List<String> migrations, Continuation<? super Unit> arg3) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountMetadataDao_Impl.this.__preparedStmtOfUpdateMigrations.acquire();
                int _argIndex = 1;
                String _tmp = AccountMetadataDao_Impl.this.__commonConverters.fromListOfStringToString(migrations);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                String _tmp_1 = AccountMetadataDao_Impl.this.__commonConverters.fromProductToString(product);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp_1);
                }
                _argIndex = 3;
                String _tmp_2 = AccountMetadataDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp_2);
                }
                AccountMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountMetadataDao_Impl.this.__db.endTransaction();
                    AccountMetadataDao_Impl.this.__preparedStmtOfUpdateMigrations.release(_stmt);
                }
            }
        }, arg3);
    }

    public Object delete(final Product product, final UserId userId, Continuation<? super Unit> arg2) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AccountMetadataDao_Impl.this.__preparedStmtOfDelete.acquire();
                int _argIndex = 1;
                String _tmp = AccountMetadataDao_Impl.this.__commonConverters.fromProductToString(product);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp);
                }
                _argIndex = 2;
                String _tmp_1 = AccountMetadataDao_Impl.this.__commonConverters.fromUserIdToString(userId);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, _tmp_1);
                }
                AccountMetadataDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AccountMetadataDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AccountMetadataDao_Impl.this.__db.endTransaction();
                    AccountMetadataDao_Impl.this.__preparedStmtOfDelete.release(_stmt);
                }
            }
        }, arg2);
    }

    public Flow<AccountMetadataEntity> observeLatestPrimary(Product product) {
        String _sql = "SELECT * FROM AccountMetadataEntity WHERE product = ? AND primaryAtUtc = (SELECT MAX(primaryAtUtc) FROM AccountMetadataEntity) LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AccountMetadataEntity WHERE product = ? AND primaryAtUtc = (SELECT MAX(primaryAtUtc) FROM AccountMetadataEntity) LIMIT 1", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromProductToString(product);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"AccountMetadataEntity"}, (Callable)new Callable<AccountMetadataEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AccountMetadataEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)AccountMetadataDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    AccountMetadataEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"product");
                    int _cursorIndexOfPrimaryAtUtc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryAtUtc");
                    int _cursorIndexOfMigrations = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"migrations");
                    if (_cursor.moveToFirst()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AccountMetadataDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfProduct) ? null : _cursor.getString(_cursorIndexOfProduct);
                        Product _tmpProduct = AccountMetadataDao_Impl.this.__commonConverters.fromStringToProduct(_tmp_2);
                        long _tmpPrimaryAtUtc = _cursor.getLong(_cursorIndexOfPrimaryAtUtc);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfMigrations) ? null : _cursor.getString(_cursorIndexOfMigrations);
                        List _tmpMigrations = AccountMetadataDao_Impl.this.__commonConverters.fromStringToListOfString(_tmp_3);
                        _result = new AccountMetadataEntity(_tmpUserId, _tmpProduct, _tmpPrimaryAtUtc, _tmpMigrations);
                    } else {
                        _result = null;
                    }
                    AccountMetadataEntity accountMetadataEntity = _result;
                    return accountMetadataEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public Object getAllDescending(Product product, Continuation<? super List<AccountMetadataEntity>> arg1) {
        String _sql = "SELECT * FROM AccountMetadataEntity WHERE product = ? ORDER BY primaryAtUtc DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AccountMetadataEntity WHERE product = ? ORDER BY primaryAtUtc DESC", (int)1);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromProductToString(product);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<AccountMetadataEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AccountMetadataEntity> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AccountMetadataDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"product");
                    int _cursorIndexOfPrimaryAtUtc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryAtUtc");
                    int _cursorIndexOfMigrations = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"migrations");
                    ArrayList<AccountMetadataEntity> _result = new ArrayList<AccountMetadataEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AccountMetadataDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_1);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfProduct) ? null : _cursor.getString(_cursorIndexOfProduct);
                        Product _tmpProduct = AccountMetadataDao_Impl.this.__commonConverters.fromStringToProduct(_tmp_2);
                        long _tmpPrimaryAtUtc = _cursor.getLong(_cursorIndexOfPrimaryAtUtc);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfMigrations) ? null : _cursor.getString(_cursorIndexOfMigrations);
                        List _tmpMigrations = AccountMetadataDao_Impl.this.__commonConverters.fromStringToListOfString(_tmp_3);
                        AccountMetadataEntity _item = new AccountMetadataEntity(_tmpUserId, _tmpProduct, _tmpPrimaryAtUtc, _tmpMigrations);
                        _result.add(_item);
                    }
                    ArrayList<AccountMetadataEntity> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg1);
    }

    public Object getByUserId(Product product, UserId userId, Continuation<? super AccountMetadataEntity> arg2) {
        String _sql = "SELECT * FROM AccountMetadataEntity WHERE product = ? AND userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM AccountMetadataEntity WHERE product = ? AND userId = ?", (int)2);
        int _argIndex = 1;
        String _tmp = this.__commonConverters.fromProductToString(product);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        String _tmp_1 = this.__commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_1);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<AccountMetadataEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AccountMetadataEntity call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AccountMetadataDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    AccountMetadataEntity _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfProduct = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"product");
                    int _cursorIndexOfPrimaryAtUtc = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"primaryAtUtc");
                    int _cursorIndexOfMigrations = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"migrations");
                    if (_cursor.moveToFirst()) {
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        UserId _tmpUserId = AccountMetadataDao_Impl.this.__commonConverters.fromStringToUserId(_tmp_2);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfProduct) ? null : _cursor.getString(_cursorIndexOfProduct);
                        Product _tmpProduct = AccountMetadataDao_Impl.this.__commonConverters.fromStringToProduct(_tmp_3);
                        long _tmpPrimaryAtUtc = _cursor.getLong(_cursorIndexOfPrimaryAtUtc);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfMigrations) ? null : _cursor.getString(_cursorIndexOfMigrations);
                        List _tmpMigrations = AccountMetadataDao_Impl.this.__commonConverters.fromStringToListOfString(_tmp_4);
                        _result = new AccountMetadataEntity(_tmpUserId, _tmpProduct, _tmpPrimaryAtUtc, _tmpMigrations);
                    } else {
                        _result = null;
                    }
                    AccountMetadataEntity accountMetadataEntity = _result;
                    return accountMetadataEntity;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, arg2);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

